/*
Copyright 2008-2009 Christophe Clmence

This file is part of RobotClic.

RobotClic is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RobotClic is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RobotClic. If not, see <http://www.gnu.org/licenses/>.
*/

import javax.swing.*;
import java.awt.*;
import java.awt.image.*;

/**
 * @author Christophe Clmence (Kistrof)
 * Logiciel distribu sous licence GNU GPL v3
 * Vous pouvez le copier et le distribuer librement
 */
public class PreviewPanel extends JPanel
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -8929330782450979412L;
	private BufferedImage fond_original;
	private BufferedImage fond;
	private double ratio = 0.5;
	
	/**
	 * 
	 * @param screen
	 */
	public PreviewPanel(BufferedImage screen)
	{
		super();
        updateBackgroud(screen);
 	}
	
	/**
	 * 
	 * @param screen
	 */
	public void updateBackgroud(BufferedImage screen)
	{
		fond_original = screen;
		java.awt.geom.AffineTransform tx = new java.awt.geom.AffineTransform();
        tx.scale(ratio, ratio);
        AffineTransformOp op = new AffineTransformOp(tx, AffineTransformOp.TYPE_BILINEAR);
        fond = new BufferedImage((int)(screen.getWidth() * ratio), (int)(screen.getHeight() * ratio), screen.getType());
        op.filter(screen, fond);
        this.setSize(fond.getWidth(), fond.getHeight());
	}
	
	/**
	 * 
	 */
	public void paintComponent(Graphics g)
	{
		g.drawImage(fond, 0, 0, null);
	}
	
	/**
	 * 
	 * @param p
	 */
	public void dessinerPoint(PointClic p)
	{
		// Dessine par dessus l'image de fond
		Graphics2D g2d = fond.createGraphics();
		g2d.setColor(Color.red);
		// Petit carr de 7x7 autour des coordonnes du PointClic donn
		g2d.drawRect((int)(p.getX() * ratio - 4), (int)(p.getY() * ratio - 4), 7, 7);
		g2d.dispose();
	}
	
	/**
	 * 
	 *
	 */
	public void reset()
	{
		updateBackgroud(fond_original);
		this.updateUI();
	}
	
}
