/*
Copyright 2008-2009 Christophe Clmence

This file is part of RobotClic.

RobotClic is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RobotClic is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RobotClic. If not, see <http://www.gnu.org/licenses/>.
*/

import java.util.LinkedList;
import java.io.*;

/**
 * @author Christophe Clmence (Kistrof)
 * Logiciel distribu sous licence GNU GPL v3
 * Vous pouvez le copier et le distribuer librement
 */
public class PointClicList extends LinkedList<PointClic>
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 8086876146633203828L;
	public static final String ext = "seq";

	public PointClicList()
	{
		super();
	}
	
	/**
	 * Charge un fichier de squence
	 * @param filename Nom du fichier de sauvegarde
	 * @return PointClicList
	 */
	public static PointClicList loadFile(String filename) throws FileNotFoundException, IOException, NumberFormatException
	{
		FileReader reader = new FileReader(filename);
		BufferedReader in = new BufferedReader(reader);
		PointClicList liste = new PointClicList();
		String ligne = "";
		int i = 1;
		while ((ligne = in.readLine()) != null)
		{
			String[] tab = ligne.split(",");
			if (tab.length == 4)
			{
				int x = Integer.parseInt(tab[0]);
				int y = Integer.parseInt(tab[1]);
				int tempo = Integer.parseInt(tab[2]);
				int bouton = Integer.parseInt(tab[3]);
				PointClic pc = new PointClic(x, y, tempo, i++, bouton);
				liste.add(pc);
			}
			else
				throw new IOException("Ligne invalide");
		}
		in.close();
		reader.close();
		return liste;
	}
	
	/**
	 * Enregistre la squence dans un fichier
	 * @param filename Nom du fichier de sauvegarde
	 */
	public void saveFile(String filename) throws IOException
	{
		FileWriter writer = new FileWriter(filename);
		BufferedWriter out = new BufferedWriter(writer);
		int nb = this.size();
		for (int i = 0 ; i < nb ; i++)
		{
			PointClic pc = this.get(i);
			String ligne = pc.getX()+","+pc.getY()+","+pc.getTempo()+","+pc.getBouton();
			out.write(ligne);
			out.newLine();
		}
		out.close();
		writer.close();
	}
	
}
