/*
Copyright 2008-2009 Christophe Clmence

This file is part of RobotClic.

RobotClic is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RobotClic is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RobotClic. If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.Point;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.InputEvent;
import java.awt.Toolkit;
import java.awt.Dimension;
import java.io.IOException;

/**
 * @author Christophe Clmence (Kistrof)
 * Logiciel distribu sous licence GNU GPL v3
 * Vous pouvez le copier et le distribuer librement
 */
public class PointClic
{
	private int x, y, tempo, ident, bouton;
	
	private static final Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	
	public static int gauche = InputEvent.BUTTON1_MASK;
	public static int droit = InputEvent.META_MASK;

	public PointClic() throws IOException
	{
		this(0, 0, 0);
	}

	public PointClic(Point p) throws IOException
	{
		this(p.x, p.y, 0);
	}
	
	public PointClic(Point p, int t) throws IOException
	{
		this(p.x, p.y, t);
	}
	
	public PointClic(Point p, int t, int i) throws IOException
	{
		this(p.x, p.y, t, i);
	}
	
	public PointClic(int h, int v) throws IOException
	{
		this(h, v, 0);
	}
	
	public PointClic(int h, int v, int t) throws IOException
	{
		this(h, v, t, 0, gauche);
	}
	
	public PointClic(int h, int v, int t, int i) throws IOException
	{
		this(h, v, t, i, gauche);
	}
	
	/**
	 * Construit un PointClic
	 * @param h Coordonne horizontale
	 * @param v Coordonne verticale
	 * @param t Temporisation avant le clic (en ms)
	 * @param i Identifiant du point
	 * @param b Bouton  cliquer (variable statique de InputEvent)
	 */
	public PointClic(int h, int v, int t, int i, int b) throws IOException
	{
		if (h < dim.width && h >= 0)
			x = h;
		else
			throw new IOException(i+" - ("+h+", "+v+")\nCe point est en dehors de l'cran !");
		if (v < dim.height && v >= 0)
			y = v;
		else
			throw new IOException(i+" - ("+h+", "+v+")\nCe point est en dehors de l'cran !");
		this.setTempo(t);
		this.setButton(b);
		ident = i;
}
	
	/**
	 * Modifie la temporisation du point
	 * @param t Nouvelle temporisation (en ms)
	 */
	public void setTempo(int t)
	{
		if (t >= 0)
			tempo = t;
		else
			tempo = 0;
	}
	
	/**
	 * Modifie le bouton  utiliser
	 * @param b Nouveau bouton (issu de InputEvent)
	 */
	public void setButton(int b)
	{
		bouton = b;
	}
	
	/**
	 * Effectue un clic gauche aprs la temporisation
	 * @throws AWTException
	 */
	public void cliquer() throws AWTException, InterruptedException
	{
		Thread.sleep((long)tempo);
		Robot r = new Robot();
		r.mouseMove(this.x, this.y);
		r.mousePress(this.bouton);
		r.mouseRelease(this.bouton);
	}
	
	/**
	 * Retourne les coordonnes sous la forme "ident - (x, y)"
	 */
	public String toString()
	{
		String b = "G";
		if (bouton == PointClic.droit)
			b = "D";
		return ident+" - ("+x+", "+y+") - "+b+" - "+java.text.NumberFormat.getInstance().format(tempo)+" ms";
	}

	public int getBouton()
	{
		return bouton;
	}

	public int getIdent()
	{
		return ident;
	}

	public int getTempo()
	{
		return tempo;
	}

	public int getX()
	{
		return x;
	}

	public int getY()
	{
		return y;
	}
	
}
