/*
Copyright 2008-2012 Christophe Clmence

This file is part of RobotClic.

RobotClic is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RobotClic is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RobotClic. If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.AWTException;
import java.awt.Point;
import java.util.ListIterator;

import javax.swing.JOptionPane;

public class Cliqueur extends Thread
{
	private RobotClic rb;
	
	public Cliqueur(RobotClic rb)
	{
		super();
		this.rb = rb;
	}
	
	public void run()
	{
		Point origine = rb.getMouseLocation();
		ListIterator<PointClic> it = rb.liste.listIterator();
		try
		{
			while (it.hasNext())
			{
				PointClic p = it.next();
				p.cliquer();
				rb.texte.setText("Point "+(p.getIdent())+" cliqu !");
			}
			if (rb.replace.isSelected())
			{
				Thread.sleep(250);
				rb.robot.mouseMove(origine.x, origine.y);
			}
			rb.texte.setText("Squence termine sans erreurs");
		}
		catch (AWTException ex)
		{
			rb.robot.mouseMove(origine.x, origine.y);
			rb.texte.setText("Erreur ! "+ex.getMessage());
			JOptionPane.showMessageDialog(rb.fenetre, ex.getMessage(), RobotClic.titre_fenetre, JOptionPane.ERROR_MESSAGE);
		}
		catch (InterruptedException ex)
		{
			rb.robot.mouseMove(origine.x, origine.y);
			rb.texte.setText("Squence interrompue !");
			JOptionPane.showMessageDialog(rb.fenetre, "Squence interrompue !", RobotClic.titre_fenetre, JOptionPane.INFORMATION_MESSAGE);
		}
		rb.endSequence();
	}
	
}
