/*
 * Decompiled with CFR 0.152.
 */
import com.melloware.jintellitype.HotkeyListener;
import com.melloware.jintellitype.JIntellitype;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RobotClic
implements KeyListener,
FocusListener {
    private static final String version = "2.7.2";
    private static final String date = "20 ao\u00fbt 2012";
    private static final String website_url = "http://kistrof.free.fr/robotclic/";
    private static final String titre_about = "A propos de RobotClic";
    private static final String titre_update = "Mise \u00e0 jour";
    private static final String titre_changelog = "Historique des versions";
    private static final String titre_licence = "Licence GNU GPL v3";
    private static final String[] about = new String[]{"Version 2.7.2 - 20 ao\u00fbt 2012", "Copyright\u00a9 2008-2012 Christophe Cl\u00e9mence", "", "D\u00e9velopp\u00e9 en Java sous Eclipse 3", "", "Ce logiciel est distribu\u00e9 sous licence GNU GPL v3", "", "http://kistrof.free.fr/robotclic/"};
    private static final String titre_help = "Aide";
    private static final String[] help = new String[]{"[Espace] : ajouter la position de la souris", "[Echap] : terminer l'enregistrement des points", "[Ctrl] + [Alt] + S : stopper la s\u00e9quence en cours", "", "Vous trouverez plus d'aide sur", "http://kistrof.free.fr/robotclic/"};
    public static final String titre_fenetre = "RobotClic v2.7.2";
    public Robot robot;
    public PointClicList liste;
    private Cliqueur cliqueur;
    private JFrame preview_frame;
    private PreviewPanel preview;
    public JFrame fenetre;
    private JPanel panel;
    public JCheckBox replace;
    public JTextField texte;
    private JComboBox<PointClic> combobox;
    private JLabel label_tempo;
    private JLabel label_ms;
    private JSpinner spin_tempo;
    private JButton ok_tempo;
    private TitledBorder bordure_details;
    private JPanel panel_liste;
    private JPanel panel_details;
    private JPanel panel_bas;
    private SpringLayout spring;
    private JRadioButton radio_gauche;
    private JRadioButton radio_droit;
    private ButtonGroup radio_group;
    private JMenuBar barre;
    private JMenu menu_fichier;
    private JMenuItem file_save;
    private JMenuItem file_load;
    private JMenuItem file_quit;
    private JMenu menu_seq;
    private JMenuItem seq_register;
    private JMenuItem seq_launch;
    private JMenuItem seq_reset;
    private JMenu menu_affichage;
    private JCheckBoxMenuItem aff_apercu;
    private JMenuItem aff_update;
    private JMenu menu_help;
    private JMenuItem help_help;
    private JMenuItem help_about;
    private JMenuItem help_update;
    private JMenuItem help_changelog;
    private JMenuItem help_licence;
    public static boolean JIntellitypeEnabled = false;

    public static void main(String[] args) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            RobotClic.setupJIntellitype();
        }
        try {
            new RobotClic();
        }
        catch (AWTException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), titre_fenetre, 0);
        }
    }

    private static void setupJIntellitype() {
        block21: {
            String arch = System.getProperty("sun.arch.data.model");
            File f = new File("JIntellitype.dll");
            if (f.exists()) {
                f.delete();
            }
            AbstractInterruptibleChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                try {
                    in = new FileInputStream("JIntellitype" + arch + ".dll").getChannel();
                    out = new FileOutputStream("JIntellitype.dll").getChannel();
                    ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
                    JIntellitypeEnabled = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (out == null) break block21;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void pause(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private RobotClic() throws AWTException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), titre_fenetre, 0);
        }
        this.robot = new Robot();
        this.preview = new PreviewPanel(this.robot.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize())));
        this.preview_frame = new JFrame("RobotClic - Aper\u00e7u");
        this.preview_frame.setContentPane(this.preview);
        this.preview_frame.setResizable(false);
        this.preview_frame.setSize(this.preview.getWidth() + 15, this.preview.getHeight() + 35);
        this.preview_frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RobotClic.this.aff_apercu.setState(false);
            }
        });
        this.ok_tempo = new JButton("Tous");
        this.ok_tempo.setEnabled(false);
        this.ok_tempo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RobotClic.this.combobox.getItemCount() > 0) {
                    RobotClic.this.appliquerTempoPourTous();
                }
            }
        });
        this.combobox = new JComboBox();
        this.combobox.setEnabled(false);
        this.combobox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PointClic p_new;
                PointClic p_old = (PointClic)e.getItem();
                if (p_old == (p_new = (PointClic)RobotClic.this.combobox.getSelectedItem())) {
                    RobotClic.this.spin_tempo.setValue(new Integer(p_new.getTempo()));
                    if (p_new.getBouton() == PointClic.droit) {
                        RobotClic.this.radio_droit.setSelected(true);
                    } else {
                        RobotClic.this.radio_gauche.setSelected(true);
                    }
                    RobotClic.this.dessinerPointCourant();
                } else {
                    RobotClic.this.preview.reset();
                }
            }
        });
        this.file_save = new JMenuItem("Enregistrer la s\u00e9quence");
        this.file_save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.save();
            }
        });
        this.file_load = new JMenuItem("Charger une s\u00e9quence");
        this.file_load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.load();
            }
        });
        this.file_quit = new JMenuItem("Quitter");
        this.file_quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.seq_register = new JMenuItem("Nouveau");
        this.seq_register.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.enregistrer();
            }
        });
        this.seq_launch = new JMenuItem("Lancer");
        this.seq_launch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.reproduire();
            }
        });
        this.seq_reset = new JMenuItem("Vider");
        this.seq_reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.reset();
            }
        });
        this.aff_apercu = new JCheckBoxMenuItem("Montrer l'aper\u00e7u");
        this.aff_apercu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    RobotClic.this.preview_frame.setVisible(false);
                } else {
                    RobotClic.this.preview_frame.setVisible(true);
                }
            }
        });
        this.aff_update = new JMenuItem("Mettre \u00e0 jour");
        this.aff_update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean visible = RobotClic.this.preview_frame.isVisible();
                RobotClic.this.enablePreview(false);
                RobotClic.this.fenetre.setVisible(false);
                RobotClic.this.pause(100L);
                BufferedImage img = RobotClic.this.robot.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
                RobotClic.this.enablePreview(visible);
                RobotClic.this.fenetre.setVisible(true);
                RobotClic.this.preview.updateBackgroud(img);
                RobotClic.this.dessinerPointCourant();
                RobotClic.this.preview.updateUI();
            }
        });
        this.help_help = new JMenuItem(titre_help);
        this.help_help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.displayHelp();
            }
        });
        this.help_changelog = new JMenuItem("Nouveaut\u00e9s");
        this.help_changelog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.showChangelog();
            }
        });
        this.help_licence = new JMenuItem("Licence");
        this.help_licence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.showLicence();
            }
        });
        this.help_update = new JMenuItem(titre_update);
        this.help_update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.checkUpdate();
            }
        });
        this.help_about = new JMenuItem("A propos");
        this.help_about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RobotClic.this.displayAbout();
            }
        });
        this.radio_gauche = new JRadioButton("Clic gauche");
        this.radio_gauche.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PointClic pc = (PointClic)RobotClic.this.combobox.getSelectedItem();
                pc.setButton(PointClic.gauche);
                RobotClic.this.combobox.repaint();
            }
        });
        this.radio_droit = new JRadioButton("Clic droit");
        this.radio_droit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PointClic pc = (PointClic)RobotClic.this.combobox.getSelectedItem();
                pc.setButton(PointClic.droit);
                RobotClic.this.combobox.repaint();
            }
        });
        this.radio_group = new ButtonGroup();
        this.radio_group.add(this.radio_gauche);
        this.radio_group.add(this.radio_droit);
        this.menu_fichier = new JMenu("Fichier");
        this.menu_fichier.add(this.file_load);
        this.menu_fichier.add(this.file_save);
        this.menu_fichier.addSeparator();
        this.menu_fichier.add(this.file_quit);
        this.menu_seq = new JMenu("S\u00e9quence");
        this.menu_seq.add(this.seq_register);
        this.menu_seq.add(this.seq_launch);
        this.menu_seq.add(this.seq_reset);
        this.menu_affichage = new JMenu("Aper\u00e7u");
        this.menu_affichage.add(this.aff_apercu);
        this.menu_affichage.add(this.aff_update);
        this.menu_help = new JMenu("?");
        this.menu_help.add(this.help_help);
        this.menu_help.add(this.help_changelog);
        this.menu_help.add(this.help_licence);
        this.menu_help.add(this.help_update);
        this.menu_help.add(this.help_about);
        this.barre = new JMenuBar();
        this.barre.add(this.menu_fichier);
        this.barre.add(this.menu_seq);
        this.barre.add(this.menu_affichage);
        this.barre.add(this.menu_help);
        this.label_tempo = new JLabel("Temporisation : ");
        this.label_ms = new JLabel("ms");
        SpinnerNumberModel spinmodel = new SpinnerNumberModel(0, 0, 10, 1);
        spinmodel.setMaximum(null);
        this.spin_tempo = new JSpinner(spinmodel);
        this.spin_tempo.setPreferredSize(new Dimension(75, 25));
        this.spin_tempo.setEnabled(false);
        this.spin_tempo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (RobotClic.this.combobox.getItemCount() > 0) {
                    RobotClic.this.appliquerTempo();
                }
            }
        });
        this.replace = new JCheckBox("Ramener le curseur", true);
        this.texte = new JTextField();
        this.texte.setEditable(false);
        this.texte.setText("");
        this.panel_liste = new JPanel(new BorderLayout());
        this.panel_liste.add(this.combobox, "Center");
        this.bordure_details = new TitledBorder("D\u00e9tails");
        this.spring = new SpringLayout();
        this.panel_details = new JPanel(this.spring);
        this.panel_details.setBorder(this.bordure_details);
        this.panel_details.add(this.label_tempo);
        this.panel_details.add(this.spin_tempo);
        this.panel_details.add(this.label_ms);
        this.panel_details.add(this.ok_tempo);
        this.panel_details.add(this.radio_gauche);
        this.panel_details.add(this.radio_droit);
        this.spring.putConstraint("West", (Component)this.label_tempo, 5, "West", (Component)this.panel_details);
        this.spring.putConstraint("West", (Component)this.spin_tempo, 0, "East", (Component)this.label_tempo);
        this.spring.putConstraint("West", (Component)this.label_ms, 5, "East", (Component)this.spin_tempo);
        this.spring.putConstraint("West", (Component)this.ok_tempo, 5, "East", (Component)this.label_ms);
        this.spring.putConstraint("VerticalCenter", (Component)this.spin_tempo, 0, "VerticalCenter", (Component)this.label_tempo);
        this.spring.putConstraint("VerticalCenter", (Component)this.label_ms, 0, "VerticalCenter", (Component)this.spin_tempo);
        this.spring.putConstraint("VerticalCenter", (Component)this.ok_tempo, 0, "VerticalCenter", (Component)this.label_ms);
        this.spring.putConstraint("North", (Component)this.radio_gauche, 0, "South", (Component)this.ok_tempo);
        this.spring.putConstraint("North", (Component)this.radio_droit, 0, "South", (Component)this.radio_gauche);
        this.spring.putConstraint("South", (Component)this.panel_details, 0, "South", (Component)this.radio_droit);
        this.spring.putConstraint("East", (Component)this.panel_details, 5, "East", (Component)this.ok_tempo);
        this.panel_bas = new JPanel(new BorderLayout());
        this.panel_bas.add((Component)this.replace, "North");
        this.panel_bas.add((Component)this.texte, "South");
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.panel_liste, "North");
        this.panel.add((Component)this.panel_details, "Center");
        this.panel.add((Component)this.panel_bas, "South");
        this.fenetre = new JFrame(titre_fenetre);
        this.fenetre.setDefaultCloseOperation(3);
        this.fenetre.setContentPane(this.panel);
        this.fenetre.setResizable(false);
        this.fenetre.setJMenuBar(this.barre);
        this.fenetre.pack();
        this.fenetre.setLocationRelativeTo(null);
        this.enableInterface(false);
        this.fenetre.setVisible(true);
    }

    public Point getMouseLocation() {
        PointerInfo pointer = MouseInfo.getPointerInfo();
        Point loc = pointer.getLocation();
        return loc;
    }

    private void enregistrer() {
        this.enablePreview(false);
        this.enableInterface(false);
        this.liste = new PointClicList();
        this.combobox.removeAllItems();
        this.retirerListeners();
        this.texte.addKeyListener(this);
        this.texte.addFocusListener(this);
        this.texte.grabFocus();
    }

    private void reproduire() {
        this.fenetre.setVisible(false);
        this.enableInterface(false);
        if (JIntellitypeEnabled) {
            JIntellitype.getInstance().addHotKeyListener(new HotkeyListener(){

                public void onHotKey(int aIdentifier) {
                    if (aIdentifier == 1 && RobotClic.this.cliqueur != null) {
                        RobotClic.this.cliqueur.interrupt();
                    }
                }
            });
            JIntellitype.getInstance().registerHotKey(1, 3, 83);
        }
        this.cliqueur = new Cliqueur(this);
        this.cliqueur.start();
    }

    public void endSequence() {
        this.cliqueur = null;
        this.enableInterface(true);
        this.fenetre.setVisible(true);
    }

    private void reset() {
        this.liste = new PointClicList();
        this.retirerListeners();
        this.enableInterface(false);
        this.texte.setText("Liste vid\u00e9e !");
        this.combobox.removeAllItems();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        switch (code) {
            case 32: {
                this.ajouterPoint();
                break;
            }
            case 27: {
                this.finEnregistrement();
                break;
            }
        }
    }

    private void ajouterPoint() {
        Point p = this.getMouseLocation();
        try {
            PointClic pc = new PointClic(p.x, p.y, 0, this.liste.size() + 1);
            this.liste.add(pc);
            this.texte.setText("Points ajout\u00e9s : " + this.liste.size() + " - Echap pour terminer");
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.fenetre, ex.getMessage(), titre_fenetre, 0);
        }
    }

    private void finEnregistrement() {
        this.retirerListeners();
        if (this.liste.size() > 0) {
            this.enableInterface(true);
        }
        this.texte.setText("Enregistrement termin\u00e9, " + this.liste.size() + " points");
    }

    private void retirerListeners() {
        KeyListener[] kl = this.texte.getKeyListeners();
        int i = 0;
        while (i < kl.length) {
            this.texte.removeKeyListener(kl[i]);
            ++i;
        }
        FocusListener[] fl = this.texte.getFocusListeners();
        int i2 = 0;
        while (i2 < fl.length) {
            this.texte.removeFocusListener(fl[i2]);
            ++i2;
        }
        this.combobox.removeAllItems();
        ListIterator it = this.liste.listIterator();
        while (it.hasNext()) {
            this.combobox.addItem((PointClic)it.next());
        }
    }

    private void appliquerTempo() {
        Integer i = (Integer)this.spin_tempo.getValue();
        int t = i;
        PointClic pc = (PointClic)this.combobox.getSelectedItem();
        pc.setTempo(t);
        this.combobox.repaint();
        this.texte.setText("Tempo point " + pc.getIdent() + " mise \u00e0 " + t + " ms");
    }

    private void appliquerTempoPourTous() {
        int t = (Integer)this.spin_tempo.getValue();
        int nb = this.combobox.getItemCount();
        int i = 0;
        while (i < nb) {
            PointClic pc = this.combobox.getItemAt(i);
            pc.setTempo(t);
            ++i;
        }
        this.combobox.repaint();
        this.texte.setText("Tempo mises \u00e0 " + t + " ms");
    }

    private void enableInterface(boolean active) {
        this.file_save.setEnabled(active);
        this.seq_launch.setEnabled(active);
        this.combobox.setEnabled(active);
        this.spin_tempo.setEnabled(active);
        this.ok_tempo.setEnabled(active);
        this.radio_gauche.setEnabled(active);
        this.radio_droit.setEnabled(active);
        this.replace.setEnabled(active);
        this.fenetre.pack();
    }

    private void enablePreview(boolean active) {
        this.preview_frame.setVisible(active);
        this.aff_apercu.setState(active);
    }

    public void focusGained(FocusEvent e) {
        int s = this.liste.size();
        if (s == 0) {
            this.texte.setText("[Espace] : nouveau point / [Echap] : finir");
        } else {
            this.texte.setText("Points ajout\u00e9s : " + s + " - Echap pour terminer");
        }
    }

    public void focusLost(FocusEvent e) {
        this.texte.setText("/!\\ Cliquez ici pour enregistrer /!\\");
    }

    private void dessinerPointCourant() {
        PointClic p = (PointClic)this.combobox.getSelectedItem();
        if (p != null) {
            this.preview.dessinerPoint(p);
        }
        this.preview.updateUI();
    }

    private void save() {
        JFileChooser chooser = new JFileChooser(new File("."));
        SequenceFileFilter filter = new SequenceFileFilter("Fichiers s\u00e9quence (*.seq)", "seq");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this.fenetre);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            if (!f.getName().endsWith(".seq")) {
                f = new File(String.valueOf(f.getAbsolutePath()) + "." + "seq");
            }
            try {
                if (this.liste != null) {
                    this.liste.saveFile(f.getAbsolutePath());
                    this.texte.setText("Enregistrement termin\u00e9, " + this.liste.size() + " points");
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.fenetre, ex.getMessage(), titre_fenetre, 0);
            }
        }
    }

    private void load() {
        JFileChooser chooser = new JFileChooser(new File("."));
        SequenceFileFilter filter = new SequenceFileFilter("Fichiers s\u00e9quence (*.seq)", "seq");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.fenetre);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            try {
                this.liste = PointClicList.loadFile(f.getAbsolutePath());
                this.retirerListeners();
                this.texte.setText("Chargement termin\u00e9, " + this.liste.size() + " points");
                this.enableInterface(true);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.fenetre, ex.getMessage(), titre_fenetre, 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.fenetre, ex.getMessage(), titre_fenetre, 0);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.fenetre, ex.getMessage(), titre_fenetre, 0);
            }
        }
    }

    private void displayHelp() {
        int nb_msg = help.length;
        JPanel p = new JPanel(new GridLayout(help.length, 1));
        JLabel[] msg_label = new JLabel[nb_msg];
        int i = 0;
        while (i < nb_msg) {
            msg_label[i] = new JLabel(help[i], 0);
            p.add(msg_label[i]);
            ++i;
        }
        JOptionPane.showMessageDialog(this.fenetre, p, titre_help, -1);
    }

    private void displayAbout() {
        int nb_msg = about.length;
        JPanel p = new JPanel(new GridLayout(about.length, 1));
        JLabel[] msg_label = new JLabel[nb_msg];
        int i = 0;
        while (i < nb_msg) {
            msg_label[i] = new JLabel(about[i]);
            p.add(msg_label[i]);
            ++i;
        }
        Object[] options = new String[]{"Fermer"};
        JOptionPane.showOptionDialog(this.fenetre, p, titre_about, 0, 1, null, options, options[0]);
    }

    private void checkUpdate() {
        HTTPClient update_checker = new HTTPClient(new String[]{"kistrof.free.fr", "/robotclic/update.php?v=2.7.2"});
        update_checker.sendRequest();
        String update_response = new String(update_checker.buf).trim();
        String[] response = new String[]{"Aucune mise \u00e0 jour n'est disponible"};
        if (version.compareTo(update_response) < 0) {
            response = new String[]{"Une mise \u00e0 jour est disponible : v" + update_response, "Rendez-vous sur http://kistrof.free.fr/robotclic/ pour l'obtenir"};
        }
        int nb_msg = response.length;
        JPanel p = new JPanel(new GridLayout(response.length, 1));
        JLabel[] msg_label = new JLabel[nb_msg];
        int i = 0;
        while (i < nb_msg) {
            msg_label[i] = new JLabel(response[i], 0);
            p.add(msg_label[i]);
            ++i;
        }
        JOptionPane.showMessageDialog(this.fenetre, p, titre_update, -1);
    }

    public void showChangelog() {
        String texte = this.lireFichier("doc/changelog.txt");
        if (!texte.equals("")) {
            JTextArea t = new JTextArea(texte);
            t.setEditable(false);
            JScrollPane scroll = new JScrollPane(t);
            scroll.setPreferredSize(new Dimension(550, 400));
            JOptionPane.showMessageDialog(this.fenetre, scroll, titre_changelog, -1);
        }
    }

    public void showLicence() {
        String texte = this.lireFichier("doc/licence.txt");
        if (!texte.equals("")) {
            JTextArea t = new JTextArea(texte);
            t.setEditable(false);
            JScrollPane scroll = new JScrollPane(t);
            scroll.setPreferredSize(new Dimension(550, 400));
            JOptionPane.showMessageDialog(this.fenetre, scroll, titre_licence, -1);
        }
    }

    private String lireFichier(String chemin) {
        String texte = "";
        try {
            String ligne;
            URL f = this.getClass().getResource(chemin);
            URLConnection url_cnx = f.openConnection();
            InputStreamReader freader = new InputStreamReader(url_cnx.getInputStream(), "ISO-8859-1");
            BufferedReader reader = new BufferedReader(freader);
            while ((ligne = reader.readLine()) != null) {
                texte = String.valueOf(texte) + ligne + "\n";
            }
        }
        catch (Exception e) {
            System.err.println("Erreur : " + e.getMessage());
        }
        return texte;
    }
}

