/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.io.IOException;
import java.text.NumberFormat;

public class PointClic {
    private int x;
    private int y;
    private int tempo;
    private int ident;
    private int bouton;
    private static final Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    public static int gauche = 16;
    public static int droit = 4;

    public PointClic() throws IOException {
        this(0, 0, 0);
    }

    public PointClic(Point p) throws IOException {
        this(p.x, p.y, 0);
    }

    public PointClic(Point p, int t) throws IOException {
        this(p.x, p.y, t);
    }

    public PointClic(Point p, int t, int i) throws IOException {
        this(p.x, p.y, t, i);
    }

    public PointClic(int h, int v) throws IOException {
        this(h, v, 0);
    }

    public PointClic(int h, int v, int t) throws IOException {
        this(h, v, t, 0, gauche);
    }

    public PointClic(int h, int v, int t, int i) throws IOException {
        this(h, v, t, i, gauche);
    }

    public PointClic(int h, int v, int t, int i, int b) throws IOException {
        if (h >= PointClic.dim.width || h < 0) {
            throw new IOException(String.valueOf(i) + " - (" + h + ", " + v + ")\nCe point est en dehors de l'\u00e9cran !");
        }
        this.x = h;
        if (v >= PointClic.dim.height || v < 0) {
            throw new IOException(String.valueOf(i) + " - (" + h + ", " + v + ")\nCe point est en dehors de l'\u00e9cran !");
        }
        this.y = v;
        this.setTempo(t);
        this.setButton(b);
        this.ident = i;
    }

    public void setTempo(int t) {
        this.tempo = t >= 0 ? t : 0;
    }

    public void setButton(int b) {
        this.bouton = b;
    }

    public void cliquer() throws AWTException, InterruptedException {
        Thread.sleep(this.tempo);
        Robot r = new Robot();
        r.mouseMove(this.x, this.y);
        r.mousePress(this.bouton);
        r.mouseRelease(this.bouton);
    }

    public String toString() {
        String b = "G";
        if (this.bouton == droit) {
            b = "D";
        }
        return String.valueOf(this.ident) + " - (" + this.x + ", " + this.y + ") - " + b + " - " + NumberFormat.getInstance().format(this.tempo) + " ms";
    }

    public int getBouton() {
        return this.bouton;
    }

    public int getIdent() {
        return this.ident;
    }

    public int getTempo() {
        return this.tempo;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

