/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tranlog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exolab.jms.tranlog.ExternalXid;

public abstract class BaseTransactionLogEntry
implements Externalizable {
    static final long serialVersionUID = 2L;
    private ExternalXid _externalXid = null;
    private String _resourceId;
    private long _created = -1L;
    private long _expiryTime = 0L;

    BaseTransactionLogEntry() {
    }

    BaseTransactionLogEntry(ExternalXid txid, String rid, long created) {
        this._externalXid = txid;
        this._resourceId = rid;
        this._created = created;
    }

    BaseTransactionLogEntry(BaseTransactionLogEntry copy) {
        this._externalXid = new ExternalXid(copy._externalXid);
        this._resourceId = copy._resourceId;
        this._created = copy._created;
        this._expiryTime = copy._expiryTime;
    }

    public void setExternalXid(ExternalXid txid) {
        this._externalXid = txid;
    }

    public ExternalXid getExternalXid() {
        return this._externalXid;
    }

    public void setResourceId(String rid) {
        this._resourceId = rid;
    }

    public String getResourceId() {
        return this._resourceId;
    }

    public void setCreated(long time) {
        this._created = time;
    }

    public void setCreated() {
        this._created = System.currentTimeMillis();
    }

    public long getCreated() {
        return this._created;
    }

    public void setExpiryTime(long time) {
        this._expiryTime = time;
    }

    public long getExpiryTime() {
        return this._expiryTime;
    }

    public boolean transactionExpired() {
        return System.currentTimeMillis() > this._expiryTime;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        if (!this.isValid()) {
            throw new IOException("writeExternal : entry has invalid state");
        }
        stream.writeLong(2L);
        stream.writeObject(this._externalXid);
        stream.writeUTF(this._resourceId);
        stream.writeLong(this._created);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version == 2L) {
            this._externalXid = (ExternalXid)stream.readObject();
            this._resourceId = stream.readUTF();
            this._created = stream.readLong();
            if (!this.isValid()) {
                throw new IOException("readExternal : entry has invalid state");
            }
        } else {
            throw new IOException("No support for BaseTransactionLogEntry with version " + version);
        }
    }

    boolean isValid() {
        return this._externalXid != null && this._resourceId != null && this._created != -1L;
    }
}

