/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db.migration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.db.Database;
import org.exolab.jms.tools.db.RDBMSTool;
import org.exolab.jms.tools.db.SchemaConverter;
import org.exolab.jms.tools.db.SchemaHelper;
import org.exolab.jms.tools.db.Table;

public class V072toV076SchemaConverter
implements SchemaConverter {
    private Connection _connection;
    private RDBMSTool _tool;
    private static final String USERS_TABLE = "users";
    private static final String MESSAGES_TABLE = "messages";
    private static final String HANDLES_TABLE = "message_handles";

    public V072toV076SchemaConverter(Connection connection) {
        this._connection = connection;
    }

    public void convert() throws PersistenceException {
        Database schema = SchemaHelper.getSchema();
        try {
            if (this._connection.getAutoCommit()) {
                this._connection.setAutoCommit(false);
            }
            this._tool = new RDBMSTool(this._connection);
        }
        catch (SQLException exception) {
            throw new PersistenceException(exception.getMessage());
        }
        try {
            this.convertMessagesTable(schema);
            this.convertHandlesTable(schema);
            this.createUsersTable(schema);
            SchemaHelper.setVersion(this._connection, "V0.7.6");
            this._connection.commit();
        }
        catch (PersistenceException exception) {
            SQLHelper.rollback(this._connection);
            throw exception;
        }
        catch (SQLException exception) {
            SQLHelper.rollback(this._connection);
            throw new PersistenceException(exception);
        }
    }

    private void convertMessagesTable(Database schema) throws PersistenceException, SQLException {
        Table table = SchemaHelper.getTable(schema, MESSAGES_TABLE);
        Table tmpTable = new Table();
        String tmpName = "openjms_tmp_messages";
        tmpTable.setName(tmpName);
        tmpTable.setAttribute(table.getAttribute());
        this._tool.drop(tmpTable);
        this._tool.create(tmpTable);
        PreparedStatement select = this._connection.prepareStatement("select messageid, destinationid, priority, createTime,expiryTime, processed, messageBlob from messages");
        ResultSet set = select.executeQuery();
        while (set.next()) {
            long id = set.getLong(1);
            long destinationId = set.getLong(2);
            int priority = set.getInt(3);
            long createTime = set.getLong(4);
            long expiryTime = set.getLong(5);
            int processed = set.getInt(6);
            byte[] blob = set.getBytes(7);
            String messageId = "ID:" + id;
            this.migrateMessage(tmpName, messageId, destinationId, priority, createTime, expiryTime, processed, blob);
        }
        set.close();
        select.close();
        this._tool.drop(table);
        this._tool.create(table);
        select = this._connection.prepareStatement("select messageid, destinationid, priority, createTime,expiryTime, processed, messageBlob from " + tmpName);
        set = select.executeQuery();
        while (set.next()) {
            String messageId = set.getString(1);
            long destinationId = set.getLong(2);
            int priority = set.getInt(3);
            long createTime = set.getLong(4);
            long expiryTime = set.getLong(5);
            int processed = set.getInt(6);
            byte[] blob = set.getBytes(7);
            this.migrateMessage(tmpName, messageId, destinationId, priority, createTime, expiryTime, processed, blob);
        }
        set.close();
        select.close();
        this._tool.drop(tmpTable);
    }

    private void migrateMessage(String table, String messageId, long destinationId, int priority, long createTime, long expiryTime, int processed, byte[] blob) throws SQLException {
        PreparedStatement insert = null;
        try {
            insert = this._connection.prepareStatement("insert into " + table + " values (?,?,?,?,?,?,?)");
            insert.setString(1, messageId);
            insert.setLong(2, destinationId);
            insert.setInt(3, priority);
            insert.setLong(4, createTime);
            insert.setLong(5, expiryTime);
            insert.setInt(6, processed);
            insert.setBinaryStream(7, (InputStream)new ByteArrayInputStream(blob), blob.length);
            if (insert.executeUpdate() != 1) {
                throw new SQLException("Failed to add message=" + messageId);
            }
            Object var14_10 = null;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    private void convertHandlesTable(Database schema) throws PersistenceException, SQLException {
        Table table = SchemaHelper.getTable(schema, HANDLES_TABLE);
        Table tmpTable = new Table();
        String tmpName = "openjms_tmp_message_handles";
        tmpTable.setName(tmpName);
        tmpTable.setAttribute(table.getAttribute());
        this._tool.drop(tmpTable);
        this._tool.create(tmpTable);
        PreparedStatement select = this._connection.prepareStatement("select messageid, destinationid, consumerid, priority,  acceptedTime, sequenceNumber, expiryTime, delivered from message_handles");
        ResultSet set = select.executeQuery();
        while (set.next()) {
            long messageId = set.getLong(1);
            long destinationId = set.getLong(2);
            long consumerId = set.getLong(3);
            int priority = set.getInt(4);
            long acceptedTime = set.getLong(5);
            long sequenceNo = set.getLong(6);
            long expiryTime = set.getLong(7);
            int delivered = set.getInt(8);
            this.migrateHandle(tmpName, messageId, destinationId, consumerId, priority, acceptedTime, sequenceNo, expiryTime, delivered);
        }
        set.close();
        select.close();
        this._tool.drop(table);
        this._tool.create(table);
        select = this._connection.prepareStatement("insert into message_handles select * from " + tmpName);
        select.executeQuery();
        select.close();
        this._tool.drop(tmpTable);
    }

    private void migrateHandle(String table, long messageId, long destinationId, long consumerId, int priority, long acceptedTime, long sequenceNo, long expiryTime, int delivered) throws SQLException {
        PreparedStatement insert = null;
        try {
            insert = this._connection.prepareStatement("insert into " + table + " values (?,?,?,?,?,?,?,?)");
            insert.setString(1, "ID:" + messageId);
            insert.setLong(2, destinationId);
            insert.setLong(3, consumerId);
            insert.setInt(4, priority);
            insert.setLong(5, acceptedTime);
            insert.setLong(6, sequenceNo);
            insert.setLong(7, expiryTime);
            insert.setInt(8, delivered);
            if (insert.executeUpdate() != 1) {
                throw new SQLException("Failed to add handle=" + messageId);
            }
            Object var18_11 = null;
        }
        catch (Throwable throwable) {
            Object var18_12 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    private void createUsersTable(Database schema) throws PersistenceException {
        Table table = SchemaHelper.getTable(schema, USERS_TABLE);
        this._tool.create(table);
    }
}

