/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.db.Descriptor;
import org.exolab.jms.tools.db.Type;

class TypeSet {
    private HashMap _types = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$db$TypeSet == null ? (class$org$exolab$jms$tools$db$TypeSet = TypeSet.class$("org.exolab.jms.tools.db.TypeSet")) : class$org$exolab$jms$tools$db$TypeSet));
    static /* synthetic */ Class class$org$exolab$jms$tools$db$TypeSet;

    public TypeSet(Connection connection) throws PersistenceException {
        ResultSet set = null;
        try {
            try {
                set = connection.getMetaData().getTypeInfo();
                while (set.next()) {
                    int type = set.getInt("DATA_TYPE");
                    String name = set.getString("TYPE_NAME");
                    long precision = set.getLong("PRECISION");
                    String createParams = set.getString("CREATE_PARAMS");
                    Descriptor descriptor = Descriptor.getDescriptor(type);
                    if (descriptor != null) {
                        this.addType(type, name, precision, createParams);
                        continue;
                    }
                    _log.debug((Object)("TypeSet: skipping unknown type, type id=" + type + ", name=" + name + ", precision=" + precision + ", create params=" + createParams));
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to get type meta-data", exception);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            SQLHelper.close(set);
            throw throwable;
        }
        SQLHelper.close(set);
    }

    public Type getType(int type, long precision) {
        Type result = null;
        ArrayList types = (ArrayList)this._types.get(new Integer(type));
        if (types != null) {
            Iterator iter = ((AbstractList)types).iterator();
            while (iter.hasNext()) {
                Type option = (Type)iter.next();
                if (precision == -1L && option.getPrecision() != -1L && option.getParameters()) {
                    result = new Type(type, option.getName(), option.getPrecision(), option.getParameters());
                    break;
                }
                if (precision <= option.getPrecision()) {
                    result = new Type(type, option.getName(), precision, option.getParameters());
                    break;
                }
                _log.debug((Object)("TypeSet: requested type=" + type + " exceeds precision for supported " + option));
            }
        } else {
            _log.debug((Object)("TypeSet: no types matching type id=" + type + ", type=" + Descriptor.getDescriptor(type).getName()));
        }
        return result;
    }

    public Type getNearestType(int type, long precision) {
        Type result = null;
        ArrayList types = (ArrayList)this._types.get(new Integer(type));
        if (types != null) {
            Iterator iter = ((AbstractList)types).iterator();
            Type nearest = null;
            while (iter.hasNext()) {
                Type option = (Type)iter.next();
                if (precision <= option.getPrecision()) {
                    result = new Type(type, option.getName(), precision, option.getParameters());
                    break;
                }
                nearest = option;
            }
            if (result == null && nearest != null) {
                result = new Type(type, nearest.getName(), nearest.getPrecision(), nearest.getParameters());
                _log.warn((Object)("TypeSet: requested type=" + type + ", precision=" + precision + " exceeds precision supported by database. " + "Falling back to " + nearest));
            }
        } else {
            _log.debug((Object)("TypeSet: no types matching type id=" + type + ", type=" + Descriptor.getDescriptor(type).getName()));
        }
        return result;
    }

    public boolean exists(int type) {
        return this._types.containsKey(new Integer(type));
    }

    private void addType(int type, String name, long precision, String createParams) {
        Integer key;
        ArrayList<Type> types;
        Descriptor descriptor = Descriptor.getDescriptor(type);
        boolean parameters = false;
        if (createParams != null && createParams.trim().length() != 0) {
            parameters = true;
        }
        if ((types = (ArrayList<Type>)this._types.get(key = new Integer(type))) == null) {
            types = new ArrayList<Type>();
            this._types.put(key, types);
        }
        _log.debug((Object)("TypeSet: type id=" + type + ", type=" + descriptor.getName() + ", name=" + name + ", precision=" + precision + ", createParams=" + createParams));
        types.add(new Type(type, name, precision, parameters));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

