/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.tools.db.Descriptor;
import org.exolab.jms.tools.db.Type;
import org.exolab.jms.tools.db.TypeSet;

class TypeMapper {
    private TypeSet _set = null;
    private HashMap _mappings = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$db$TypeMapper == null ? (class$org$exolab$jms$tools$db$TypeMapper = TypeMapper.class$("org.exolab.jms.tools.db.TypeMapper")) : class$org$exolab$jms$tools$db$TypeMapper));
    static /* synthetic */ Class class$org$exolab$jms$tools$db$TypeMapper;

    public TypeMapper(TypeSet set) {
        this._set = set;
        Type[] binaries = new Type[]{new Type(-3, 0L, true), new Type(-4, 0L, true)};
        this.add(-2, binaries);
        Type[] varbinaries = new Type[]{new Type(-4, 0L, true)};
        this.add(-3, binaries);
        Type[] bits = new Type[]{new Type(1, 0L, false), new Type(-6, 0L, false), new Type(5, 0L, false), new Type(4, 0L, false), new Type(2, 1L, true)};
        this.add(-7, bits);
        Type[] decimals = new Type[]{new Type(2, 0L, false)};
        this.add(3, decimals);
        Type[] dates = new Type[]{new Type(93, 0L, false)};
        this.add(91, dates);
        long precision = Long.toString(Long.MAX_VALUE).length();
        Type[] bigints = new Type[]{new Type(2, precision, true)};
        this.add(-5, bigints);
    }

    public Type getType(int type, long precision) {
        Type result = this._set.getType(type, precision);
        if (result == null) {
            result = (Type)this._mappings.get(new Integer(type));
        }
        return result;
    }

    private void add(int type, Type[] mappings) {
        int i = 0;
        while (i < mappings.length) {
            Type requested = mappings[i];
            Type supported = this._set.getType(requested.getType(), requested.getPrecision());
            if (supported != null) {
                long precision = requested.getPrecision();
                long maxPrecision = supported.getPrecision();
                _log.debug((Object)("TypeMapper: alternative mapping for type=" + Descriptor.getDescriptor(type).getName() + ", precision=" + precision + ", is supported by the database as " + supported));
                if (type == supported.getType() && precision > 0L && precision < maxPrecision) {
                    supported = new Type(supported.getType(), supported.getName(), precision, supported.getParameters());
                }
                this._mappings.put(new Integer(type), supported);
                break;
            }
            _log.debug((Object)("TypeMapper: alternative mapping for type=" + Descriptor.getDescriptor(type).getName() + " is not supported by the database"));
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

