/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db;

import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.db.Descriptor;

public class Type {
    private final Descriptor _descriptor;
    private final String _name;
    private final long _precision;
    private final boolean _parameters;

    public Type(int type, long precision, boolean parameters) {
        this._descriptor = Descriptor.getDescriptor(type);
        if (this._descriptor == null) {
            throw new IllegalArgumentException("Type id=" + type + " is not a valid type");
        }
        this._name = this._descriptor.getName();
        this._precision = precision;
        this._parameters = parameters;
    }

    public Type(int type, String name, long precision, boolean parameters) {
        this._descriptor = Descriptor.getDescriptor(type);
        if (this._descriptor == null) {
            throw new IllegalArgumentException("Type id=" + type + " is not a valid type");
        }
        this._name = name;
        this._precision = precision;
        this._parameters = parameters;
    }

    public int getType() {
        return this._descriptor.getType();
    }

    public String getName() {
        return this._name;
    }

    public long getPrecision() {
        return this._precision;
    }

    public boolean getParameters() {
        return this._parameters;
    }

    public String getSymbolicType() {
        String result = this._descriptor.getName();
        if (this._parameters && this._precision > 0L) {
            result = result + "(" + this._precision + ")";
        }
        return result;
    }

    public String getSQL() {
        String result = this._name;
        if (this._parameters && this._precision > 0L) {
            result = result + "(" + this._precision + ")";
        }
        return result;
    }

    public String toString() {
        return "type=" + this._descriptor.getName() + ", name=" + this._name + ", precision=" + this._precision + ", parameters=" + this._parameters;
    }

    public static Type getType(String type) throws PersistenceException {
        Descriptor descriptor;
        int start = type.indexOf(40);
        String name = type;
        long precision = -1L;
        boolean parameters = false;
        if (start != -1) {
            name = type.substring(0, start);
            int end = type.indexOf(41, start);
            if (end == -1) {
                throw new PersistenceException("Illegal type: " + type);
            }
            precision = Long.parseLong(type.substring(start + 1, end));
            parameters = true;
        }
        if ((descriptor = Descriptor.getDescriptor(name.trim())) == null) {
            throw new PersistenceException("Type name=" + type + " is not a valid type");
        }
        return new Type(descriptor.getType(), precision, parameters);
    }
}

