/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationFileException;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.FileDoesNotExistException;
import org.exolab.jms.config.RdbmsDatabaseConfiguration;
import org.exolab.jms.persistence.DBCPConnectionManager;
import org.exolab.jms.persistence.DBConnectionManager;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.db.Database;
import org.exolab.jms.tools.db.RDBMSTool;
import org.exolab.jms.tools.db.SchemaConverter;
import org.exolab.jms.tools.db.SchemaConverterFactory;
import org.exolab.jms.tools.db.SchemaHelper;
import org.exolab.jms.util.CommandLine;

public class DBTool {
    private DBConnectionManager _connections;
    private RDBMSTool _tool;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$db$DBTool == null ? (class$org$exolab$jms$tools$db$DBTool = DBTool.class$("org.exolab.jms.tools.db.DBTool")) : class$org$exolab$jms$tools$db$DBTool));
    static /* synthetic */ Class class$org$exolab$jms$tools$db$DBTool;

    public DBTool(String path) throws ClassNotFoundException, ConfigurationFileException, FileDoesNotExistException, IOException, PersistenceException {
        if (path == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        ConfigurationManager.setConfig(path);
        Configuration config = ConfigurationManager.getConfig();
        DOMConfigurator.configure((String)config.getLoggerConfiguration().getFile());
        RdbmsDatabaseConfiguration rdbms = config.getDatabaseConfiguration().getRdbmsDatabaseConfiguration();
        if (rdbms == null) {
            throw new ConfigurationFileException("Configuration file=" + path + " is not configured to use an" + " RDBMS");
        }
        this._connections = new DBCPConnectionManager();
        this._connections.setDriver(rdbms.getDriver());
        this._connections.setURL(rdbms.getUrl());
        this._connections.setUser(rdbms.getUser());
        this._connections.setPassword(rdbms.getPassword());
        this._connections.init();
        this._tool = new RDBMSTool(this._connections.getConnection());
    }

    public void create() throws PersistenceException {
        Database schema = SchemaHelper.getSchema();
        this._tool.create(schema);
    }

    public void create(String path) throws PersistenceException {
        if (path == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        Database schema = SchemaHelper.getSchema(path);
        this._tool.create(schema);
    }

    public void drop() throws PersistenceException {
        Database schema = SchemaHelper.getSchema();
        this._tool.drop(schema);
    }

    public void drop(String path) throws PersistenceException {
        if (path == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        Database schema = SchemaHelper.getSchema(path);
        this._tool.drop(schema);
    }

    public void migrate() throws PersistenceException {
        Connection connection = this._connections.getConnection();
        Database schema = SchemaHelper.getSchema();
        String fromVersion = SchemaHelper.getSchemaVersion(connection);
        if (fromVersion == null) {
            throw new PersistenceException("Cannot migrate schema - existing schema version cannot be determined");
        }
        String toVersion = "V0.7.6";
        SchemaConverter converter = SchemaConverterFactory.create(fromVersion, toVersion, connection);
        if (converter != null) {
            try {
                _log.info((Object)("Migrating schema from version=" + fromVersion + " to version=" + toVersion));
                converter.convert();
                _log.info((Object)"Successfully migrated schema");
            }
            catch (PersistenceException exception) {
                _log.error((Object)("Schema migration from version=" + fromVersion + " to version=" + toVersion + " failed"), (Throwable)((Object)exception));
                throw exception;
            }
        } else {
            throw new PersistenceException("Incompatible schema types. Expected schema version=" + fromVersion + ", but got schema version=" + toVersion);
        }
    }

    public void close() throws SQLException {
        this._tool.close();
    }

    public static void main(String[] args) {
        CommandLine commands = new CommandLine(args);
        DBTool tool = null;
        String config = commands.value("config");
        if (config != null) {
            try {
                tool = new DBTool(config);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                System.exit(1);
            }
        } else {
            DBTool.usage();
            System.exit(1);
        }
        boolean create = commands.exists("create");
        boolean drop = commands.exists("drop");
        boolean recreate = commands.exists("recreate");
        boolean migrate = commands.exists("migrate");
        String schema = commands.value("schema");
        if (create) {
            try {
                if (schema != null) {
                    tool.create(schema);
                } else {
                    tool.create();
                }
                System.out.println("Successfully created tables");
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                System.exit(1);
            }
        } else if (drop) {
            try {
                if (schema != null) {
                    tool.drop(schema);
                } else {
                    tool.drop();
                }
                System.out.println("Successfully dropped tables");
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                System.exit(1);
            }
        } else if (recreate) {
            try {
                if (schema != null) {
                    tool.drop(schema);
                    tool.create(schema);
                } else {
                    tool.drop();
                    tool.create();
                }
                System.out.println("Successfully recreated tables");
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                System.exit(1);
            }
        } else if (migrate) {
            try {
                tool.migrate();
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                System.exit(1);
            }
            System.out.println("Sucessfully migrated database");
        } else {
            DBTool.usage();
            System.exit(1);
        }
        try {
            tool.close();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    private static void usage() {
        System.err.println("usage: " + (class$org$exolab$jms$tools$db$DBTool == null ? (class$org$exolab$jms$tools$db$DBTool = DBTool.class$("org.exolab.jms.tools.db.DBTool")) : class$org$exolab$jms$tools$db$DBTool).getName() + " <arguments> [options]\n" + "arguments:\n" + "  -create -config <path>   creates the database tables\n" + "  -drop -config <path>     drops the database tables\n\n" + "  -recreate -config <path> recreates the database tables\n\n" + "  -migrate -config <path>  migrates the database to the latest " + "schema version\n\n" + "options:\n" + "  -schema <schema>\n");
        System.err.println("where:\n  path      is the path to an OpenJMS configuration file\n  schema    is an XML document specifying the database schema\n            If not specified, the default schema will be used");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

