/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.CreateQueueDialog;
import org.exolab.jms.tools.admin.CreateTopicDialog;
import org.exolab.jms.tools.admin.CreateUserDialog;
import org.exolab.jms.tools.admin.OpenJMSQueue;
import org.exolab.jms.tools.admin.OpenJMSTopic;
import org.exolab.jms.tools.admin.OpenJMSUser;
import org.exolab.jms.tools.admin.QueryDialog;

public class OpenJMSServer
extends DefaultMutableTreeNode {
    private String serverName_;
    private static JTree tree_ = null;
    private static boolean commandsCreated_ = false;
    private static JPopupMenu commands_ = null;

    public OpenJMSServer(String serverName, JTree tree) {
        this.serverName_ = serverName;
        if (!commandsCreated_) {
            tree_ = tree;
            this.createCommands();
            commandsCreated_ = true;
        }
    }

    protected void createCommands() {
        commands_ = new JPopupMenu();
        JMenuItem m = new JMenuItem("Add Queue");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSServer.addQueue();
            }
        });
        commands_.add(m);
        m = new JMenuItem("Add Topic");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSServer.addTopic();
            }
        });
        commands_.add(m);
        m = new JMenuItem("Add User");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSServer.addUser();
            }
        });
        commands_.add(m);
        m = new JMenuItem("Purge Messages");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSServer.purgeMessages();
            }
        });
        commands_.add(m);
    }

    public static DefaultTreeModel createServerList(JTree tree) {
        OpenJMSServer server = new OpenJMSServer("OpenJMSServer", tree);
        return new DefaultTreeModel(server);
    }

    public void displayConnections() {
        Enumeration e = AbstractAdminConnection.instance().getAllDestinations();
        if (e != null) {
            while (e.hasMoreElements()) {
                JmsDestination destination = (JmsDestination)e.nextElement();
                if (destination instanceof JmsQueue) {
                    this.add(new OpenJMSQueue(destination.getName(), tree_));
                    continue;
                }
                if (!(destination instanceof JmsTopic)) continue;
                this.add(new OpenJMSTopic(destination.getName(), tree_));
            }
        }
        if ((e = AbstractAdminConnection.instance().getAllUsers()) != null) {
            while (e.hasMoreElements()) {
                this.add(new OpenJMSUser(e.nextElement().toString(), tree_));
            }
        }
        this.refresh();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public void displayCommands(Rectangle loc) {
        double x = loc.getX();
        double y = loc.getY();
        commands_.show(tree_, (int)x, (int)(y += loc.getHeight()));
    }

    public String toString() {
        return this.serverName_;
    }

    public void refresh() {
        DefaultTreeModel model = (DefaultTreeModel)tree_.getModel();
        model.nodeStructureChanged(this);
    }

    private static OpenJMSServer getInstanceSelected() {
        Object loc = tree_.getLastSelectedPathComponent();
        return (OpenJMSServer)loc;
    }

    private static void addQueue() {
        OpenJMSServer This = OpenJMSServer.getInstanceSelected();
        CreateQueueDialog.instance().displayCreateQueue();
        if (CreateQueueDialog.instance().isConfirmed()) {
            if (AbstractAdminConnection.instance().addDestination(CreateQueueDialog.instance().getName(), true)) {
                This.add(new OpenJMSQueue(CreateQueueDialog.instance().getName(), tree_));
                This.refresh();
            } else {
                JOptionPane.showMessageDialog(tree_, "Queue already exists", "Create Error", 0);
            }
        }
    }

    private static void addUser() {
        OpenJMSServer This = OpenJMSServer.getInstanceSelected();
        CreateUserDialog.instance().displayCreateUser();
        if (CreateUserDialog.instance().isConfirmed()) {
            if (AbstractAdminConnection.instance().addUser(CreateUserDialog.instance().getName(), CreateUserDialog.instance().getPassword())) {
                This.add(new OpenJMSUser(CreateUserDialog.instance().getName(), tree_));
                This.refresh();
            } else {
                JOptionPane.showMessageDialog(tree_, "User already exists", "Create Error", 0);
            }
        }
    }

    private static void addTopic() {
        OpenJMSServer This = OpenJMSServer.getInstanceSelected();
        CreateTopicDialog.instance().displayCreateTopic();
        if (CreateTopicDialog.instance().isConfirmed()) {
            if (AbstractAdminConnection.instance().addDestination(CreateTopicDialog.instance().getName(), false)) {
                This.add(new OpenJMSTopic(CreateTopicDialog.instance().getName(), tree_));
                This.refresh();
            } else {
                JOptionPane.showMessageDialog(tree_, "Topic already exists", "Create Error", 0);
            }
        }
    }

    private static void purgeMessages() {
        QueryDialog.instance().display("Are you sure you want to purge all\n processed messages.");
        if (QueryDialog.instance().isConfirmed()) {
            int count = AbstractAdminConnection.instance().purgeMessages();
            JOptionPane.showMessageDialog(tree_, count + " messages were purged.", "Info", 0);
        } else {
            JOptionPane.showMessageDialog(tree_, "Purge Messages Aborted.", "Purge Error", 0);
        }
    }
}

