/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Component;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.exolab.jms.authentication.User;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.DatabaseFilter;
import org.exolab.jms.tools.admin.OfflineConnectionException;

public class OfflineConnection
extends AbstractAdminConnection {
    private Component _parent;
    private Context _context;

    public OfflineConnection(Component parent) throws OfflineConnectionException {
        block6: {
            this._context = null;
            try {
                if (AbstractAdminConnection._instance == null) {
                    this._parent = parent;
                    Configuration config = ConfigurationManager.getConfig();
                    DatabaseConfiguration dbconfig = config.getDatabaseConfiguration();
                    if (dbconfig.getRdbmsDatabaseConfiguration() != null) {
                        DatabaseService.instance();
                        DatabaseService.getAdapter();
                        AbstractAdminConnection._instance = this;
                    } else {
                        JFileChooser chooser = new JFileChooser(".");
                        chooser.setDialogTitle("Select OpenJMS Database to connect to");
                        chooser.setFileFilter(new DatabaseFilter());
                        int returnVal = chooser.showOpenDialog(parent);
                        if (returnVal == 0) {
                            DatabaseService.instance();
                            DatabaseService.getAdapter();
                            AbstractAdminConnection._instance = this;
                        }
                    }
                    break block6;
                }
                throw new OfflineConnectionException("Already connected");
            }
            catch (Exception err) {
                throw new OfflineConnectionException("Database Error: " + err.getMessage());
            }
        }
    }

    public void close() {
        DatabaseService.getAdapter().close();
        AbstractAdminConnection._instance = null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addDurableConsumer(String topic, String name) {
        boolean result = false;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().addDurableConsumer(connection, topic, name);
        connection.commit();
        result = true;
        Object var8_5 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var8_6 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var8_7 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeDurableConsumer(String name) {
        boolean result = false;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().removeDurableConsumer(connection, name);
        connection.commit();
        result = true;
        Object var7_4 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var7_5 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var7_6 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean unregisterConsumer(String name) {
        return false;
    }

    public boolean isConnected(String name) {
        return false;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration getAllDestinations() {
        Enumeration result = null;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        result = DatabaseService.getAdapter().getAllDestinations(connection);
        connection.commit();
        Object var6_3 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var6_4 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var6_5 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addDestination(String destination, boolean isQueue) {
        JmsDestination jmsDestination;
        Connection connection = null;
        boolean success = false;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().addDestination(connection, destination, isQueue);
        if (this._context == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "org.exolab.jms.jndi.intravm.IntravmJndiServer");
            this._context = new InitialContext(hashtable);
        }
        JmsDestination jmsDestination2 = jmsDestination = isQueue ? new JmsQueue(destination) : new JmsTopic(destination);
        if (jmsDestination instanceof JmsQueue) {
            ((JmsDestination)jmsDestination).setPersistent(true);
        }
        this._context.rebind(destination, (Object)jmsDestination);
        connection.commit();
        success = true;
        Object var9_8 = null;
        if (connection == null) return success;
        try {
            connection.close();
            return success;
        }
        catch (Exception nested) {}
        return success;
        {
            catch (PersistenceException persistenceException) {
                System.err.println("Failed to add destination " + destination + " b/c " + ((Throwable)((Object)persistenceException)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var9_9 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception nested) {}
                return success;
            }
            catch (NamingException err) {
                System.err.println("Failed to add " + destination + " in JNDI context");
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var9_10 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception nested) {}
                return success;
            }
            catch (Exception exception) {
                Object var9_11 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception nested) {}
                return success;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDurableConsumerMessageCount(String topic, String name) {
        int count = -1;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        count = DatabaseService.getAdapter().getDurableConsumerMessageCount(connection, topic, name);
        connection.commit();
        Object var8_5 = null;
        if (connection == null) return count;
        try {
            connection.close();
            return count;
        }
        catch (Exception nested) {}
        return count;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed to get message count for " + topic + " b/c " + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var8_6 = null;
                if (connection == null) return count;
                try {
                    connection.close();
                    return count;
                }
                catch (Exception nested) {}
                return count;
            }
            catch (Exception exception) {
                Object var8_7 = null;
                if (connection == null) return count;
                try {
                    connection.close();
                    return count;
                }
                catch (Exception nested) {}
                return count;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getQueueMessageCount(String queue) {
        int count = -1;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        count = DatabaseService.getAdapter().getQueueMessageCount(connection, queue);
        connection.commit();
        Object var7_4 = null;
        if (connection == null) return count;
        try {
            connection.close();
            return count;
        }
        catch (Exception nested) {}
        return count;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed to get message count for " + queue + " b/c " + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var7_5 = null;
                if (connection == null) return count;
                try {
                    connection.close();
                    return count;
                }
                catch (Exception nested) {}
                return count;
            }
            catch (Exception exception) {
                Object var7_6 = null;
                if (connection == null) return count;
                try {
                    connection.close();
                    return count;
                }
                catch (Exception nested) {}
                return count;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean durableConsumerExists(String name) {
        boolean result = false;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        result = DatabaseService.getAdapter().durableConsumerExists(connection, name);
        connection.commit();
        Object var7_4 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed on consumer exists for " + name + " b/c " + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var7_5 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var7_6 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration getDurableConsumers(String topic) {
        Enumeration result = null;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        result = DatabaseService.getAdapter().getDurableConsumers(connection, topic);
        connection.commit();
        Object var7_4 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed on getDurableConsumers for " + topic + " b/c " + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var7_5 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var7_6 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeDestination(String destination) {
        boolean result = false;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().removeDestination(connection, destination);
        if (this._context == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("java.naming.factory.initial", "org.exolab.jms.jndi.intravm.IntravmJndiServer");
            this._context = new InitialContext(props);
        }
        this._context.unbind(destination);
        connection.commit();
        result = true;
        Object var8_6 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed on getDurableConsumers for " + destination + " b/c " + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var8_7 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (NamingException err) {
                System.err.println("Failed to removeDestination " + destination + " b/c" + err.toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var8_8 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var8_9 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public int purgeMessages() {
        return DatabaseService.getAdapter().purgeMessages();
    }

    public void stopServer() {
        JOptionPane.showMessageDialog(this._parent, "Not available in offline mode", "Shutdown Error", 0);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addUser(String username, String password) {
        Connection connection = null;
        boolean success = false;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().addUser(connection, new User(username, password));
        connection.commit();
        success = true;
        Object var8_5 = null;
        if (connection == null) return success;
        try {
            connection.close();
            return success;
        }
        catch (Exception nested) {}
        return success;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed to add user " + username + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var8_6 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception nested) {}
                return success;
            }
            catch (Exception exception) {
                Object var8_7 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception nested) {}
                return success;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean changePassword(String username, String password) {
        Connection connection = null;
        boolean success = false;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().updateUser(connection, new User(username, password));
        connection.commit();
        success = true;
        Object var8_5 = null;
        if (connection == null) return success;
        try {
            connection.close();
            return success;
        }
        catch (Exception nested) {}
        return success;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed to add user " + username + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var8_6 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception nested) {}
                return success;
            }
            catch (Exception exception) {
                Object var8_7 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception nested) {}
                return success;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeUser(String username) {
        boolean result = false;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().removeUser(connection, new User(username, null));
        connection.commit();
        result = true;
        Object var7_4 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed on remove user for " + username + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var7_5 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var7_6 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration getAllUsers() {
        Enumeration result = null;
        Connection connection = null;
        connection = DatabaseService.getConnection();
        result = DatabaseService.getAdapter().getAllUsers(connection);
        connection.commit();
        Object var6_3 = null;
        if (connection == null) return result;
        try {
            connection.close();
            return result;
        }
        catch (Exception nested) {}
        return result;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed on getAllUsers " + ((Throwable)((Object)exception)).toString());
                try {
                    connection.rollback();
                }
                catch (Exception nested) {
                }
                Object var6_4 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
            catch (Exception exception) {
                Object var6_5 = null;
                if (connection == null) return result;
                try {
                    connection.close();
                    return result;
                }
                catch (Exception nested) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

