/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.exolab.jms.config.AdminConfiguration;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.AdminInfo;
import org.exolab.jms.tools.admin.ChangePasswordDialog;
import org.exolab.jms.tools.admin.CreateLogonDialog;
import org.exolab.jms.tools.admin.CreateQueueDialog;
import org.exolab.jms.tools.admin.CreateTopicDialog;
import org.exolab.jms.tools.admin.CreateUserDialog;
import org.exolab.jms.tools.admin.OfflineConnection;
import org.exolab.jms.tools.admin.OnlineConnection;
import org.exolab.jms.tools.admin.OpenJMSEditor;
import org.exolab.jms.tools.admin.OpenJMSNode;
import org.exolab.jms.tools.admin.OpenJMSServer;
import org.exolab.jms.tools.admin.QueryDialog;
import org.exolab.jms.util.CommandLine;

public class AdminMgr
extends JFrame {
    private JMenuBar _menuBar;
    private JMenu _file;
    private JMenuItem _exit;
    private JMenu _actions;
    private JMenu _connections;
    private JMenuItem _refresh;
    private JMenuItem _online;
    private JMenuItem _offline;
    private JMenuItem _disconnect;
    private JSeparator _separator;
    private JMenuItem _startup;
    private JMenuItem _shutdown;
    private JScrollPane _jmsServers;
    private JTree _serverProperties;
    private JTextField _messageArea;
    private JComboBox _jmsCombo;
    private boolean _connected = false;
    private static String _serverStart = null;
    private static String _serverConfig = null;
    private StreamRedirect _output = null;
    static /* synthetic */ Class class$org$exolab$jms$tools$admin$AdminMgr;

    public AdminMgr() {
        this("");
    }

    public AdminMgr(String title) {
        this.initComponents(title);
        this.pack();
    }

    private void initComponents(String title) {
        this._menuBar = new JMenuBar();
        this._file = new JMenu();
        this._exit = new JMenuItem();
        this._actions = new JMenu();
        this._connections = new JMenu();
        this._refresh = new JMenuItem();
        this._online = new JMenuItem();
        this._offline = new JMenuItem();
        this._disconnect = new JMenuItem();
        this._separator = new JSeparator();
        this._startup = new JMenuItem();
        this._shutdown = new JMenuItem();
        this._jmsServers = new JScrollPane();
        this._jmsCombo = new JComboBox();
        this._serverProperties = new JTree();
        this.setTitle("OpenJMS Administrator: " + title);
        DefaultTreeModel serverModel = OpenJMSServer.createServerList(this._serverProperties);
        this._serverProperties.setModel(serverModel);
        AdminInfo info = new AdminInfo();
        this._serverProperties.setCellRenderer(info);
        this._messageArea = new JTextField();
        this._file.setText("File");
        this._exit.setToolTipText("Exit administration");
        this._exit.setText("Exit");
        this._exit.setMnemonic('x');
        this._serverProperties.setRootVisible(false);
        this._serverProperties.setShowsRootHandles(true);
        this._serverProperties.putClientProperty("JTree.lineStyle", "Angled");
        this._serverProperties.setCellEditor(new OpenJMSEditor(this._serverProperties, this._jmsCombo));
        this._serverProperties.setEditable(false);
        this.setupCallbacks();
        this._file.add(this._exit);
        this._file.setMnemonic('F');
        this._menuBar.add(this._file);
        this._actions.setText("Actions");
        this._actions.setMnemonic('A');
        this._connections.setText("Connections");
        this._connections.setMnemonic('C');
        this._refresh.setToolTipText("Refresh the display");
        this._online.setToolTipText("Connect to a running OpenJMS Server");
        this._offline.setToolTipText("Connect directly to an OpenJMS database");
        this._refresh.setText("Refresh");
        this._refresh.setMnemonic('R');
        this._actions.add(this._refresh);
        this._online.setText("Online");
        this._online.setMnemonic('O');
        this._offline.setText("Offline");
        this._offline.setMnemonic('f');
        this._connections.add(this._online);
        this._connections.add(this._offline);
        this._actions.add(this._connections);
        this._disconnect.setToolTipText("Disconnect from any connected OpenJMS Servers");
        this._disconnect.setText("Disconnect");
        this._disconnect.setMnemonic('D');
        this._actions.add(this._disconnect);
        this._actions.add(this._separator);
        this._startup.setToolTipText("Start the OpenJMS server");
        this._startup.setText("Start OpenJMS");
        this._startup.setMnemonic('S');
        this._shutdown.setToolTipText("Shutdown the connected OpenJMS server");
        this._shutdown.setText("Shutdown OpenJMS");
        this._shutdown.setMnemonic('h');
        this._actions.add(this._startup);
        this._actions.add(this._shutdown);
        this._menuBar.add(this._actions);
        this._jmsServers.setViewportView(this._serverProperties);
        this.getContentPane().add((Component)this._jmsServers, "Center");
        this._messageArea.setToolTipText("Message Area");
        this._messageArea.setEditable(false);
        this._messageArea.setForeground(Color.red);
        this._messageArea.setText("Not Connected");
        this._messageArea.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this._messageArea, "South");
        this.setJMenuBar(this._menuBar);
        this._startup.setEnabled(true);
        this._shutdown.setEnabled(false);
        this._refresh.setEnabled(false);
        this._disconnect.setEnabled(false);
    }

    private void exitAdmin(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void refresh(ActionEvent evt) {
        if (AbstractAdminConnection.instance() instanceof OnlineConnection) {
            this.setConnected(false, null);
            this.setConnected(true, "Connected - Online Mode");
            this._startup.setEnabled(false);
            this._shutdown.setEnabled(true);
        } else {
            ((OpenJMSServer)this._serverProperties.getModel().getRoot()).refresh();
        }
    }

    private void startup(ActionEvent evt) {
        try {
            String[] args = this.getStartCommand();
            System.out.print("running ");
            int i = 0;
            int j = args.length;
            while (i < j) {
                System.out.print(args[i] + " ");
                ++i;
            }
            System.out.println();
            if (this._output != null) {
                this._output.interrupt();
            }
            Process proc = Runtime.getRuntime().exec(args);
            this._output = new StreamRedirect(proc.getInputStream());
            this._output.start();
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(this, "Failed to Startup OpenJMSServer:\n" + err + "\nCheck config file", "OpenJMSServer Startup", 0);
        }
    }

    private void onlineConnect(ActionEvent evt) {
        try {
            new OnlineConnection(this);
            this._startup.setEnabled(false);
            this._shutdown.setEnabled(true);
            this.setConnected(true, "Connected - Online Mode");
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), "Online Connection Error", 0);
        }
    }

    private void offlineConnect(ActionEvent evt) {
        try {
            new OfflineConnection(this);
            this._startup.setEnabled(false);
            this._shutdown.setEnabled(false);
            this.setConnected(true, "Connected - OFFLine Mode");
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), "Database Error", 0);
        }
    }

    private void disconnect(ActionEvent evt) {
        try {
            AbstractAdminConnection.instance().close();
            this.setConnected(false, null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Database Close Error", 0);
        }
    }

    private void setConnected(boolean c, String st) {
        if (c) {
            this._serverProperties.setRootVisible(true);
            ((OpenJMSServer)this._serverProperties.getModel().getRoot()).displayConnections();
            this._connections.setEnabled(false);
            this._refresh.setEnabled(true);
            this._disconnect.setEnabled(true);
            this._messageArea.setForeground(Color.green.darker().darker());
            this._messageArea.setText(st);
            this._connected = true;
        } else {
            this._serverProperties.setRootVisible(false);
            OpenJMSServer root = (OpenJMSServer)this._serverProperties.getModel().getRoot();
            root.removeAllChildren();
            DefaultTreeModel model = (DefaultTreeModel)this._serverProperties.getModel();
            model.nodeStructureChanged(root);
            this._connections.setEnabled(true);
            this._startup.setEnabled(true);
            this._shutdown.setEnabled(false);
            this._refresh.setEnabled(false);
            this._disconnect.setEnabled(false);
            this._messageArea.setForeground(Color.red);
            this._messageArea.setText("Not Connected");
            this._connected = false;
        }
    }

    private void setupCallbacks() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AdminMgr.this.exitForm(evt);
            }
        });
        this._serverProperties.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!AdminMgr.this._connected) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    int selRow = AdminMgr.this._serverProperties.getRowForLocation(e.getX(), e.getY());
                    AdminMgr.this._serverProperties.setSelectionRow(selRow);
                    Object loc = AdminMgr.this._serverProperties.getLastSelectedPathComponent();
                    if (loc instanceof OpenJMSNode) {
                        OpenJMSNode node = (OpenJMSNode)loc;
                        node.displayCommands(AdminMgr.this._serverProperties.getRowBounds(selRow));
                    } else if (loc instanceof OpenJMSServer) {
                        ((OpenJMSServer)loc).displayCommands(AdminMgr.this._serverProperties.getRowBounds(selRow));
                    }
                }
            }
        });
        this._serverProperties.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                Object loc = path.getLastPathComponent();
                if (loc instanceof OpenJMSNode) {
                    OpenJMSNode node = (OpenJMSNode)loc;
                    node.update();
                }
            }
        });
        this._exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.exitAdmin(evt);
            }
        });
        this._refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.refresh(evt);
            }
        });
        this._online.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.onlineConnect(evt);
            }
        });
        this._offline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.offlineConnect(evt);
            }
        });
        this._disconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.disconnect(evt);
            }
        });
        this._startup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.startup(evt);
            }
        });
        this._shutdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    AbstractAdminConnection.instance().stopServer();
                    AdminMgr.this.setConnected(false, null);
                }
                catch (NullPointerException err) {
                    JOptionPane.showMessageDialog(AdminMgr.this._file, "Must connect with online mode \nto shutdown server", "Shutdown Error", 0);
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            CommandLine cmdline = new CommandLine(args);
            boolean helpSet = cmdline.exists("help");
            boolean configSet = cmdline.exists("config");
            boolean stopServer = cmdline.exists("stopServer");
            String username = cmdline.value("u");
            String password = cmdline.value("p");
            if (helpSet) {
                AdminMgr.usage();
            } else if (!configSet && !stopServer && args.length != 0) {
                AdminMgr.usage();
            } else {
                String configFile = cmdline.value("config");
                if (configFile == null) {
                    String home = AdminMgr.getOpenJMSHome();
                    configFile = home + "/config/openjms.xml";
                }
                ConfigurationManager.setConfig(configFile);
                Configuration config = ConfigurationManager.getConfig();
                String path = config.getLoggerConfiguration().getFile();
                if (path != null) {
                    DOMConfigurator.configure((String)path);
                }
                AdminConfiguration adminConfig = null;
                adminConfig = config.getAdminConfiguration();
                _serverStart = adminConfig.getScript();
                _serverConfig = adminConfig.getConfig();
                if (_serverConfig == null) {
                    _serverConfig = configFile;
                }
                if (stopServer) {
                    new OnlineConnection(username, password);
                    AbstractAdminConnection.instance().stopServer();
                } else {
                    AdminMgr admin = new AdminMgr(configFile);
                    QueryDialog.create(admin);
                    CreateQueueDialog.create(admin);
                    CreateTopicDialog.create(admin);
                    CreateLogonDialog.create(admin);
                    CreateUserDialog.create(admin);
                    ChangePasswordDialog.create(admin);
                    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                    ((Component)admin).setLocation(screen.width / 2 - 150, screen.height / 2 - 150);
                    ((Component)admin).setSize(300, 300);
                    admin.invalidate();
                    admin.show();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            System.err.println("Failed to initialize AdminMgr.\nExiting....");
        }
    }

    protected static void usage() {
        PrintStream out = System.out;
        out.println("\n\n");
        out.println("=====================================================");
        out.println("Usage information for " + (class$org$exolab$jms$tools$admin$AdminMgr == null ? (class$org$exolab$jms$tools$admin$AdminMgr = AdminMgr.class$("org.exolab.jms.tools.admin.AdminMgr")) : class$org$exolab$jms$tools$admin$AdminMgr).getName());
        out.println("=====================================================");
        out.println("\n" + (class$org$exolab$jms$tools$admin$AdminMgr == null ? (class$org$exolab$jms$tools$admin$AdminMgr = AdminMgr.class$("org.exolab.jms.tools.admin.AdminMgr")) : class$org$exolab$jms$tools$admin$AdminMgr).getName());
        out.println("    [-help | -config <xml config file>]\n");
        out.println("\t-help   displays this screen\n");
        out.println("\t-config file name of xml-based config file\n");
    }

    private String[] getStartCommand() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (_serverStart != null) {
            Perl5Compiler compiler = new Perl5Compiler();
            Pattern pattern = compiler.compile("'.*'|[^\\s]*");
            Perl5Matcher matcher = new Perl5Matcher();
            PatternMatcherInput input = new PatternMatcherInput(_serverStart);
            while (matcher.contains(input, pattern)) {
                String arg = matcher.getMatch().toString();
                if (arg.startsWith("'") && arg.endsWith("'")) {
                    arg = arg.substring(1, arg.length() - 1);
                }
                args.add(arg);
            }
        }
        args.add("-config");
        args.add(_serverConfig);
        return args.toArray(new String[0]);
    }

    private static String getOpenJMSHome() {
        return System.getProperty("openjms.home", System.getProperty("user.dir"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StreamRedirect
    extends Thread {
        InputStream is_;

        StreamRedirect(InputStream is) {
            this.is_ = is;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is_);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

