/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.client.rmi.RemoteJmsMessageListenerIfc;
import org.exolab.jms.server.ClientDisconnectionException;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.server.rmi.RemoteJmsServerSessionIfc;

public class RmiJmsServerSession
extends UnicastRemoteObject
implements RemoteJmsServerSessionIfc,
JmsMessageListener {
    private JmsServerSession _delegate = null;
    private RemoteJmsMessageListenerIfc _listener = null;

    public RmiJmsServerSession(JmsServerSession session) throws JMSException, RemoteException {
        if (session == null) {
            throw new JMSException("Cannot create RmiJmsServerSession with null session");
        }
        this._delegate = session;
    }

    public synchronized String getClientId() throws RemoteException {
        return this._delegate.getClientId();
    }

    public synchronized String getSessionId() throws JMSException, RemoteException {
        return this._delegate.getSessionId();
    }

    public synchronized void close() throws JMSException, RemoteException {
        this._listener = null;
        this._delegate.close();
        this._delegate = null;
    }

    public synchronized void acknowledgeMessage(long clientId, String messageId) throws JMSException, RemoteException {
        this._delegate.acknowledgeMessage(clientId, messageId);
    }

    public synchronized void sendMessage(Message message) throws JMSException, RemoteException {
        this._delegate.sendMessage(message);
    }

    public synchronized void sendMessages(Vector messages) throws JMSException, RemoteException {
        this._delegate.sendMessages(messages);
    }

    public Message receiveMessage(long clientId, long wait) throws JMSException, RemoteException {
        return this._delegate.receiveMessage(clientId, wait);
    }

    public Vector receiveMessages(long clientId, int count) throws JMSException, RemoteException {
        return this._delegate.receiveMessages(clientId, count);
    }

    public synchronized void createQueue(JmsQueue queue) throws JMSException, RemoteException {
        this._delegate.createQueue(queue);
    }

    public synchronized void createTopic(JmsTopic topic) throws JMSException, RemoteException {
        this._delegate.createTopic(topic);
    }

    public synchronized void createReceiver(JmsQueue queue, long clientId, String selector) throws JMSException, RemoteException {
        this._delegate.createReceiver(queue, clientId, selector);
    }

    public synchronized void createSender(JmsQueue queue) throws JMSException, RemoteException {
        this._delegate.createSender(queue);
    }

    public synchronized void createBrowser(JmsQueue queue, long clientId, String selector) throws JMSException {
        this._delegate.createBrowser(queue, clientId, selector);
    }

    public synchronized void deleteReceiver(long clientId) throws JMSException, RemoteException {
        this._delegate.deleteReceiver(clientId);
    }

    public synchronized void deleteSender(long clientId) throws JMSException, RemoteException {
        this._delegate.deleteSender(clientId);
    }

    public synchronized void deleteBrowser(long clientId) throws JMSException {
        this._delegate.deleteBrowser(clientId);
    }

    public synchronized void createSubscriber(JmsTopic topic, String name, long clientId, String selector, boolean noLocal) throws JMSException, RemoteException {
        this._delegate.createSubscriber(topic, name, clientId, selector, noLocal);
    }

    public synchronized void createPublisher(JmsTopic topic) throws JMSException, RemoteException {
        this._delegate.createPublisher(topic);
    }

    public synchronized void deleteSubscriber(long clientId) throws JMSException, RemoteException {
        this._delegate.deleteSubscriber(clientId);
    }

    public synchronized void deletePublisher(JmsTopic topic) throws JMSException, RemoteException {
        this._delegate.deletePublisher(topic);
    }

    public synchronized void unsubscribe(String name) throws JMSException {
        this._delegate.unsubscribe(name);
    }

    public synchronized void stopMessageDelivery() throws JMSException, RemoteException {
        this._delegate.stopMessageDelivery();
    }

    public synchronized void startMessageDelivery() throws JMSException, RemoteException {
        this._delegate.startMessageDelivery();
    }

    public synchronized void recover() throws JMSException, RemoteException {
        this._delegate.recover();
    }

    public synchronized void commit() throws JMSException, RemoteException {
        this._delegate.commit();
    }

    public synchronized void rollback() throws JMSException, RemoteException {
        this._delegate.rollback();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException, RemoteException {
        this._delegate.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException, RemoteException {
        this._delegate.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException, RemoteException {
        this._delegate.forget(xid);
    }

    public int getTransactionTimeout() throws XAException, RemoteException {
        return this._delegate.getTransactionTimeout();
    }

    public int prepare(Xid xid) throws XAException, RemoteException {
        return this._delegate.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException, RemoteException {
        return this._delegate.recover(flag);
    }

    public void rollback(Xid xid) throws XAException, RemoteException {
        this._delegate.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException, RemoteException {
        return this._delegate.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException, RemoteException {
        this._delegate.start(xid, flags);
    }

    public String getResourceManagerId() throws XAException, RemoteException {
        return this._delegate.getResourceManagerId();
    }

    public synchronized void setMessageListener(RemoteJmsMessageListenerIfc listener) throws JMSException, RemoteException {
        this._listener = listener;
        this._delegate.setMessageListener(this);
    }

    public void enableAsynchronousDelivery(long clientId, String id, boolean enable) throws JMSException, RemoteException {
        this._delegate.enableAsynchronousDelivery(clientId, id, enable);
    }

    public void onMessage(Message message) {
        if (this._listener != null) {
            try {
                this._listener.onMessage(message);
            }
            catch (RemoteException exception) {
                throw new ClientDisconnectionException("Failed in onMessage " + exception);
            }
        } else {
            throw new ClientDisconnectionException("No listener registered for this session");
        }
    }

    public void onMessages(Vector messages) {
        if (this._listener != null) {
            try {
                this._listener.onMessages(messages);
            }
            catch (RemoteException exception) {
                exception.printStackTrace();
                throw new ClientDisconnectionException("Failed in onMessages " + exception);
            }
        } else {
            throw new ClientDisconnectionException("No listener registered for this session");
        }
    }

    public void onMessageAvailable(long clientId) {
        if (this._listener != null) {
            try {
                this._listener.onMessageAvailable(clientId);
            }
            catch (RemoteException exception) {
                throw new ClientDisconnectionException("Failed in onMessageAvailable " + exception);
            }
        } else {
            throw new ClientDisconnectionException("No listener registered for this session");
        }
    }
}

