/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.rmi;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.config.ConfigHelper;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.server.ConnectionFactoryHelper;
import org.exolab.jms.server.JmsServerConnection;
import org.exolab.jms.server.JmsServerConnectionManager;
import org.exolab.jms.server.JmsServerIfc;
import org.exolab.jms.server.ServerException;
import org.exolab.jms.server.rmi.RemoteJmsServerConnectionIfc;
import org.exolab.jms.server.rmi.RemoteJmsServerIfc;
import org.exolab.jms.server.rmi.RmiJmsAdminServer;
import org.exolab.jms.server.rmi.RmiJmsServerConnection;

public class RmiJmsServer
extends UnicastRemoteObject
implements JmsServerIfc,
RemoteJmsServerIfc {
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$rmi$RmiJmsServer == null ? (class$org$exolab$jms$server$rmi$RmiJmsServer = RmiJmsServer.class$("org.exolab.jms.server.rmi.RmiJmsServer")) : class$org$exolab$jms$server$rmi$RmiJmsServer));
    static /* synthetic */ Class class$org$exolab$jms$server$rmi$RmiJmsServer;
    static /* synthetic */ Class class$org$exolab$jms$client$rmi$RmiJmsServerStub;

    public void init() throws ServerException {
        try {
            System.setSecurityManager(new RMISecurityManager());
            Configuration config = ConfigurationManager.getConfig();
            String serverBinding = ConfigHelper.getServerURL(SchemeType.RMI, config);
            Naming.rebind(serverBinding, this);
            _log.info((Object)("JMS Server is bound to " + serverBinding));
            String adminBinding = ConfigHelper.getAdminURL(SchemeType.RMI, config);
            Naming.rebind(adminBinding, new RmiJmsAdminServer());
            _log.info((Object)("JMS Admin Server is bound to " + adminBinding));
        }
        catch (Exception exception) {
            throw new ServerException("Failed to initialise the RMI server interface", exception);
        }
    }

    public void bindConnectionFactories(Context context) throws NamingException {
        Configuration config = ConfigurationManager.getConfig();
        Hashtable<String, String> env = new Hashtable<String, String>();
        String url = ConfigHelper.getServerURL(SchemeType.RMI, config);
        env.put("org.exolab.jms.rmi.server", url);
        env.put("org.exolab.jms.rmi.server.client_ping_interval", Integer.toString(this.getClientPingInterval()));
        Connector connector = ConfigurationManager.getConnector(SchemeType.RMI);
        ConnectionFactoryHelper.bind(context, connector.getConnectionFactories(), class$org$exolab$jms$client$rmi$RmiJmsServerStub == null ? (class$org$exolab$jms$client$rmi$RmiJmsServerStub = RmiJmsServer.class$("org.exolab.jms.client.rmi.RmiJmsServerStub")) : class$org$exolab$jms$client$rmi$RmiJmsServerStub, env);
    }

    public RemoteJmsServerConnectionIfc createConnection(String id, String username, String password) throws JMSException, RemoteException {
        JmsServerConnection connection = JmsServerConnectionManager.instance().createConnection(id, username, password);
        return new RmiJmsServerConnection(connection, this.getClientPingInterval());
    }

    protected int getClientPingInterval() {
        Configuration config = ConfigurationManager.getConfig();
        return config.getRmiConfiguration().getClientPingInterval();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

