/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.mipc;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.ipc.NotifierIfc;
import org.exolab.core.mipc.DisconnectionEventListener;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.ObjectChannel;
import org.exolab.jms.server.mipc.IpcJmsServerConnection;

public class IpcServerChannel
extends Thread
implements DisconnectionEventListener {
    private MultiplexConnectionIfc _connection;
    private ObjectChannel _oc;
    private NotifierIfc _client;
    private String _id;
    private volatile boolean _stopRequested = false;
    private static int _nextID = 0;
    private static HashMap _channels = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$mipc$IpcServerChannel == null ? (class$org$exolab$jms$server$mipc$IpcServerChannel = IpcServerChannel.class$("org.exolab.jms.server.mipc.IpcServerChannel")) : class$org$exolab$jms$server$mipc$IpcServerChannel));
    static /* synthetic */ Class class$org$exolab$jms$server$mipc$IpcServerChannel;

    public IpcServerChannel(MultiplexConnectionIfc connection, NotifierIfc client, String channel) {
        super(channel + "-" + IpcServerChannel.getNextID());
        this._connection = connection;
        this._connection.setDisconnectionEventListener((DisconnectionEventListener)this);
        this._client = client;
        this._oc = new ObjectChannel(channel, connection);
        this._id = this.getName();
        IpcServerChannel.addServerChannel(this);
    }

    public MultiplexConnectionIfc getConnection() {
        return this._connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this._stopRequested) {
            try {
                Object object = this._oc.receive();
                Serializable returnValue = this._client.notify(object, this._id);
                if (returnValue == null) continue;
                this._oc.send(returnValue);
            }
            catch (Exception exception) {
                if (this._stopRequested) continue;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        try {
            try {
                this._client.disconnection(this._id);
                this._oc.close();
            }
            catch (Exception ignore) {
                Object var4_6 = null;
                IpcServerChannel.removeServerChannel(this);
                this._client = null;
                this._connection = null;
                return;
            }
            Object var4_5 = null;
            IpcServerChannel.removeServerChannel(this);
            this._client = null;
            this._connection = null;
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            IpcServerChannel.removeServerChannel(this);
            this._client = null;
            this._connection = null;
            throw throwable;
        }
    }

    public void shutdown() {
        this._stopRequested = true;
        this.interrupt();
    }

    public void disconnected(MultiplexConnectionIfc connection) {
        this.shutdown();
        new IpcJmsServerConnection().disconnection(this._id);
    }

    public static synchronized IpcServerChannel getServerChannel(String id) {
        return (IpcServerChannel)_channels.get(id);
    }

    private static synchronized void addServerChannel(IpcServerChannel newChannel) {
        _channels.put(newChannel._id, newChannel);
    }

    private static synchronized void removeServerChannel(IpcServerChannel removeChannel) {
        _channels.remove(removeChannel._id);
    }

    private static synchronized int getNextID() {
        return _nextID++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

