/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.mipc;

import java.util.Vector;
import javax.jms.Message;
import org.exolab.core.mipc.ObjectChannel;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.ClientDisconnectionException;
import org.exolab.jms.server.JmsServerSession;

public class IpcJmsSessionSender
implements JmsMessageListener {
    private ObjectChannel _client;
    private JmsServerSession _session = null;

    public IpcJmsSessionSender(ObjectChannel client, JmsServerSession session) {
        this._client = client;
        this._session = session;
        session.setMessageListener(this);
    }

    public synchronized void onMessage(Message message) {
        try {
            if (this._client != null) {
                Vector<Object> v = new Vector<Object>(2);
                v.add(this._session.getSessionId());
                v.add((MessageImpl)message);
                this._client.send(v);
                Vector vector = (Vector)this._client.receive();
            }
        }
        catch (Exception err) {
            throw new ClientDisconnectionException(err.getMessage());
        }
    }

    public synchronized void onMessages(Vector messages) {
        try {
            if (this._client != null) {
                Vector<Object> v = new Vector<Object>(2);
                v.add(this._session.getSessionId());
                v.add(messages);
                this._client.send(v);
                Vector vector = (Vector)this._client.receive();
            }
        }
        catch (Exception err) {
            throw new ClientDisconnectionException(err.getMessage());
        }
    }

    public synchronized void onMessageAvailable(long clientId) {
        Scheduler.instance().add(new Notifier(clientId));
    }

    public synchronized void close() {
        if (this._session != null) {
            this._session.setMessageListener(null);
            this._session = null;
        }
        this._client = null;
    }

    private class Notifier
    implements Runnable {
        private long _clientId;

        public Notifier(long clientId) {
            this._clientId = clientId;
        }

        public void run() {
            IpcJmsSessionSender ipcJmsSessionSender = IpcJmsSessionSender.this;
            synchronized (ipcJmsSessionSender) {
                try {
                    if (IpcJmsSessionSender.this._client != null) {
                        Vector<Object> v = new Vector<Object>(2);
                        v.add(IpcJmsSessionSender.this._session.getSessionId());
                        v.add(new Long(this._clientId));
                        IpcJmsSessionSender.this._client.send(v);
                        Vector vector = (Vector)IpcJmsSessionSender.this._client.receive();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

