/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.mipc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.ObjectChannel;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.server.mipc.IpcJmsSessionSender;

public class IpcJmsSessionList {
    private ObjectChannel _client;
    private HashMap _list = new HashMap(10);

    public IpcJmsSessionList(MultiplexConnectionIfc connection) throws IOException {
        this._client = new ObjectChannel("message", connection);
    }

    public synchronized void add(JmsServerSession session) {
        if (!this._list.containsKey(session.getSessionId())) {
            this._list.put(session.getSessionId(), new IpcJmsSessionSender(this._client, session));
        }
    }

    public synchronized boolean remove(JmsServerSession session) {
        IpcJmsSessionSender sender = (IpcJmsSessionSender)this._list.remove(session.getSessionId());
        boolean result = false;
        if (sender != null) {
            sender.close();
        }
        if (this._list.isEmpty()) {
            this.closeConnection();
            this._list = null;
            result = true;
        }
        return result;
    }

    public synchronized void removeAll() {
        Iterator iterator = this._list.values().iterator();
        while (iterator.hasNext()) {
            IpcJmsSessionSender sender = (IpcJmsSessionSender)iterator.next();
            sender.close();
        }
        this._list.clear();
        this.closeConnection();
        this._list = null;
    }

    private void closeConnection() {
        if (this._client != null) {
            try {
                this._client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._client = null;
        }
    }
}

