/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.mipc;

import java.io.Serializable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.ipc.NotifierIfc;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.server.JmsServerConnection;
import org.exolab.jms.server.JmsServerConnectionManager;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.server.mipc.IpcJmsServer;
import org.exolab.jms.server.mipc.IpcServerChannel;

public class IpcJmsSessionConnection
implements NotifierIfc {
    private IpcJmsServer _server;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$mipc$IpcJmsSessionConnection == null ? (class$org$exolab$jms$server$mipc$IpcJmsSessionConnection = IpcJmsSessionConnection.class$("org.exolab.jms.server.mipc.IpcJmsSessionConnection")) : class$org$exolab$jms$server$mipc$IpcJmsSessionConnection));
    static /* synthetic */ Class class$org$exolab$jms$server$mipc$IpcJmsSessionConnection;

    public IpcJmsSessionConnection(IpcJmsServer server) {
        this._server = server;
    }

    public Serializable notify(Object ob, String id) {
        Vector v = (Vector)ob;
        String func = (String)v.get(1);
        JmsServerSession session = this.getSession(id, v);
        Vector result = null;
        if (session == null) {
            JMSException error = new JMSException("Failed to process request " + func + ": session not found");
            result = this.pack(Boolean.FALSE, (Object)error);
        } else if (func.equals("close")) {
            result = this.close(session, this.getConnection(id));
        } else if (func.equals("acknowledgeMessage")) {
            result = this.acknowledgeMessage(session, (Long)v.get(5), (String)v.get(6));
        } else if (func.equals("sendMessage")) {
            result = this.sendMessage(session, (Message)v.get(5));
        } else if (func.equals("sendMessages")) {
            result = this.sendMessages(session, (Vector)v.get(5));
        } else if (func.equals("receiveMessage")) {
            result = this.receiveMessage(session, (Long)v.get(5), (Long)v.get(6));
        } else if (func.equals("receiveMessages")) {
            result = this.receiveMessages(session, (Long)v.get(5), (Integer)v.get(6));
        } else if (func.equals("createQueue")) {
            result = this.createQueue(session, (JmsQueue)v.get(5));
        } else if (func.equals("createTopic")) {
            result = this.createTopic(session, (JmsTopic)v.get(5));
        } else if (func.equals("createReceiver")) {
            result = this.createReceiver(session, (JmsQueue)v.get(5), (Long)v.get(6), (String)v.get(7), this.getConnection(id), (String)v.get(8), (String)v.get(9), (String)v.get(10));
        } else if (func.equals("createSender")) {
            result = this.createSender(session, (JmsQueue)v.get(5));
        } else if (func.equals("createBrowser")) {
            result = this.createBrowser(session, (JmsQueue)v.get(5), (Long)v.get(6), (String)v.get(7), this.getConnection(id), (String)v.get(8), (String)v.get(9), (String)v.get(10));
        } else if (func.equals("deleteReceiver")) {
            result = this.deleteReceiver(session, (Long)v.get(5));
        } else if (func.equals("deleteSender")) {
            result = this.deleteSender(session, (Long)v.get(5));
        } else if (func.equals("deleteBrowser")) {
            result = this.deleteBrowser(session, (Long)v.get(5));
        } else if (func.equals("createSubscriber")) {
            result = this.createSubscriber(session, (JmsTopic)v.get(5), (String)v.get(6), (Long)v.get(7), (String)v.get(8), (Boolean)v.get(9), this.getConnection(id), (String)v.get(10), (String)v.get(11), (String)v.get(12));
        } else if (func.equals("createPublisher")) {
            result = this.createPublisher(session, (JmsTopic)v.get(5));
        } else if (func.equals("deleteSubscriber")) {
            result = this.deleteSubscriber(session, (Long)v.get(5));
        } else if (func.equals("deletePublisher")) {
            result = this.deletePublisher(session, (JmsTopic)v.get(5));
        } else if (func.equals("unsubscribe")) {
            result = this.unsubscribe(session, (String)v.get(5));
        } else if (func.equals("stopMessageDelivery")) {
            result = this.stopMessageDelivery(session);
        } else if (func.equals("startMessageDelivery")) {
            result = this.startMessageDelivery(session);
        } else if (func.equals("recover")) {
            result = this.recover(session);
        } else if (func.equals("commit")) {
            result = this.commit(session);
        } else if (func.equals("rollback")) {
            result = this.rollback(session);
        } else if (func.equals("xa_commit")) {
            result = this.XACommit(session, (Xid)v.get(5), (Boolean)v.get(6));
        } else if (func.equals("xa_end")) {
            result = this.XAEnd(session, (Xid)v.get(5), (Integer)v.get(6));
        } else if (func.equals("xa_forget")) {
            result = this.XAForget(session, (Xid)v.get(5));
        } else if (func.equals("xa_getTransactionTimeout")) {
            result = this.XAGetTransactionTimeout(session);
        } else if (func.equals("xa_recover")) {
            result = this.XARecover(session, (Integer)v.get(5));
        } else if (func.equals("xa_rollback")) {
            result = this.XARollback(session, (Xid)v.get(5));
        } else if (func.equals("xa_setTransactionTimeout")) {
            result = this.XASetTransactionTimeout(session, (Integer)v.get(5));
        } else if (func.equals("xa_start")) {
            result = this.XAStart(session, (Xid)v.get(5), (Integer)v.get(6));
        } else if (func.equals("xa_prepare")) {
            result = this.XAPrepare(session, (Xid)v.get(5));
        } else if (func.equals("xa_getResourceManagerId")) {
            result = this.XAGetResourceManagerId(session);
        } else if (func.equals("enableAsynchronousDelivery")) {
            result = this.enableAsynchronousDelivery(session, (Long)v.get(5), (String)v.get(6), (Boolean)v.get(7));
        } else {
            JMSException error = new JMSException("Unknown request received: " + func);
            result = this.pack(Boolean.FALSE, (Object)error);
        }
        return result;
    }

    public void disconnection(String id) {
    }

    protected JmsServerSession getSession(String id, Vector v) {
        JmsServerConnection connection = JmsServerConnectionManager.instance().getConnection((String)v.get(2));
        JmsServerSession session = null;
        if (connection != null) {
            session = connection.getSession((String)v.get(4));
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Failed to locate connection=" + v.get(2)));
        }
        if (session == null && _log.isDebugEnabled()) {
            _log.debug((Object)("Failed to locate session=" + v.get(4)));
        }
        return session;
    }

    protected MultiplexConnectionIfc getConnection(String id) {
        IpcServerChannel channel = IpcServerChannel.getServerChannel(id);
        MultiplexConnectionIfc mc = null;
        if (channel != null) {
            mc = channel.getConnection();
        }
        return mc;
    }

    protected Vector close(JmsServerSession session, MultiplexConnectionIfc connection) {
        try {
            this._server.removeConnection(session, connection);
            session.close();
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector acknowledgeMessage(JmsServerSession session, Long clientId, String id) {
        try {
            session.acknowledgeMessage(clientId, id);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector sendMessage(JmsServerSession session, Message message) {
        boolean persistent = ((MessageImpl)message).isPersistent();
        try {
            session.sendMessage(message);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        if (persistent) {
            return this.pack(Boolean.TRUE, null);
        }
        return null;
    }

    protected Vector sendMessages(JmsServerSession session, Vector messages) {
        try {
            session.sendMessages(messages);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector receiveMessage(JmsServerSession session, Long clientId, Long wait) {
        Message message = null;
        try {
            message = session.receiveMessage(clientId, wait);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, message);
    }

    protected Vector receiveMessages(JmsServerSession session, Long clientId, Integer count) {
        Vector messages = null;
        try {
            messages = session.receiveMessages(clientId, count);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, messages);
    }

    protected Vector createQueue(JmsServerSession session, JmsQueue queue) {
        try {
            session.createQueue(queue);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector createTopic(JmsServerSession session, JmsTopic topic) {
        try {
            session.createTopic(topic);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector createReceiver(JmsServerSession session, JmsQueue queue, Long consumerId, String selector, MultiplexConnectionIfc connection, String host, String port, String url) {
        try {
            session.createReceiver(queue, consumerId, selector);
            this._server.addConnection(session, connection);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector createSender(JmsServerSession session, JmsQueue queue) {
        try {
            session.createSender(queue);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector createBrowser(JmsServerSession session, JmsQueue queue, Long clientId, String selector, MultiplexConnectionIfc connection, String host, String port, String url) {
        try {
            session.createBrowser(queue, clientId, selector);
            this._server.addConnection(session, connection);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector deleteReceiver(JmsServerSession session, Long clientId) {
        try {
            session.deleteReceiver(clientId);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector deleteSender(JmsServerSession session, Long clientId) {
        try {
            session.deleteSender(clientId);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector deleteBrowser(JmsServerSession session, Long clientId) {
        try {
            session.deleteBrowser(clientId);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector createSubscriber(JmsServerSession session, JmsTopic topic, String name, Long clientId, String selector, Boolean noLocal, MultiplexConnectionIfc connection, String host, String port, String url) {
        try {
            session.createSubscriber(topic, name, clientId, selector, noLocal);
            this._server.addConnection(session, connection);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector createPublisher(JmsServerSession session, JmsTopic topic) {
        try {
            session.createPublisher(topic);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector deleteSubscriber(JmsServerSession session, Long clientId) {
        try {
            session.deleteSubscriber(clientId);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector deletePublisher(JmsServerSession session, JmsTopic topic) {
        try {
            session.deletePublisher(topic);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    public Vector unsubscribe(JmsServerSession session, String name) {
        try {
            session.unsubscribe(name);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector stopMessageDelivery(JmsServerSession session) {
        try {
            session.stopMessageDelivery();
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector enableAsynchronousDelivery(JmsServerSession session, Long clientId, String id, Boolean enable) {
        try {
            session.enableAsynchronousDelivery(clientId, id, enable);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector startMessageDelivery(JmsServerSession session) {
        try {
            session.startMessageDelivery();
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector recover(JmsServerSession session) {
        try {
            session.recover();
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector commit(JmsServerSession session) {
        try {
            session.commit();
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector rollback(JmsServerSession session) {
        try {
            session.rollback();
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector XACommit(JmsServerSession session, Xid xid, Boolean onePhase) {
        try {
            session.commit(xid, onePhase);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector XAEnd(JmsServerSession session, Xid xid, Integer flags) {
        try {
            session.end(xid, flags);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector XAForget(JmsServerSession session, Xid xid) {
        try {
            session.forget(xid);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector XAGetTransactionTimeout(JmsServerSession session) {
        int seconds = 0;
        try {
            seconds = session.getTransactionTimeout();
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, new Integer(seconds));
    }

    protected Vector XAPrepare(JmsServerSession session, Xid xid) {
        try {
            session.prepare(xid);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    public Vector XARecover(JmsServerSession session, Integer flag) {
        Xid[] xids = null;
        try {
            xids = session.recover(flag);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, xids);
    }

    protected Vector XARollback(JmsServerSession session, Xid xid) {
        try {
            session.rollback(xid);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector XASetTransactionTimeout(JmsServerSession session, Integer seconds) {
        boolean result = false;
        try {
            result = session.setTransactionTimeout(seconds);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, new Boolean(result));
    }

    protected Vector XAStart(JmsServerSession session, Xid xid, Integer flags) {
        try {
            session.start(xid, flags);
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, null);
    }

    protected Vector XAGetResourceManagerId(JmsServerSession session) {
        String id = null;
        try {
            id = session.getResourceManagerId();
        }
        catch (Exception exception) {
            return this.pack(Boolean.FALSE, exception);
        }
        return this.pack(Boolean.TRUE, id);
    }

    protected Vector pack(Boolean success, Object ob) {
        Vector<Object> v = new Vector<Object>(2);
        v.add(success);
        v.add(ob);
        return v;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

