/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.mipc;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import org.exolab.core.ipc.NotifierIfc;
import org.exolab.jms.server.JmsServerConnection;
import org.exolab.jms.server.JmsServerConnectionManager;
import org.exolab.jms.server.JmsServerSession;

public class IpcJmsServerConnection
implements NotifierIfc {
    private static Hashtable _connections = new Hashtable();

    public Serializable notify(Object ob, String id) {
        Vector v = (Vector)ob;
        String func = (String)v.get(1);
        Vector result = null;
        if (func.equals("createConnection")) {
            result = this.createConnection(id, (String)v.get(2), (String)v.get(3), (String)v.get(4));
        } else if (func.equals("createSession")) {
            result = this.createSession(id, (String)v.get(2), (String)v.get(3), (Integer)v.get(4), (Boolean)v.get(5));
        } else if (func.equals("close")) {
            result = this.close(id, (String)v.get(2), (String)v.get(3));
        } else {
            String st = "Unknown request received: " + func;
            System.err.println(st);
            result = this.pack(new Boolean(false), st);
        }
        return result;
    }

    public void disconnection(String id) {
        Vector v;
        Hashtable hashtable = _connections;
        synchronized (hashtable) {
            v = (Vector)_connections.remove(id);
        }
        if (v != null) {
            Object[] ob = v.toArray();
            JmsServerConnection con = null;
            int i = 0;
            int j = v.size();
            while (i < j) {
                con = JmsServerConnectionManager.instance().getConnection((String)ob[i]);
                if (con != null) {
                    con.close();
                }
                ++i;
            }
            v.clear();
            Object var2_3 = null;
        }
    }

    private void addConnection(String ipc, String id) {
        Hashtable hashtable = _connections;
        synchronized (hashtable) {
            Vector<String> v = (Vector<String>)_connections.get(ipc);
            if (v == null) {
                v = new Vector<String>();
                _connections.put(ipc, v);
            }
            v.add(id);
        }
    }

    private Vector createConnection(String ipcId, String clientId, String username, String password) {
        Vector result;
        try {
            JmsServerConnection connection = JmsServerConnectionManager.instance().createConnection(clientId, username, password);
            this.addConnection(ipcId, clientId);
            result = this.pack(new Boolean(true), connection.getConnectionId());
        }
        catch (JMSException exception) {
            result = this.pack(new Boolean(false), (Object)exception);
        }
        return result;
    }

    private Vector createSession(String ipcId, String clientId, String connectionId, Integer ackMode, Boolean transacted) {
        Vector result = null;
        JmsServerConnection connection = JmsServerConnectionManager.instance().getConnection(clientId);
        JmsServerSession session = null;
        if (connection != null) {
            session = connection.createSession(ackMode, transacted);
        }
        if (session != null) {
            Vector<String> state = new Vector<String>(2);
            state.add(session.getSessionId());
            result = this.pack(new Boolean(true), state);
        } else {
            result = this.pack(new Boolean(false), "Failed to create session");
        }
        return result;
    }

    private Vector close(String ipcId, String clientId, String connectionId) {
        Hashtable hashtable = _connections;
        synchronized (hashtable) {
            Vector connections = (Vector)_connections.get(ipcId);
            if (connections != null) {
                connections.remove(clientId);
                if (connections.isEmpty()) {
                    _connections.remove(ipcId);
                }
            }
        }
        JmsServerConnectionManager.instance().closeConnection(clientId);
        return this.pack(new Boolean(true), null);
    }

    private Vector pack(Boolean success, Object ob) {
        Vector<Object> v = new Vector<Object>(2);
        v.add(success);
        v.add(ob);
        return v;
    }
}

