/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.mipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.exolab.core.mipc.ConnectionNotifierIfc;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.MultiplexConnectionServer;
import org.exolab.core.mipc.MultiplexConnectionServerIfc;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.ConnectorHelper;
import org.exolab.jms.config.ConnectorResource;
import org.exolab.jms.config.ServerConfiguration;
import org.exolab.jms.config.TcpConfigurationType;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.server.ConnectionFactoryHelper;
import org.exolab.jms.server.JmsServerIfc;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.server.ServerException;
import org.exolab.jms.server.http.HttpJmsSessionConnection;
import org.exolab.jms.server.mipc.IpcJmsAdminConnection;
import org.exolab.jms.server.mipc.IpcJmsReceiver;
import org.exolab.jms.server.mipc.IpcJmsServerConnection;
import org.exolab.jms.server.mipc.IpcJmsSessionConnection;
import org.exolab.jms.server.mipc.IpcJmsSessionList;
import org.exolab.jms.server.mipc.IpcServerChannel;

public class IpcJmsServer
implements JmsServerIfc,
ConnectionNotifierIfc {
    private MultiplexConnectionServerIfc _server;
    private HashMap _consumerList = new HashMap(10);

    public void connected(MultiplexConnectionIfc newConnection) {
        IpcServerChannel cs = new IpcServerChannel(newConnection, this.getReceiver(), "server");
        cs.start();
    }

    public void init() throws ServerException {
        TcpConfigurationType tcp = this.getTcpConfiguration();
        try {
            this._server = this.createServer(tcp.getPort());
        }
        catch (IOException exception) {
            throw new ServerException("Failed to initialise server for the " + this.getScheme() + " connector", exception);
        }
        ((Thread)this._server).start();
    }

    public void bindConnectionFactories(Context context) throws NamingException, ServerException {
        Class<?> proxy;
        Configuration config = ConfigurationManager.getConfig();
        ServerConfiguration server = config.getServerConfiguration();
        TcpConfigurationType tcp = this.getTcpConfiguration();
        String host = this.normalizeHost(server.getHost());
        String internalHost = this.normalizeHost(tcp.getInternalHost());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("org.exolab.jms.mipc.server.host", host);
        env.put("org.exolab.jms.mipc.server.port", Integer.toString(tcp.getPort()));
        if (internalHost != null) {
            env.put("org.exolab.jms.mipc.server.internal.host", internalHost);
        }
        Connector connector = ConfigurationManager.getConnector(this.getScheme());
        ConnectorResource resource = ConnectorHelper.getConnectorResource(this.getScheme());
        String className = resource.getServer().getProxyClass();
        try {
            proxy = Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new ServerException("Failed to locate the server proxy class: " + className);
        }
        ConnectionFactoryHelper.bind(context, connector.getConnectionFactories(), proxy, env);
    }

    public synchronized void addConnection(JmsServerSession session, MultiplexConnectionIfc connection) throws IOException {
        IpcJmsSessionList list = (IpcJmsSessionList)this._consumerList.get(connection);
        if (list == null) {
            list = new IpcJmsSessionList(connection);
            this._consumerList.put(connection, list);
        }
        list.add(session);
    }

    public synchronized void removeConnection(JmsServerSession session, MultiplexConnectionIfc connection) {
        IpcJmsSessionList list = (IpcJmsSessionList)this._consumerList.get(connection);
        if (list != null && list.remove(session)) {
            this._consumerList.remove(connection);
        }
    }

    public synchronized void removeAllConnections() {
        Object[] e = this._consumerList.values().toArray();
        int i = 0;
        int j = this._consumerList.size();
        while (i < j) {
            ((IpcJmsSessionList)e[i]).removeAll();
            ++i;
        }
        this._consumerList.clear();
    }

    protected MultiplexConnectionServerIfc createServer(int port) throws IOException {
        return new MultiplexConnectionServer(port, (ConnectionNotifierIfc)this);
    }

    protected SchemeType getScheme() {
        return SchemeType.TCP;
    }

    protected TcpConfigurationType getTcpConfiguration() {
        return ConfigurationManager.getConfig().getTcpConfiguration();
    }

    protected IpcJmsReceiver getReceiver() {
        IpcJmsReceiver receiver = new IpcJmsReceiver();
        IpcJmsSessionConnection sessionHandler = new IpcJmsSessionConnection(this);
        receiver.addDispatcher(sessionHandler.getClass().getName(), sessionHandler);
        IpcJmsServerConnection serverHandler = new IpcJmsServerConnection();
        receiver.addDispatcher(serverHandler.getClass().getName(), serverHandler);
        IpcJmsAdminConnection adminHandler = new IpcJmsAdminConnection();
        receiver.addDispatcher(adminHandler.getClass().getName(), adminHandler);
        HttpJmsSessionConnection httpHandler = new HttpJmsSessionConnection(this);
        receiver.addDispatcher(httpHandler.getClass().getName(), httpHandler);
        return receiver;
    }

    private String normalizeHost(String host) {
        String server = host;
        if (host == null) {
            return host;
        }
        if (host.equals("localhost")) {
            try {
                server = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return server;
    }
}

