/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.mipc;

import java.io.Serializable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.exolab.core.ipc.NotifierIfc;
import org.exolab.jms.server.AdminConnection;
import org.exolab.jms.server.AdminConnectionManager;

public class IpcJmsAdminConnection
implements NotifierIfc {
    public Serializable notify(Object ob, String id) {
        Vector v = (Vector)ob;
        String func = (String)v.get(1);
        Vector result = null;
        String identifierId = (String)v.get(2);
        if (func.equals("createConnection")) {
            result = this.createConnection(id, (String)v.get(3), (String)v.get(4));
        } else if (func.equals("addDurableConsumer")) {
            result = this.addDurableConsumer((String)v.get(3), (String)v.get(4), (String)v.get(2));
        } else if (func.equals("removeDurableConsumer")) {
            result = this.removeDurableConsumer((String)v.get(3), (String)v.get(2));
        } else if (func.equals("durableConsumerExists")) {
            result = this.durableConsumerExists((String)v.get(3), (String)v.get(2));
        } else if (func.equals("getDurableConsumers")) {
            result = this.getDurableConsumers((String)v.get(3), (String)v.get(2));
        } else if (func.equals("unregisterConsumer")) {
            result = this.unregisterConsumer((String)v.get(3), (String)v.get(2));
        } else if (func.equals("isConnected")) {
            result = this.isConnected((String)v.get(3), (String)v.get(2));
        } else if (func.equals("getAllDestinations")) {
            result = this.getAllDestinations((String)v.get(2));
        } else if (func.equals("addDestination")) {
            result = this.addDestination((String)v.get(3), (Boolean)v.get(4), (String)v.get(2));
        } else if (func.equals("removeDestination")) {
            result = this.removeDestination((String)v.get(3), (String)v.get(2));
        } else if (func.equals("destinationExists")) {
            result = this.destinationExists((String)v.get(3), (String)v.get(2));
        } else if (func.equals("getDurableConsumerMessageCount")) {
            result = this.getDurableConsumerMessageCount((String)v.get(3), (String)v.get(4), (String)v.get(2));
        } else if (func.equals("getQueueMessageCount")) {
            result = this.getQueueMessageCount((String)v.get(3), (String)v.get(2));
        } else if (func.equals("stopServer")) {
            result = this.stopServer((String)v.get(2));
        } else if (func.equals("addUser")) {
            result = this.addUser((String)v.get(3), (String)v.get(4), (String)v.get(2));
        } else if (func.equals("changePassword")) {
            result = this.changePassword((String)v.get(3), (String)v.get(4), (String)v.get(2));
        } else if (func.equals("removeUser")) {
            result = this.removeUser((String)v.get(3), (String)v.get(2));
        } else if (func.equals("getAllUsers")) {
            result = this.getAllUsers((String)v.get(2));
        } else if (func.equals("purgeMessages")) {
            result = this.purgeMessages((String)v.get(2));
        } else {
            String st = "Unknown request received: " + func;
            System.err.println(st);
            result = this.pack(new Boolean(false), st);
        }
        return result;
    }

    public void disconnection(String id) {
    }

    private Vector createConnection(String ipcId, String username, String password) {
        Vector result;
        try {
            AdminConnection connection = AdminConnectionManager.instance().createConnection(ipcId, username, password);
            result = this.pack(Boolean.TRUE, connection.getIdentifierId());
        }
        catch (JMSException exception) {
            result = this.pack(Boolean.FALSE, (Object)exception);
        }
        return result;
    }

    private Vector addDurableConsumer(String topic, String name, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).addDurableConsumer(topic, name);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector removeDurableConsumer(String name, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).removeDurableConsumer(name);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector durableConsumerExists(String name, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).durableConsumerExists(name);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector getDurableConsumers(String topic, String identifierId) {
        try {
            Vector consumers = this.getAdminConnection(identifierId).getDurableConsumers(topic);
            return this.pack(Boolean.TRUE, consumers);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector unregisterConsumer(String name, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).unregisterConsumer(name);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector isConnected(String name, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).isConnected(name);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector addDestination(String destination, Boolean queue, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).addDestination(destination, queue);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector removeDestination(String destination, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).removeDestination(destination);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector destinationExists(String name, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).destinationExists(name);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector getAllDestinations(String identifierId) {
        try {
            Vector result = this.getAdminConnection(identifierId).getAllDestinations();
            return this.pack(Boolean.TRUE, result);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector getDurableConsumerMessageCount(String topic, String name, String identifierId) {
        try {
            int result = this.getAdminConnection(identifierId).getDurableConsumerMessageCount(topic, name);
            return this.pack(Boolean.TRUE, new Integer(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector getQueueMessageCount(String queue, String identifierId) {
        try {
            int result = this.getAdminConnection(identifierId).getQueueMessageCount(queue);
            return this.pack(Boolean.TRUE, new Integer(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector purgeMessages(String identifierId) {
        try {
            int result = this.getAdminConnection(identifierId).purgeMessages();
            return this.pack(Boolean.TRUE, new Integer(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector stopServer(String identifierId) {
        try {
            this.getAdminConnection(identifierId).stopServer();
            return this.pack(Boolean.TRUE, Boolean.TRUE);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector addUser(String username, String password, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).addUser(username, password);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector changePassword(String username, String password, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).changePassword(username, password);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector removeUser(String username, String identifierId) {
        try {
            boolean result = this.getAdminConnection(identifierId).removeUser(username);
            return this.pack(Boolean.TRUE, new Boolean(result));
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector getAllUsers(String identifierId) {
        try {
            Vector result = this.getAdminConnection(identifierId).getAllUsers();
            return this.pack(Boolean.TRUE, result);
        }
        catch (JMSException exception) {
            return this.pack(Boolean.FALSE, (Object)exception);
        }
    }

    private Vector pack(Boolean success, Object ob) {
        Vector<Object> v = new Vector<Object>(2);
        v.add(success);
        v.add(ob);
        return v;
    }

    private AdminConnection getAdminConnection(String identifierId) throws JMSSecurityException {
        AdminConnection connection = AdminConnectionManager.instance().getConnection(identifierId);
        if (connection == null) {
            throw new JMSSecurityException("Not authorized for this operation");
        }
        return connection;
    }
}

