/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageId;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.QueueDestinationCache;
import org.exolab.jms.messagemgr.TopicConsumerEndpoint;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.server.JmsServerSession;

class SentMessageCache {
    private JmsServerSession _session;
    private List _unackedMessages = Collections.synchronizedList(new LinkedList());
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$SentMessageCache == null ? (class$org$exolab$jms$server$SentMessageCache = SentMessageCache.class$("org.exolab.jms.server.SentMessageCache")) : class$org$exolab$jms$server$SentMessageCache));
    static /* synthetic */ Class class$org$exolab$jms$server$SentMessageCache;

    public SentMessageCache(JmsServerSession session) {
        this._session = session;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageHandle handle) {
        if (handle instanceof PersistentMessageHandle) {
            PersistentMessageHandle phandle = (PersistentMessageHandle)handle;
            Connection connection = null;
            connection = DatabaseService.getConnection();
            phandle.setDelivered(true);
            if (this._session.isTransacted() || this._session.getAckMode() == 2) {
                this._unackedMessages.add(handle);
                MessageHandleFactory.updatePersistentHandle(connection, phandle);
            } else {
                MessageHandleFactory.destroyPersistentHandle(connection, phandle);
            }
            connection.commit();
            Object var7_4 = null;
            if (connection == null) return;
            try {
                connection.close();
                return;
            }
            catch (Exception ignore) {}
            return;
            {
                catch (PersistenceException exception) {
                    if (connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    _log.error((Object)"Error in SentMessageCache.process", (Throwable)((Object)exception));
                    Object var7_5 = null;
                    if (connection == null) return;
                    try {
                        connection.close();
                        return;
                    }
                    catch (Exception ignore) {}
                    return;
                }
                catch (Exception exception) {
                    _log.error((Object)"Error in SentMessageCache.process", (Throwable)exception);
                    Object var7_6 = null;
                    if (connection == null) return;
                    try {
                        connection.close();
                        return;
                    }
                    catch (Exception ignore) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        handle.setDelivered();
        if (this._session.isTransacted() || this._session.getAckMode() == 2) {
            this._unackedMessages.add(handle);
            return;
        } else {
            handle.destroy();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acknowledgeMessage(MessageId msgid, long clientid) {
        boolean exists = false;
        Iterator iterator = this._unackedMessages.iterator();
        while (iterator.hasNext()) {
            MessageHandle handle = (MessageHandle)iterator.next();
            if (handle.getClientId() != clientid || !handle.getMessageId().equals(msgid)) continue;
            exists = true;
            break;
        }
        if (!exists) return;
        boolean intransaction = false;
        Connection connection = null;
        while (!this._unackedMessages.isEmpty()) {
            MessageHandle handle = (MessageHandle)this._unackedMessages.remove(0);
            if (handle instanceof PersistentMessageHandle) {
                if (!intransaction) {
                    connection = DatabaseService.getConnection();
                    intransaction = true;
                }
                MessageHandleFactory.destroyPersistentHandle(connection, (PersistentMessageHandle)handle);
            } else {
                handle.destroy();
            }
            if (handle.getClientId() != clientid || !handle.getMessageId().equals(msgid)) continue;
            if (!intransaction) break;
            connection.commit();
            intransaction = false;
            break;
        }
        Object var11_10 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception ignore) {}
        return;
        {
            catch (PersistenceException exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                _log.error((Object)"Error in SentMessageCache.acknowledgeMessage", (Throwable)((Object)exception));
                Object var11_11 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception ignore) {}
                return;
            }
            catch (Exception exception) {
                _log.error((Object)"Error in SentMessageCache.acknowledgeMessage", (Throwable)exception);
                Object var11_12 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acknowledgeAllMessages() {
        Connection connection;
        block16: {
            boolean intransaction = false;
            connection = null;
            while (!this._unackedMessages.isEmpty()) {
                MessageHandle handle = (MessageHandle)this._unackedMessages.remove(0);
                if (handle instanceof PersistentMessageHandle) {
                    if (!intransaction) {
                        connection = DatabaseService.getConnection();
                        intransaction = true;
                    }
                    MessageHandleFactory.destroyPersistentHandle(connection, (PersistentMessageHandle)handle);
                    continue;
                }
                handle.destroy();
            }
            if (!intransaction) break block16;
            connection.commit();
            intransaction = false;
        }
        Object var6_5 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception ignore) {}
        return;
        {
            catch (PersistenceException exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                _log.error((Object)"Error in SentMessageCache.acknowledgeMessage", (Throwable)((Object)exception));
                Object var6_6 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception ignore) {}
                return;
            }
            catch (Exception exception) {
                _log.error((Object)"Error in SentMessageCache.acknowledgeMessage", (Throwable)exception);
                Object var6_7 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void clear() {
        Object[] unacked = this._unackedMessages.toArray();
        this._unackedMessages.clear();
        int count = unacked.length;
        int index = 0;
        while (index < count) {
            MessageHandle handle = (MessageHandle)unacked[index];
            JmsDestination dest = handle.getDestination();
            if (dest instanceof JmsTopic) {
                ConsumerManager conmgr = ConsumerManager.instance();
                long clientId = handle.getClientId();
                TopicConsumerEndpoint endpoint = (TopicConsumerEndpoint)this._session.getConsumerEndpoint(clientId);
                if (endpoint != null) {
                    endpoint.returnMessage(handle);
                }
            } else if (dest instanceof JmsQueue) {
                DestinationManager destmgr = DestinationManager.instance();
                QueueDestinationCache cache = (QueueDestinationCache)destmgr.getDestinationCache(dest);
                if (cache == null) {
                    cache = (QueueDestinationCache)destmgr.createDestinationCache(dest);
                    if (cache != null) {
                        cache.returnMessage(handle);
                    } else {
                        _log.error((Object)("Failed to return message " + handle + " to destination cache " + dest));
                    }
                } else {
                    cache.returnMessage(handle);
                }
            }
            ++index;
        }
    }

    public boolean handleInCache(MessageHandle handle) {
        return this._unackedMessages.contains(handle);
    }

    public void removeHandle(MessageHandle handle) {
        this._unackedMessages.remove(handle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

