/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageId;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.InternalMessageListener;
import org.exolab.jms.messagemgr.MessageMgr;
import org.exolab.jms.messagemgr.QueueBrowserEndpoint;
import org.exolab.jms.messagemgr.ResourceManager;
import org.exolab.jms.messagemgr.ResourceManagerException;
import org.exolab.jms.server.ClientDisconnectionException;
import org.exolab.jms.server.JmsServerConnection;
import org.exolab.jms.server.SentMessageCache;

public class JmsServerSession
implements InternalMessageListener,
XAResource {
    private String _clientId = null;
    private String _sessionId = null;
    private JmsServerConnection _connection = null;
    private HashMap _consumers = new HashMap();
    private JmsMessageListener _listener = null;
    private int _ackMode = 1;
    private boolean _transacted = false;
    private Xid _xid = null;
    private boolean _stopped = true;
    private boolean _closed = false;
    private long _publishCount;
    private long _consumeCount;
    private SentMessageCache _sentMessageCache;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$JmsServerSession == null ? (class$org$exolab$jms$server$JmsServerSession = JmsServerSession.class$("org.exolab.jms.server.JmsServerSession")) : class$org$exolab$jms$server$JmsServerSession));
    static /* synthetic */ Class class$org$exolab$jms$server$JmsServerSession;

    JmsServerSession(JmsServerConnection connection, String id, int ackmode, boolean transacted) {
        this._connection = connection;
        this._clientId = id;
        this._ackMode = ackmode;
        this._transacted = transacted;
        this._stopped = true;
        this._sentMessageCache = new SentMessageCache(this);
    }

    void setSessionId(String id) {
        this._sessionId = id;
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public void start() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("start() [sessionId=" + this._sessionId + "]"));
        }
        if (this._stopped) {
            this.pause(false);
            this._stopped = false;
        }
    }

    public void stop() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("stop() [sessionId=" + this._sessionId + "]"));
        }
        if (!this._stopped) {
            this.pause(true);
            this._stopped = true;
        }
    }

    public void close() throws JMSException {
        boolean closed = false;
        JmsServerSession jmsServerSession = this;
        synchronized (jmsServerSession) {
            closed = this._closed;
            if (!closed) {
                this._closed = true;
            }
        }
        if (!closed) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("close() [sessionId=" + this._sessionId + "]"));
            }
            this.setMessageListener(null);
            Iterator consumers = this._consumers.values().iterator();
            while (consumers.hasNext()) {
                ConsumerEndpoint consumer = (ConsumerEndpoint)consumers.next();
                ConsumerManager.instance().deleteConsumerEndpoint(consumer);
            }
            this._sentMessageCache.clear();
            this._consumers.clear();
            this._connection.deleteSession(this);
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("close() [sessionId=" + this._sessionId + "]: session already closed"));
        }
    }

    public void acknowledgeMessage(long clientId, String id) throws JMSException {
        this._sentMessageCache.acknowledgeMessage(new MessageId(id), clientId);
    }

    public void sendMessage(Message message) throws JMSException {
        if (message == null) {
            throw new JMSException("Message is null");
        }
        try {
            this.checkDeliveryMode((MessageImpl)message);
            ((MessageImpl)message).setConnectionId(this._connection.hashCode());
            if (this._xid != null) {
                ResourceManager.instance().logPublishedMessage(this._xid, (MessageImpl)message);
            } else {
                MessageMgr.instance().add((MessageImpl)message);
                ++this._publishCount;
            }
        }
        catch (JMSException exception) {
            _log.error((Object)"Failed to process message", (Throwable)exception);
            throw exception;
        }
        catch (OutOfMemoryError exception) {
            String msg = "Failed to process message due to out-of-memory error";
            _log.error((Object)msg, (Throwable)exception);
            throw new JMSException(msg);
        }
        catch (Exception exception) {
            String msg = "Failed to process message";
            _log.error((Object)msg, (Throwable)exception);
            throw new JMSException(msg);
        }
    }

    public void sendMessages(Vector messages) throws JMSException {
        if (messages == null) {
            throw new JMSException("No messages to send");
        }
        MessageImpl message = null;
        while (messages.size() > 0 && (message = (MessageImpl)messages.remove(0)) != null) {
            try {
                this.checkDeliveryMode(message);
                message.setConnectionId(this._connection.hashCode());
                if (this._xid != null) {
                    ResourceManager.instance().logPublishedMessage(this._xid, message);
                    continue;
                }
                MessageMgr.instance().add(message);
                ++this._publishCount;
            }
            catch (JMSException exception) {
                _log.error((Object)"Failed to process message", (Throwable)exception);
                throw exception;
            }
            catch (OutOfMemoryError exception) {
                String msg = "Failed to process message due to out-of-memory error";
                _log.error((Object)msg, (Throwable)exception);
                throw new JMSException(msg);
            }
            catch (Exception exception) {
                String msg = "Failed to process messages";
                _log.error((Object)msg, (Throwable)exception);
                throw new JMSException(msg);
            }
        }
    }

    public Message receiveMessage(long clientId, long wait) throws JMSException {
        MessageImpl orig;
        MessageImpl message = null;
        ConsumerEndpoint consumer = this.getConsumerEndpoint(clientId);
        if (consumer == null) {
            throw new JMSException("Can't receive message: no consumer registered with identifier " + clientId + " on session " + this._sessionId);
        }
        MessageHandle handle = consumer.receiveMessage(wait);
        if (handle != null && (orig = handle.getMessage()) != null) {
            try {
                message = (MessageImpl)orig.clone();
                message.setJMSRedelivered(handle.getDelivered());
                message.setClientId(handle.getClientId());
                ++this._consumeCount;
            }
            catch (Exception exception) {
                _log.error((Object)exception);
                message = null;
            }
        }
        if (handle != null) {
            this._sentMessageCache.process(handle);
            if (this._xid != null) {
                try {
                    ResourceManager.instance().logReceivedMessage(this._xid, consumer.getId(), handle);
                }
                catch (Exception exception) {
                    _log.error((Object)exception);
                    JMSException jms_exception = new JMSException("Error in receiveMessage");
                    jms_exception.setLinkedException(exception);
                    throw jms_exception;
                }
            }
        }
        return message;
    }

    public Vector receiveMessages(long clientId, int count) throws JMSException {
        ConsumerEndpoint consumer = this.getConsumerEndpoint(clientId);
        if (consumer == null) {
            throw new JMSException("Can't receive messages: no consumer registered with identifier " + clientId + " on session " + this._sessionId);
        }
        if (!(consumer instanceof QueueBrowserEndpoint)) {
            throw new JMSException("Can't receive messages: consumer with identifier identifier " + clientId + " is not a QueueBrowser");
        }
        Vector handles = ((QueueBrowserEndpoint)consumer).receiveMessages(count);
        Vector<MessageImpl> messages = new Vector<MessageImpl>();
        if (handles.size() > 0) {
            int max = handles.size();
            int index = 0;
            while (index < max) {
                MessageHandle handle = (MessageHandle)handles.elementAt(index);
                MessageImpl orig = handle.getMessage();
                MessageImpl message = null;
                if (orig != null) {
                    try {
                        message = (MessageImpl)orig.clone();
                        message.setJMSRedelivered(handle.getDelivered());
                        message.setClientId(handle.getClientId());
                        messages.addElement(message);
                    }
                    catch (Exception exception) {
                        _log.error((Object)exception);
                        message = null;
                    }
                }
                ++index;
            }
        }
        return messages;
    }

    public void createQueue(JmsQueue queue) throws JMSException {
        if (!DestinationManager.instance().createAdministeredDestination(queue)) {
            throw new JMSException("Failed to create queue: " + queue.getName());
        }
    }

    public void createTopic(JmsTopic topic) throws JMSException {
        if (!DestinationManager.instance().createAdministeredDestination(topic)) {
            throw new JMSException("Failed to create topic: " + topic.getName());
        }
    }

    public void createReceiver(JmsQueue queue, long clientId, String selector) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createReceiver(queue=" + queue + ", clientId=" + clientId + ", selector=" + selector + ") [sessionId=" + this._sessionId + "]"));
        }
        if (queue == null) {
            throw new JMSException("Cannot create receiver for null queue");
        }
        ConsumerEndpoint consumer = ConsumerManager.instance().createConsumerEndpoint(this, clientId, queue, selector);
        consumer.setAckMode(this._ackMode);
        consumer.setConnectionId(this._connection.hashCode());
        consumer.setTransacted(this._transacted);
        consumer.setStopped(this._stopped);
        this._consumers.put(Long.toString(clientId), consumer);
    }

    public void createSender(JmsQueue queue) throws JMSException {
    }

    public void createBrowser(JmsQueue queue, long clientId, String selector) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createBrowser(queue=" + queue + ", clientId=" + clientId + ", selector=" + selector + ") [sessionId=" + this._sessionId + "]"));
        }
        if (queue == null) {
            throw new JMSException("Cannot create browser for null queue");
        }
        ConsumerEndpoint consumer = ConsumerManager.instance().createQueueBrowserEndpoint(this, clientId, queue, selector);
        consumer.setStopped(this._stopped);
        this._consumers.put(Long.toString(clientId), consumer);
    }

    public void deleteReceiver(long clientId) throws JMSException {
        ConsumerEndpoint consumer;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("deleteReceiver(clientId=" + clientId + ") [sessionId=" + this._sessionId + "]"));
        }
        if ((consumer = (ConsumerEndpoint)this._consumers.remove(Long.toString(clientId))) == null) {
            throw new JMSException("No receiver with id " + clientId);
        }
        ConsumerManager.instance().deleteConsumerEndpoint(consumer);
    }

    public void deleteSender(long clientId) throws JMSException {
    }

    public void deleteBrowser(long clientId) throws JMSException {
        ConsumerEndpoint consumer = (ConsumerEndpoint)this._consumers.remove(Long.toString(clientId));
        if (consumer == null) {
            throw new JMSException("No browser with id " + clientId);
        }
        ConsumerManager.instance().deleteConsumerEndpoint(consumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createSubscriber(JmsTopic topic, String name, long clientId, String selector, boolean noLocal) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createSubscriber(topic=" + topic + ", name=" + name + ", clientId=" + clientId + ", selector=" + selector + ", noLocal=" + noLocal + ") [sessionId=" + this._sessionId + "]"));
        }
        if (topic == null) {
            throw new JMSException("Cannot create subscriber for null topic");
        }
        ConsumerEndpoint consumer = null;
        if (name != null) {
            if (name.length() <= 0) throw new JMSException("Name in createSubscriber was null");
            ConsumerManager manager = ConsumerManager.instance();
            if (manager.durableConsumerExists(name)) {
                if (!manager.validSubscription(topic.getName(), name)) {
                    this.unsubscribe(name);
                    manager.createDurableConsumer(topic, name);
                }
            } else {
                manager.createDurableConsumer(topic, name);
            }
            consumer = manager.createDurableConsumerEndpoint(this, topic, name, clientId, selector);
            consumer.setConnectionId(this._connection.hashCode());
            consumer.setTransacted(this._transacted);
            consumer.setAckMode(this._ackMode);
            consumer.setNoLocal(noLocal);
        } else {
            consumer = ConsumerManager.instance().createConsumerEndpoint(this, clientId, topic, selector);
            consumer.setConnectionId(this._connection.hashCode());
            consumer.setTransacted(this._transacted);
            consumer.setAckMode(this._ackMode);
            consumer.setNoLocal(noLocal);
        }
        consumer.setStopped(this._stopped);
        this._consumers.put(Long.toString(clientId), consumer);
    }

    public void createPublisher(JmsTopic topic) throws JMSException {
    }

    public void deleteSubscriber(long clientId) throws JMSException {
        ConsumerEndpoint consumer;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("deleteSubscriber(clientId=" + clientId + ") [sessionId=" + this._sessionId + "]"));
        }
        if ((consumer = (ConsumerEndpoint)this._consumers.remove(Long.toString(clientId))) == null) {
            throw new JMSException("Failed to close consumer with id [" + this.hashCode() + ":" + clientId + "]");
        }
        ConsumerManager.instance().deleteConsumerEndpoint(consumer);
    }

    public void deletePublisher(JmsTopic topic) throws JMSException {
    }

    public void unsubscribe(String name) throws JMSException {
        ConsumerManager manager;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("unsubscribe(name=" + name + ") [sessionId=" + this._sessionId + "]"));
        }
        if (!(manager = ConsumerManager.instance()).durableConsumerExists(name)) {
            throw new InvalidDestinationException(name + " is not a durable subscriber name");
        }
        if (manager.isDurableConsumerActive(name)) {
            throw new JMSException("Failed to unsubscribe subscriber " + name + " since is still active");
        }
        manager.removeDurableConsumer(name);
    }

    public void stopMessageDelivery() throws JMSException {
        this.stop();
    }

    public void startMessageDelivery() throws JMSException {
        this.start();
    }

    public boolean containsUnackedHandle(MessageHandle handle) {
        return this._sentMessageCache.handleInCache(handle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(MessageHandle handle, boolean ignore) throws Exception {
        if (handle == null || this._listener == null) return;
        MessageImpl message = handle.getMessage();
        MessageImpl m = null;
        if (message == null) throw new JMSException("Could not get message for handle " + handle, "FailedToResolveHandle");
        m = (MessageImpl)message.clone();
        m.setClientId(handle.getClientId());
        m.setJMSRedelivered(handle.getDelivered());
        if (this._transacted || this._ackMode == 2) {
            this._sentMessageCache.process(handle);
        }
        try {
            this._listener.onMessage(m);
            if (this._transacted || this._ackMode == 2) return;
            this._sentMessageCache.process(handle);
            return;
        }
        catch (ClientDisconnectionException exception) {
            this.close();
            throw exception;
        }
    }

    public void onMessages(Vector handles) throws Exception {
        _log.error((Object)"Illegal to call onMessage");
        Thread.currentThread();
        Thread.dumpStack();
    }

    public void onMessageAvailable(long clientId) throws Exception {
        this._listener.onMessageAvailable(clientId);
    }

    public boolean isClientEndpointActive() {
        boolean active = true;
        if (this._listener != null) {
            try {
                this._listener.onMessage(null);
            }
            catch (ClientDisconnectionException exception) {
                _log.info((Object)("Failed to verify that session " + this._sessionId + " is active."));
                active = false;
            }
        }
        return active;
    }

    public void setMessageListener(JmsMessageListener listener) {
        this._listener = listener;
    }

    public void enableAsynchronousDelivery(long clientId, String id, boolean enable) throws JMSException {
        ConsumerEndpoint consumer = this.getConsumerEndpoint(clientId);
        if (consumer == null) {
            throw new JMSException(clientId + " is not registered");
        }
        if (enable) {
            consumer.setMessageListener(this);
        } else {
            consumer.setMessageListener(null);
        }
    }

    public void recover() throws JMSException {
        this.stop();
        Iterator consumers = this._consumers.values().iterator();
        while (consumers.hasNext()) {
            ((ConsumerEndpoint)consumers.next()).recover();
        }
        this._sentMessageCache.clear();
        this.start();
    }

    public void commit() throws JMSException {
        try {
            this._sentMessageCache.acknowledgeAllMessages();
        }
        catch (OutOfMemoryError exception) {
            String msg = "Failed to commit transaction due to out-of-memory error";
            _log.error((Object)msg, (Throwable)exception);
            throw new JMSException(msg);
        }
    }

    public void rollback() throws JMSException {
        this._sentMessageCache.clear();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            try {
                ResourceManager.instance().commit(xid, onePhase);
            }
            catch (ResourceManagerException exception) {
                throw new XAException("Failed in commit " + exception);
            }
            Object var5_3 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            try {
                ResourceManager.instance().end(xid, flags);
            }
            catch (ResourceManagerException exception) {
                throw new XAException("Failed in end " + exception);
            }
            Object var5_3 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            try {
                ResourceManager.instance().forget(xid);
            }
            catch (ResourceManagerException exception) {
                throw new XAException("Failed in forget " + exception);
            }
            Object var4_2 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return ResourceManager.instance().getTransactionTimeout();
        }
        catch (ResourceManagerException exception) {
            throw new XAException("Failed in getTransactionTimeout " + exception);
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return true;
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return ResourceManager.instance().prepare(xid);
        }
        catch (ResourceManagerException exception) {
            throw new XAException("Failed in prepare " + exception);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return ResourceManager.instance().recover(flag);
        }
        catch (ResourceManagerException exception) {
            throw new XAException("Failed in recover " + exception);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            try {
                ResourceManager.instance().rollback(xid);
            }
            catch (ResourceManagerException exception) {
                throw new XAException("Failed in rollback " + exception);
            }
            Object var4_2 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            return ResourceManager.instance().setTransactionTimeout(seconds);
        }
        catch (ResourceManagerException exception) {
            throw new XAException("Failed in setTransactionTimeout " + exception);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            ResourceManager.instance().start(xid, flags);
            this._xid = xid;
        }
        catch (ResourceManagerException exception) {
            throw new XAException("Failed in start " + exception);
        }
    }

    public Xid getXid() {
        return this._xid;
    }

    public String getResourceManagerId() throws XAException {
        try {
            return ResourceManager.instance().getResourceManagerId();
        }
        catch (ResourceManagerException exception) {
            throw new XAException("Failed in getResourceManagerId " + exception);
        }
    }

    public boolean isTransacted() {
        return this._transacted;
    }

    public int getAckMode() {
        return this._ackMode;
    }

    public ConsumerEndpoint getConsumerEndpoint(long clientId) {
        String identity = Long.toString(clientId);
        return (ConsumerEndpoint)this._consumers.get(identity);
    }

    private void pause(boolean stop) {
        Iterator iter = this._consumers.values().iterator();
        while (iter.hasNext()) {
            ((ConsumerEndpoint)iter.next()).setStopped(stop);
        }
    }

    private void checkDeliveryMode(MessageImpl message) throws JMSException {
        if (message.getJMSDeliveryMode() == 2 && !DestinationManager.instance().isMessageForAdministeredDestination(message)) {
            message.setJMSDeliveryMode(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

