/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.foundation.HandleIfc;
import org.exolab.jms.authentication.AuthenticationMgr;
import org.exolab.jms.events.BasicEventManager;
import org.exolab.jms.events.Event;
import org.exolab.jms.events.EventHandler;
import org.exolab.jms.events.IllegalEventDefinedException;
import org.exolab.jms.server.JmsServerConnection;

public class JmsServerConnectionManager
implements EventHandler {
    private long _gcInterval = 60000L;
    private Map _connections = Collections.synchronizedMap(new HashMap());
    private static JmsServerConnectionManager _instance = null;
    private static final Object _initializer = new Object();
    private static final int CONNECTION_GC_EVENT = 1;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$JmsServerConnectionManager == null ? (class$org$exolab$jms$server$JmsServerConnectionManager = JmsServerConnectionManager.class$("org.exolab.jms.server.JmsServerConnectionManager")) : class$org$exolab$jms$server$JmsServerConnectionManager));
    static /* synthetic */ Class class$org$exolab$jms$server$JmsServerConnectionManager;

    private JmsServerConnectionManager() {
        if (System.getProperty("org.exolab.jms.connection.gcInterval") != null) {
            try {
                this._gcInterval = Long.parseLong(System.getProperty("org.exolab.jms.connection.gcInterval"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._gcInterval > 0L) {
            this.registerEvent();
        }
    }

    public static JmsServerConnectionManager instance() {
        if (_instance == null) {
            Object object = _initializer;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new JmsServerConnectionManager();
                }
            }
        }
        return _instance;
    }

    public JmsServerConnection createConnection(String id, String username, String password) throws JMSSecurityException, JMSException {
        if (!AuthenticationMgr.instance().validateUser(username, password)) {
            throw new JMSSecurityException("Failed to authenticate user " + username);
        }
        JmsServerConnection result = (JmsServerConnection)this._connections.get(id);
        if (result == null) {
            result = new JmsServerConnection(id);
            this._connections.put(id, result);
        }
        return result;
    }

    public Iterator getConnections() {
        return this._connections.values().iterator();
    }

    public JmsServerConnection getConnection(String id) {
        return (JmsServerConnection)this._connections.get(id);
    }

    public void closeConnection(String id) {
        JmsServerConnection connection = (JmsServerConnection)this._connections.remove(id);
        if (connection != null) {
            connection.close();
        }
    }

    public void handleEvent(int event, Object callback, long time) {
        try {
            Object[] ids = this._connections.keySet().toArray();
            int index = 0;
            while (index < ids.length) {
                JmsServerConnection connection = (JmsServerConnection)this._connections.get(ids[index]);
                if (connection != null && !connection.isClientEndpointActive()) {
                    _log.info((Object)("Cleaning up connection " + ids[index]));
                    this.closeConnection((String)ids[index]);
                }
                ++index;
            }
            Object var9_7 = null;
            this.registerEvent();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.registerEvent();
            throw throwable;
        }
    }

    public HandleIfc getHandle() {
        return null;
    }

    private void registerEvent() {
        try {
            BasicEventManager.instance().registerEventRelative(new Event(1, this, null), this._gcInterval);
        }
        catch (IllegalEventDefinedException exception) {
            _log.error((Object)"JmsServerConnectionManager.registerEvent failed", (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

