/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.util.UUID;

public class JmsServerConnection {
    private static final int MAX_PING_ATTEMPTS = 3;
    private Hashtable _sessions = null;
    private String _clientId = null;
    private String _connectionId = null;
    private boolean _stopped = true;
    private int _consecutiveFailedPingAttempts = 0;

    JmsServerConnection(String id) {
        this._clientId = id;
        this._sessions = new Hashtable(20);
        this._connectionId = UUID.next();
        this._stopped = true;
    }

    public String getID() {
        return this._clientId;
    }

    public JmsServerSession createSession(int ackMode, boolean transacted) {
        JmsServerSession session = new JmsServerSession(this, this._clientId, ackMode, transacted);
        session.setSessionId(UUID.next());
        this._sessions.put(session.getSessionId(), session);
        if (!this._stopped) {
            session.start();
        }
        return session;
    }

    public void deleteSession(JmsServerSession session) {
        this._sessions.remove(session.getSessionId());
    }

    public int getSessionCount() {
        return this._sessions.size();
    }

    public Enumeration getSessions() {
        return this._sessions.elements();
    }

    public void start() {
        if (this._stopped) {
            Enumeration sessions = this._sessions.elements();
            while (sessions.hasMoreElements()) {
                JmsServerSession session = (JmsServerSession)sessions.nextElement();
                session.start();
            }
            this._stopped = false;
        }
    }

    public void stop() {
        if (!this._stopped) {
            Enumeration sessions = this._sessions.elements();
            while (sessions.hasMoreElements()) {
                JmsServerSession session = (JmsServerSession)sessions.nextElement();
                session.stop();
            }
            this._stopped = true;
        }
    }

    public void close() {
        Enumeration sessions = this._sessions.elements();
        try {
            while (sessions.hasMoreElements()) {
                JmsServerSession session = (JmsServerSession)sessions.nextElement();
                session.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this._sessions.clear();
    }

    public JmsServerSession getSession(String sessionId) {
        return (JmsServerSession)this._sessions.get(sessionId);
    }

    public String getConnectionId() {
        return this._connectionId;
    }

    boolean isClientEndpointActive() {
        JmsServerSession[] sessions;
        boolean active = true;
        Hashtable hashtable = this._sessions;
        synchronized (hashtable) {
            sessions = this._sessions.values().toArray(new JmsServerSession[0]);
        }
        int i = 0;
        while (i < sessions.length) {
            JmsServerSession session = sessions[i];
            if (session.isClientEndpointActive()) {
                active = true;
                this._consecutiveFailedPingAttempts = 0;
                break;
            }
            active = ++this._consecutiveFailedPingAttempts <= 3;
            ++i;
        }
        return active;
    }
}

