/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceManager;
import org.exolab.core.service.Serviceable;
import org.exolab.core.util.RmiRegistryService;
import org.exolab.jms.authentication.AuthenticationMgr;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.ConnectorHelper;
import org.exolab.jms.config.ConnectorResource;
import org.exolab.jms.config.LoggerConfiguration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.events.BasicEventManager;
import org.exolab.jms.gc.GarbageCollectionService;
import org.exolab.jms.jndi.JndiServerIfc;
import org.exolab.jms.lease.LeaseManager;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageMgr;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.EmbeddedNameService;
import org.exolab.jms.server.FailedToCreateServerException;
import org.exolab.jms.server.JmsServerIfc;
import org.exolab.jms.server.NamingHelper;
import org.exolab.jms.server.ServerException;
import org.exolab.jms.threads.ThreadPoolManager;
import org.exolab.jms.util.CommandLine;
import org.exolab.jms.util.Version;

public class JmsServer {
    protected ServiceManager _services = null;
    private JmsServerIfc[] _interfaces = null;
    private JndiServerIfc[] _jndiInterfaces = null;
    private Configuration _config;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$JmsServer == null ? (class$org$exolab$jms$server$JmsServer = JmsServer.class$("org.exolab.jms.server.JmsServer")) : class$org$exolab$jms$server$JmsServer));
    static /* synthetic */ Class class$org$exolab$jms$server$JmsServer;
    static /* synthetic */ Class class$org$exolab$jms$server$JmsServerIfc;
    static /* synthetic */ Class class$org$exolab$jms$jndi$JndiServerIfc;
    static /* synthetic */ Class class$javax$naming$Context;

    public JmsServer(Configuration config) throws ServerException {
        JmsServer.version();
        ConfigurationManager.setConfig(config);
        this._config = config;
    }

    public JmsServer(String file) throws ServerException {
        JmsServer.version();
        try {
            ConfigurationManager.setConfig(file);
            this._config = ConfigurationManager.getConfig();
        }
        catch (Exception exception) {
            throw new FailedToCreateServerException("Failed to read configuration: " + file, exception);
        }
    }

    public void init() throws NamingException, ServerException {
        LoggerConfiguration log = this._config.getLoggerConfiguration();
        DOMConfigurator.configure((String)log.getFile());
        this._services = ServiceManager.instance();
        if (this._config.getServerConfiguration().getEmbeddedJNDI()) {
            EmbeddedNameService.getInstance();
        }
        if (this.hasConnector(SchemeType.RMI) && this._config.getRmiConfiguration().getEmbeddedRegistry()) {
            this.createRegistry();
        }
        try {
            this.registerServices();
            this._services.startAll();
        }
        catch (ServiceException exception) {
            throw new ServerException("Failed to start services", exception);
        }
        DestinationManager.instance().registerConfiguredAdministeredDestinations();
        Context context = NamingHelper.getInitialContext(this._config);
        this.initConnectors(context);
        if (this._config.getServerConfiguration().getEmbeddedJNDI()) {
            this.initJNDIConnectors(context);
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine cmdline = new CommandLine(args);
            boolean helpSet = cmdline.exists("help");
            boolean versionSet = cmdline.exists("version");
            boolean configSet = cmdline.exists("config");
            if (helpSet) {
                JmsServer.usage();
            } else if (versionSet) {
                JmsServer.version();
            } else if (!configSet && args.length != 0) {
                JmsServer.usage();
            } else {
                String config = cmdline.value("config", JmsServer.getOpenJMSHome() + "/config/openjms.xml");
                JmsServer server = new JmsServer(config);
                server.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static void version() {
        System.err.println(Version.TITLE + " " + Version.VERSION);
        System.err.println(Version.COPYRIGHT);
        System.err.println(Version.VENDOR_URL);
    }

    protected static void usage() {
        PrintStream out = System.out;
        out.println("\n\n");
        out.println("=====================================================");
        out.println("Usage information for org.exolab.jms.server.JmsServer");
        out.println("=====================================================");
        out.println("\norg.exolab.jms.server.JmsServer");
        out.println("    [-config <xml config file> | -version | -help]\n");
        out.println("\t-config  file name of xml-based config file\n");
        out.println("\t-version displays OpenJMS version information\n");
        out.println("\t-help    displays this screen\n");
    }

    protected void registerServices() throws ServiceException {
        this._services.add(ThreadPoolManager.instance().getName(), (Serviceable)ThreadPoolManager.instance());
        this._services.add(BasicEventManager.instance().getName(), (Serviceable)BasicEventManager.instance());
        this._services.add(DatabaseService.instance().getName(), (Serviceable)DatabaseService.instance());
        this._services.add(Scheduler.createInstance().getName(), (Serviceable)Scheduler.instance());
        this._services.add(LeaseManager.instance().getName(), (Serviceable)LeaseManager.instance());
        this._services.add(GarbageCollectionService.instance().getName(), (Serviceable)GarbageCollectionService.instance());
        this._services.add(AuthenticationMgr.createInstance().getName(), (Serviceable)AuthenticationMgr.instance());
        this._services.add(MessageMgr.createInstance().getName(), (Serviceable)MessageMgr.instance());
    }

    protected void initConnectors(Context context) throws NamingException, ServerException {
        Connector[] connectors = this._config.getConnectors().getConnector();
        this._interfaces = new JmsServerIfc[connectors.length];
        int i = 0;
        while (i < connectors.length) {
            Connector connector = connectors[i];
            this._interfaces[i] = this.initConnector(connector, context);
            ++i;
        }
    }

    protected JmsServerIfc initConnector(Connector connector, Context context) throws NamingException, ServerException {
        JmsServerIfc server;
        Class<?> clazz;
        _log.info((Object)("Creating server interface for the " + connector.getScheme() + " connector"));
        ConnectorResource resource = ConnectorHelper.getConnectorResource(connector.getScheme());
        String className = resource.getServer().getImplementationClass();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new FailedToCreateServerException("Failed to load class " + className);
        }
        if (!(class$org$exolab$jms$server$JmsServerIfc == null ? (class$org$exolab$jms$server$JmsServerIfc = JmsServer.class$("org.exolab.jms.server.JmsServerIfc")) : class$org$exolab$jms$server$JmsServerIfc).isAssignableFrom(clazz)) {
            throw new FailedToCreateServerException("Class " + className + " does not implement JmsServerIfc");
        }
        try {
            server = (JmsServerIfc)clazz.newInstance();
            _log.debug((Object)("Created an instance of " + className + " as a server interface"));
        }
        catch (Exception exception) {
            throw new FailedToCreateServerException(exception.getMessage(), exception);
        }
        server.init();
        server.bindConnectionFactories(context);
        return server;
    }

    protected void createRegistry() throws ServerException {
        int port = this._config.getRmiConfiguration().getRegistryPort();
        try {
            RmiRegistryService service = new RmiRegistryService(port);
            this._services.add(service.getName(), (Serviceable)service);
        }
        catch (Exception exception) {
            throw new FailedToCreateServerException("Failed to start the RMI registry", exception);
        }
        _log.info((Object)("Embedded RMI registry running on port " + port));
    }

    protected void initJNDIConnectors(Context context) throws NamingException, ServerException {
        Connector[] connectors = this._config.getConnectors().getConnector();
        ArrayList<JndiServerIfc> interfaces = new ArrayList<JndiServerIfc>();
        int i = 0;
        while (i < connectors.length) {
            Connector connector = connectors[i];
            ConnectorResource resource = ConnectorHelper.getConnectorResource(connector.getScheme());
            if (resource.getJndi().getImplementationClass() != null) {
                JndiServerIfc provider = this.initJNDIConnector(resource, context);
                interfaces.add(provider);
            }
            ++i;
        }
        this._jndiInterfaces = interfaces.toArray(new JndiServerIfc[0]);
    }

    protected JndiServerIfc initJNDIConnector(ConnectorResource connector, Context context) throws NamingException, ServerException {
        JndiServerIfc result;
        Class<?> clazz;
        _log.info((Object)("Creating JNDI interface for the " + connector.getScheme() + " connector"));
        String className = connector.getJndi().getImplementationClass();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new FailedToCreateServerException("Failed to load class " + className);
        }
        if (!(class$org$exolab$jms$jndi$JndiServerIfc == null ? (class$org$exolab$jms$jndi$JndiServerIfc = JmsServer.class$("org.exolab.jms.jndi.JndiServerIfc")) : class$org$exolab$jms$jndi$JndiServerIfc).isAssignableFrom(clazz)) {
            throw new FailedToCreateServerException("Class " + className + " does not implement JndiServerIfc");
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(class$javax$naming$Context == null ? (class$javax$naming$Context = JmsServer.class$("javax.naming.Context")) : class$javax$naming$Context);
            result = (JndiServerIfc)constructor.newInstance(context);
            result.init();
            _log.debug((Object)("Created an instance of " + className + " as a JNDI provider interface"));
        }
        catch (Exception exception) {
            throw new FailedToCreateServerException(exception.getMessage(), exception);
        }
        return result;
    }

    private boolean hasConnector(SchemeType scheme) {
        boolean result = false;
        Connector[] connectors = this._config.getConnectors().getConnector();
        int i = 0;
        while (i < connectors.length) {
            if (connectors[i].getScheme().equals(scheme)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private static String getOpenJMSHome() {
        return System.getProperty("openjms.home", System.getProperty("user.dir"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

