/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsConnectionFactory;
import org.exolab.jms.client.JmsQueueConnectionFactory;
import org.exolab.jms.client.JmsTopicConnectionFactory;
import org.exolab.jms.client.JmsXAQueueConnectionFactory;
import org.exolab.jms.client.JmsXATopicConnectionFactory;
import org.exolab.jms.config.ConnectionFactories;
import org.exolab.jms.config.ConnectionFactory;
import org.exolab.jms.config.QueueConnectionFactory;
import org.exolab.jms.config.TopicConnectionFactory;
import org.exolab.jms.config.XAQueueConnectionFactory;
import org.exolab.jms.config.XATopicConnectionFactory;

public class ConnectionFactoryHelper {
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$ConnectionFactoryHelper == null ? (class$org$exolab$jms$server$ConnectionFactoryHelper = ConnectionFactoryHelper.class$("org.exolab.jms.server.ConnectionFactoryHelper")) : class$org$exolab$jms$server$ConnectionFactoryHelper));
    static /* synthetic */ Class class$org$exolab$jms$server$ConnectionFactoryHelper;
    static /* synthetic */ Class class$org$exolab$jms$client$JmsServerStubIfc;

    public static void bind(Context context, ConnectionFactories factories, Class implementation, Hashtable environment) throws NamingException {
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null");
        }
        if (factories == null) {
            throw new IllegalArgumentException("Argument factories is null");
        }
        if (implementation == null) {
            throw new IllegalArgumentException("Argument implementation is null");
        }
        if (!(class$org$exolab$jms$client$JmsServerStubIfc == null ? (class$org$exolab$jms$client$JmsServerStubIfc = ConnectionFactoryHelper.class$("org.exolab.jms.client.JmsServerStubIfc")) : class$org$exolab$jms$client$JmsServerStubIfc).isAssignableFrom(implementation)) {
            throw new IllegalArgumentException("Class " + implementation.getName() + " does not implement " + (class$org$exolab$jms$client$JmsServerStubIfc == null ? (class$org$exolab$jms$client$JmsServerStubIfc = ConnectionFactoryHelper.class$("org.exolab.jms.client.JmsServerStubIfc")) : class$org$exolab$jms$client$JmsServerStubIfc).getName());
        }
        if (environment == null) {
            throw new IllegalArgumentException("Argument environment is null");
        }
        QueueConnectionFactory[] queue = factories.getQueueConnectionFactory();
        TopicConnectionFactory[] topic = factories.getTopicConnectionFactory();
        XAQueueConnectionFactory[] xaqueue = factories.getXAQueueConnectionFactory();
        XATopicConnectionFactory[] xatopic = factories.getXATopicConnectionFactory();
        int i = 0;
        while (i < queue.length) {
            ConnectionFactoryHelper.bind(context, queue[i], implementation, environment);
            ++i;
        }
        int i2 = 0;
        while (i2 < topic.length) {
            ConnectionFactoryHelper.bind(context, topic[i2], implementation, environment);
            ++i2;
        }
        int i3 = 0;
        while (i3 < xaqueue.length) {
            ConnectionFactoryHelper.bind(context, xaqueue[i3], implementation, environment);
            ++i3;
        }
        int i4 = 0;
        while (i4 < xatopic.length) {
            ConnectionFactoryHelper.bind(context, xatopic[i4], implementation, environment);
            ++i4;
        }
    }

    private static void bind(Context context, ConnectionFactory factory, Class implementation, Hashtable environment) throws NamingException {
        JmsConnectionFactory instance = null;
        if (factory instanceof QueueConnectionFactory) {
            instance = new JmsQueueConnectionFactory(implementation.getName(), environment);
        } else if (factory instanceof TopicConnectionFactory) {
            instance = new JmsTopicConnectionFactory(implementation.getName(), environment);
        } else if (factory instanceof XAQueueConnectionFactory) {
            instance = new JmsXAQueueConnectionFactory(implementation.getName(), environment);
        } else if (factory instanceof XATopicConnectionFactory) {
            instance = new JmsXATopicConnectionFactory(implementation.getName(), environment);
        } else {
            throw new IllegalArgumentException("Unknown connection factory type: " + factory.getClass().getName());
        }
        context.rebind(factory.getName(), (Object)instance);
        _log.debug((Object)("Bound connection factory " + factory.getName()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

