/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.foundation.HandleIfc;
import org.exolab.jms.authentication.AuthenticationMgr;
import org.exolab.jms.events.BasicEventManager;
import org.exolab.jms.events.Event;
import org.exolab.jms.events.EventHandler;
import org.exolab.jms.events.IllegalEventDefinedException;
import org.exolab.jms.server.AdminConnection;

public class AdminConnectionManager
implements EventHandler {
    private long _gcInterval = 60000L;
    private Map _connections = Collections.synchronizedMap(new HashMap());
    private static AdminConnectionManager _instance = null;
    private static final Object _initializer = new Object();
    private static final int CONNECTION_GC_EVENT = 1;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$AdminConnectionManager == null ? (class$org$exolab$jms$server$AdminConnectionManager = AdminConnectionManager.class$("org.exolab.jms.server.AdminConnectionManager")) : class$org$exolab$jms$server$AdminConnectionManager));
    static /* synthetic */ Class class$org$exolab$jms$server$AdminConnectionManager;

    private AdminConnectionManager() {
        if (System.getProperty("org.exolab.jms.connection.gcInterval") != null) {
            try {
                this._gcInterval = Long.parseLong(System.getProperty("org.exolab.jms.connection.gcInterval"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._gcInterval > 0L) {
            this.registerEvent();
        }
    }

    public static AdminConnectionManager instance() {
        if (_instance == null) {
            Object object = _initializer;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new AdminConnectionManager();
                }
            }
        }
        return _instance;
    }

    public AdminConnection createConnection(String id, String username, String password) throws JMSSecurityException, JMSException {
        if (!AuthenticationMgr.instance().validateUser(username, password)) {
            throw new JMSSecurityException("Failed to authenticate user " + username);
        }
        AdminConnection result = new AdminConnection(id);
        this._connections.put(result.getIdentifierId(), result);
        return result;
    }

    public Iterator getConnections() {
        return this._connections.values().iterator();
    }

    public AdminConnection getConnection(String id) {
        return (AdminConnection)this._connections.get(id);
    }

    public void closeConnection(String identifierId) {
        AdminConnection connection = (AdminConnection)this._connections.remove(identifierId);
        if (connection != null) {
            connection.close();
        }
    }

    public void handleEvent(int event, Object callback, long time) {
        try {
            Object[] ids = this._connections.keySet().toArray();
            int index = 0;
            while (index < ids.length) {
                AdminConnection connection = (AdminConnection)this._connections.get(ids[index]);
                if (connection != null && !connection.isClientActive()) {
                    _log.info((Object)("Cleaning up connection " + ids[index]));
                    this.closeConnection((String)ids[index]);
                }
                ++index;
            }
            Object var9_7 = null;
            this.registerEvent();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.registerEvent();
            throw throwable;
        }
    }

    public HandleIfc getHandle() {
        return null;
    }

    private void registerEvent() {
        try {
            BasicEventManager.instance().registerEventRelative(new Event(1, this, null), this._gcInterval);
        }
        catch (IllegalEventDefinedException exception) {
            _log.error((Object)"AdminConnectionManager.registerEvent failed", (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

