/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.ServiceManager;
import org.exolab.jms.authentication.AuthenticationMgr;
import org.exolab.jms.authentication.User;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.util.UUID;

public class AdminConnection {
    private String _clientId = null;
    private String _identifierId = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$AdminConnection == null ? (class$org$exolab$jms$server$AdminConnection = AdminConnection.class$("org.exolab.jms.server.AdminConnection")) : class$org$exolab$jms$server$AdminConnection));
    static /* synthetic */ Class class$org$exolab$jms$server$AdminConnection;

    AdminConnection(String id) {
        this._clientId = id;
        this._identifierId = UUID.next();
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getIdentifierId() {
        return this._identifierId;
    }

    public void close() {
    }

    boolean isClientActive() {
        boolean active = true;
        return active;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDurableConsumerMessageCount(String topic, String name) {
        int count = -1;
        Connection connection = null;
        try {
            block5: {
                try {
                    DestinationManager dmgr = DestinationManager.instance();
                    ConsumerManager cmgr = ConsumerManager.instance();
                    JmsDestination dest = dmgr.destinationFromString(topic);
                    ConsumerEndpoint endpoint = null;
                    if (dest == null || name == null && name.length() <= 0) break block5;
                    endpoint = cmgr.getConsumerEndpoint(name);
                    if (endpoint != null && endpoint.getDestination().equals(dest)) {
                        count = endpoint.getMessageCount();
                        break block5;
                    }
                    if (!dmgr.isAdministeredDestination(topic)) break block5;
                    connection = DatabaseService.getConnection();
                    count = DatabaseService.getAdapter().getDurableConsumerMessageCount(connection, topic, name);
                    connection.commit();
                }
                catch (Exception exception) {
                    _log.error((Object)("Failed to get message count for topic=" + topic), (Throwable)exception);
                    SQLHelper.rollback(connection);
                    Object var10_11 = null;
                    SQLHelper.close(connection);
                    return count;
                }
            }
            Object var10_10 = null;
            SQLHelper.close(connection);
            return count;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getQueueMessageCount(String queue) {
        int count = -1;
        Connection connection = null;
        try {
            block5: {
                try {
                    DestinationManager mgr = DestinationManager.instance();
                    JmsDestination dest = mgr.destinationFromString(queue);
                    DestinationCache cache = null;
                    if (dest == null) break block5;
                    cache = mgr.getDestinationCache(dest);
                    if (cache != null) {
                        count = cache.getMessageCount();
                        break block5;
                    }
                    if (!mgr.isAdministeredDestination(queue)) break block5;
                    connection = DatabaseService.getConnection();
                    count = DatabaseService.getAdapter().getQueueMessageCount(connection, queue);
                    connection.commit();
                }
                catch (Exception exception) {
                    _log.error((Object)("Failed to get message count for queue=" + queue), (Throwable)exception);
                    SQLHelper.rollback(connection);
                    Object var8_9 = null;
                    SQLHelper.close(connection);
                    return count;
                }
            }
            Object var8_8 = null;
            SQLHelper.close(connection);
            return count;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
    }

    public boolean addDurableConsumer(String topic, String name) {
        boolean result = false;
        try {
            ConsumerManager.instance().createDurableConsumer(new JmsTopic(topic), name);
            result = true;
        }
        catch (JMSException exception) {
            _log.error((Object)("Failed to add durable consumer=" + name + " for topic=" + topic), (Throwable)exception);
        }
        return result;
    }

    public boolean removeDurableConsumer(String name) {
        boolean result = false;
        try {
            ConsumerManager.instance().removeDurableConsumer(name);
            result = true;
        }
        catch (JMSException exception) {
            _log.error((Object)("Failed to remove durable consumer=" + name), (Throwable)exception);
        }
        return result;
    }

    public boolean durableConsumerExists(String name) {
        return ConsumerManager.instance().durableConsumerExists(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getDurableConsumers(String topic) {
        Enumeration iter = null;
        Vector result = new Vector();
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                iter = DatabaseService.getAdapter().getDurableConsumers(connection, topic);
                while (true) {
                    if (!iter.hasMoreElements()) {
                        connection.commit();
                        break;
                    }
                    result.addElement(iter.nextElement());
                }
            }
            catch (Exception exception) {
                _log.error((Object)("Failed on get durable consumers for topic=" + topic), (Throwable)exception);
                SQLHelper.rollback(connection);
                Object var7_6 = null;
                SQLHelper.close(connection);
                return result;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return result;
    }

    public boolean unregisterConsumer(String name) {
        boolean success = false;
        try {
            ConsumerManager.instance().deleteDurableConsumerEndpoint(name);
            success = true;
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return success;
    }

    public boolean isConnected(String name) {
        return ConsumerManager.instance().isDurableConsumerActive(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllDestinations() {
        Enumeration iter = null;
        Vector result = new Vector();
        Connection connection = null;
        Object tm = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                iter = DatabaseService.getAdapter().getAllDestinations(connection);
                while (true) {
                    if (!iter.hasMoreElements()) {
                        connection.commit();
                        break;
                    }
                    result.addElement(iter.nextElement());
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to get all destinations", (Throwable)exception);
                SQLHelper.rollback(connection);
                Object var7_6 = null;
                SQLHelper.close(connection);
                return result;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return result;
    }

    public boolean addDestination(String name, Boolean queue) {
        boolean success = false;
        JmsDestination destination = queue != false ? new JmsQueue(name) : new JmsTopic(name);
        destination.setPersistent(true);
        try {
            success = DestinationManager.instance().createAdministeredDestination(destination);
        }
        catch (JMSException exception) {
            _log.error((Object)("Failed to add destination=" + name), (Throwable)exception);
        }
        return success;
    }

    public boolean removeDestination(String name) {
        boolean success = false;
        JmsDestination dest = DestinationManager.instance().destinationFromString(name);
        if (dest != null) {
            try {
                DestinationManager.instance().deleteAdministeredDestination(dest);
                success = true;
            }
            catch (JMSException exception) {
                _log.error((Object)("Failed to remove destination=" + name), (Throwable)exception);
            }
        }
        return success;
    }

    public boolean destinationExists(String name) {
        boolean exists = false;
        DestinationManager mgr = DestinationManager.instance();
        JmsDestination dest = mgr.destinationFromString(name);
        if (dest != null) {
            exists = mgr.destinationExists(dest);
        }
        return exists;
    }

    public void stopServer() {
        _log.info((Object)"Stopping all services");
        ServiceManager.instance().removeAll();
        _log.info((Object)"Server Shutdown scheduled for 5 secs");
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public int purgeMessages() {
        return 0;
    }

    public boolean addUser(String username, String password) {
        return AuthenticationMgr.instance().addUser(new User(username, password));
    }

    public boolean changePassword(String username, String password) {
        return AuthenticationMgr.instance().updateUser(new User(username, password));
    }

    public boolean removeUser(String username) {
        return AuthenticationMgr.instance().removeUser(new User(username, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllUsers() {
        Enumeration iter = null;
        Vector result = new Vector();
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                iter = DatabaseService.getAdapter().getAllUsers(connection);
                while (true) {
                    if (!iter.hasMoreElements()) {
                        connection.commit();
                        break;
                    }
                    result.addElement(iter.nextElement());
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Failed on get all users", (Throwable)exception);
                SQLHelper.rollback(connection);
                Object var6_5 = null;
                SQLHelper.close(connection);
                return result;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

