/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import java.io.StringReader;
import javax.jms.InvalidSelectorException;
import javax.jms.Message;
import org.exolab.jms.selector.DefaultExpressionFactory;
import org.exolab.jms.selector.Expression;
import org.exolab.jms.selector.Literal;
import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.TypeMismatchException;
import org.exolab.jms.selector.parser.SelectorLexer;
import org.exolab.jms.selector.parser.SelectorParser;
import org.exolab.jms.selector.parser.SelectorTreeParser;

public class Selector {
    private final Expression _evaluator;

    public Selector(String expression) throws InvalidSelectorException {
        try {
            if (expression == null || expression.length() == 0) {
                this._evaluator = Literal.booleanLiteral(true);
            } else {
                SelectorLexer lexer = new SelectorLexer(new StringReader(expression));
                lexer.initialise();
                SelectorParser parser = new SelectorParser(lexer);
                parser.initialise();
                parser.selector();
                SelectorTreeParser builder = new SelectorTreeParser();
                builder.initialise(new DefaultExpressionFactory());
                this._evaluator = builder.selector(parser.getAST());
            }
        }
        catch (Exception exception) {
            throw new InvalidSelectorException(exception.toString());
        }
    }

    public boolean selects(Message message) {
        boolean result = false;
        try {
            SObject value = this._evaluator.evaluate(message);
            if (value instanceof SBool) {
                result = ((SBool)value).value();
            }
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        return result;
    }
}

