/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SDouble;
import org.exolab.jms.selector.SNumber;
import org.exolab.jms.selector.SObject;

final class SLong
extends SNumber {
    private long _value;

    public SLong(long value) {
        this._value = value;
    }

    public SNumber add(SNumber number) {
        SNumber result = number instanceof SDouble ? this.promote().add(number) : new SLong(this._value + number.getLong());
        return result;
    }

    public SNumber subtract(SNumber number) {
        SNumber result = number instanceof SDouble ? this.promote().subtract(number) : new SLong(this._value - number.getLong());
        return result;
    }

    public SNumber multiply(SNumber number) {
        SNumber result = number instanceof SDouble ? this.promote().multiply(number) : new SLong(this._value * number.getLong());
        return result;
    }

    public SNumber divide(SNumber number) {
        SNumber result = null;
        try {
            result = number instanceof SDouble ? this.promote().divide(number) : new SLong(this._value / number.getLong());
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return result;
    }

    public long getLong() {
        return this._value;
    }

    public double getDouble() {
        return this._value;
    }

    public Object getObject() {
        return new Long(this._value);
    }

    public SBool equal(SObject obj) {
        SBool result = null;
        if (obj instanceof SLong) {
            long rhs = ((SNumber)obj).getLong();
            result = this._value == rhs ? SBool.TRUE : SBool.FALSE;
        } else if (obj instanceof SDouble) {
            result = this.promote().equal(obj);
        }
        return result;
    }

    public SBool less(SObject obj) {
        SBool result = null;
        if (obj instanceof SLong) {
            long rhs = ((SNumber)obj).getLong();
            result = this._value < rhs ? SBool.TRUE : SBool.FALSE;
        } else if (obj instanceof SDouble) {
            result = this.promote().less(obj);
        }
        return result;
    }

    public SBool greater(SObject obj) {
        SBool result = null;
        if (obj instanceof SLong) {
            long rhs = ((SNumber)obj).getLong();
            result = this._value > rhs ? SBool.TRUE : SBool.FALSE;
        } else if (obj instanceof SDouble) {
            result = this.promote().greater(obj);
        }
        return result;
    }

    private SDouble promote() {
        return new SDouble(this._value);
    }
}

