/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SNumber;
import org.exolab.jms.selector.SObject;

final class SDouble
extends SNumber {
    private final double _value;

    public SDouble() {
        this._value = 0.0;
    }

    public SDouble(double value) {
        this._value = value;
    }

    public SNumber add(SNumber number) {
        return new SDouble(this._value + number.getDouble());
    }

    public SNumber subtract(SNumber number) {
        return new SDouble(this._value - number.getDouble());
    }

    public SNumber multiply(SNumber number) {
        return new SDouble(this._value * number.getDouble());
    }

    public SNumber divide(SNumber number) {
        SDouble result = null;
        try {
            result = new SDouble(this._value / number.getDouble());
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return result;
    }

    public long getLong() {
        return (long)this._value;
    }

    public double getDouble() {
        return this._value;
    }

    public Object getObject() {
        return new Double(this._value);
    }

    public SBool equal(SObject obj) {
        SBool result = SBool.FALSE;
        double rhs = ((SNumber)obj).getDouble();
        if (this._value == rhs) {
            result = SBool.TRUE;
        }
        return result;
    }

    public SBool less(SObject obj) {
        SBool result = SBool.FALSE;
        double rhs = ((SNumber)obj).getDouble();
        if (this._value < rhs) {
            result = SBool.TRUE;
        }
        return result;
    }

    public SBool greater(SObject obj) {
        SBool result = SBool.FALSE;
        double rhs = ((SNumber)obj).getDouble();
        if (this._value > rhs) {
            result = SBool.TRUE;
        }
        return result;
    }
}

