/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.exolab.jms.selector.InvalidRegexpException;

final class RegexpFactory {
    private RegexpFactory() {
    }

    public static Pattern create(String pattern, Character escape) throws InvalidRegexpException {
        StringBuffer buff = new StringBuffer();
        buff.append('^');
        int i = 0;
        while (i < pattern.length()) {
            boolean escaped = false;
            char ch = pattern.charAt(i);
            if (escape != null && ch == escape.charValue()) {
                if (++i < pattern.length()) {
                    ch = pattern.charAt(i);
                    escaped = true;
                } else {
                    throw new InvalidRegexpException(pattern);
                }
            }
            switch (ch) {
                case '_': {
                    if (escaped) {
                        buff.append(ch);
                        break;
                    }
                    buff.append('.');
                    break;
                }
                case '%': {
                    if (escaped) {
                        buff.append(ch);
                        break;
                    }
                    buff.append(".*");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buff.append('\\');
                    buff.append(ch);
                    break;
                }
                default: {
                    buff.append(ch);
                }
            }
            ++i;
        }
        buff.append('$');
        Pattern result = null;
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            result = compiler.compile(buff.toString());
        }
        catch (MalformedPatternException exception) {
            throw new InvalidRegexpException(pattern);
        }
        return result;
    }
}

