/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import javax.jms.Message;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Matcher;
import org.exolab.jms.selector.Identifier;
import org.exolab.jms.selector.IdentifierExpression;
import org.exolab.jms.selector.InvalidRegexpException;
import org.exolab.jms.selector.RegexpFactory;
import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.SString;
import org.exolab.jms.selector.SelectorException;
import org.exolab.jms.selector.TypeCaster;
import org.exolab.jms.selector.TypeMismatchException;

class LikeExpression
extends IdentifierExpression {
    private final Pattern _regexp;
    private final PatternMatcher _matcher;
    private final String _pattern;
    private final String _escape;

    public LikeExpression(Identifier identifier, String pattern, String escape) throws SelectorException {
        super(identifier);
        this._pattern = pattern;
        this._escape = escape;
        this._regexp = this.getRegexp(this._pattern, this._escape);
        this._matcher = new Perl5Matcher();
    }

    public final SObject evaluate(Message msg) throws TypeMismatchException {
        SBool result = null;
        SString value = TypeCaster.castToString(this.identifier().evaluate(msg), "like expression");
        if (value != null) {
            result = this._matcher.matches((String)value.getObject(), this._regexp) ? SBool.TRUE : SBool.FALSE;
        }
        return result;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append('(');
        result.append(this.identifier().toString());
        result.append(" like '");
        result.append(this._pattern);
        result.append('\'');
        if (this._escape != null) {
            result.append(" escape '");
            result.append(this._escape);
            result.append('\'');
        }
        result.append(')');
        return result.toString();
    }

    private Pattern getRegexp(String pattern, String escape) throws SelectorException {
        Pattern result = null;
        Character esc = null;
        if (escape != null) {
            if (escape.length() != 1) {
                throw new SelectorException("Invalid escape: " + escape);
            }
            esc = new Character(escape.charAt(0));
        }
        try {
            result = RegexpFactory.create(pattern, esc);
        }
        catch (InvalidRegexpException err) {
            throw new SelectorException("Invalid pattern: " + pattern);
        }
        return result;
    }
}

