/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

public final class Identifiers {
    public static final String JMS_PREFIX = "JMS";
    public static final String JMSX_PREFIX = "JMSX";
    public static final String JMS_PROVIDER_PREFIX = "JMS_";
    public static final String JMS_DELIVERY_MODE = "JMSDeliveryMode";
    public static final String JMS_PRIORITY = "JMSPriority";
    public static final String JMS_MESSAGE_ID = "JMSMessageID";
    public static final String JMS_TIMESTAMP = "JMSTimestamp";
    public static final String JMS_CORRELATION_ID = "JMSCorrelationID";
    public static final String JMS_TYPE = "JMSType";
    public static final String PERSISTENT = "PERSISTENT";
    public static final String NON_PERSISTENT = "NON_PERSISTENT";

    private Identifiers() {
    }

    public static boolean isJMSIdentifier(String name) {
        boolean result = false;
        if (name.startsWith(JMS_PREFIX) && !name.startsWith(JMSX_PREFIX) && !name.startsWith(JMS_PROVIDER_PREFIX)) {
            result = true;
        }
        return result;
    }

    public static boolean isQueryableJMSIdentifier(String name) {
        return name.equals(JMS_DELIVERY_MODE) || name.equals(JMS_PRIORITY) || name.equals(JMS_TIMESTAMP) || name.equals(JMS_MESSAGE_ID) || name.equals(JMS_CORRELATION_ID) || name.equals(JMS_TYPE);
    }

    public static boolean isString(String name) {
        return name.equals(JMS_MESSAGE_ID) || name.equals(JMS_CORRELATION_ID) || name.equals(JMS_TYPE) || name.equals(JMS_DELIVERY_MODE);
    }

    public static boolean isNumeric(String name) {
        return name.equals(JMS_PRIORITY) || name.equals(JMS_TIMESTAMP);
    }
}

