/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import javax.jms.Message;
import org.exolab.jms.selector.Expression;
import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SNumber;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.TypeCaster;
import org.exolab.jms.selector.TypeMismatchException;

class BetweenExpression
implements Expression {
    private final Expression _num1;
    private final Expression _num2;
    private final Expression _num3;
    private static final String CONTEXT = "between expression";

    public BetweenExpression(Expression num1, Expression num2, Expression num3) {
        this._num1 = num1;
        this._num2 = num2;
        this._num3 = num3;
    }

    public final SObject evaluate(Message msg) throws TypeMismatchException {
        SNumber val3;
        SNumber val2;
        SBool result = null;
        SNumber val1 = TypeCaster.castToNumber(this._num1.evaluate(msg), CONTEXT);
        if (val1 != null && (val2 = TypeCaster.castToNumber(this._num2.evaluate(msg), CONTEXT)) != null && (val3 = TypeCaster.castToNumber(this._num3.evaluate(msg), CONTEXT)) != null) {
            result = val1.greaterEqual(val2).value() && val1.lessEqual(val3).value() ? SBool.TRUE : SBool.FALSE;
        }
        return result;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append('(');
        result.append(this._num1.toString());
        result.append(" between ");
        result.append(this._num2.toString());
        result.append(" and ");
        result.append(this._num3.toString());
        result.append(')');
        return result.toString();
    }
}

