/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.scheduler;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.BasicService;
import org.exolab.core.service.ServiceException;
import org.exolab.core.threadPool.ThreadPool;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.SchedulerConfiguration;
import org.exolab.jms.threads.ThreadPoolManager;

public class Scheduler
extends BasicService {
    private ThreadPool _threads = null;
    private LinkedList _queue = new LinkedList();
    private HashMap _references = new HashMap();
    private volatile boolean _stop = false;
    private int _threadCount = 6;
    private static final int MIN_THREAD_COUNT = 2;
    private static final String SCHEDULER_NAME = "Scheduler";
    private static Scheduler _instance = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$scheduler$Scheduler == null ? (class$org$exolab$jms$scheduler$Scheduler = Scheduler.class$("org.exolab.jms.scheduler.Scheduler")) : class$org$exolab$jms$scheduler$Scheduler));
    static /* synthetic */ Class class$org$exolab$jms$scheduler$Scheduler;

    public static Scheduler createInstance() throws ServiceException {
        _instance = new Scheduler();
        return _instance;
    }

    public static Scheduler instance() {
        return _instance;
    }

    private Scheduler() throws ServiceException {
        super(SCHEDULER_NAME);
        Configuration config = ConfigurationManager.getConfig();
        SchedulerConfiguration sched_config = config.getSchedulerConfiguration();
        int count = sched_config.getMaxThreads();
        if (count < 2) {
            count = 2;
        }
        this._threadCount = count;
        this._threads = ThreadPoolManager.instance().createThreadPool(SCHEDULER_NAME, this._threadCount);
    }

    public void add(Runnable runner) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.addLast(runner);
            this.addReference(runner);
            this._queue.notify();
        }
    }

    public boolean remove(Runnable runner) {
        boolean result = false;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            result = this._queue.remove(runner);
        }
        return result;
    }

    public boolean contains(Runnable runner) {
        boolean result = false;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            result = this._references.get(runner) != null;
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result = false;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            result = this._queue.isEmpty();
        }
        return result;
    }

    public void run() {
        while (!this._stop) {
            Runnable runner = this.next();
            if (this._stop || runner == null) continue;
            try {
                this._threads.execute(runner);
            }
            catch (Exception exception) {
                _log.error((Object)exception);
            }
        }
    }

    public void stop() throws ServiceException {
        this._threads.stopRequestAllWorkers();
        this._stop = true;
        super.stop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Runnable next() {
        Runnable result = null;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            while (!this._stop && this._queue.isEmpty()) {
                try {
                    this._queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this._stop) return result;
            result = (Runnable)this._queue.removeFirst();
            this.removeReference(result);
            return result;
        }
    }

    private void addReference(Runnable runner) {
        Integer count = (Integer)this._references.get(runner);
        if (count != null) {
            count = new Integer(count + 1);
            this._references.put(runner, count);
        } else {
            this._references.put(runner, new Integer(1));
        }
    }

    private void removeReference(Runnable runner) {
        Integer count = (Integer)this._references.get(runner);
        if (count <= 1) {
            this._references.remove(runner);
        } else {
            this._references.put(runner, new Integer(count - 1));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

