/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.exolab.jms.authentication.User;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;

class Users {
    private static Users _instance;
    private static final Object _block;

    private Users() throws PersistenceException {
    }

    public static Users instance() {
        return _instance;
    }

    public static Users initialise(Connection connection) throws PersistenceException {
        if (_instance == null) {
            Object object = _block;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new Users();
                    _instance.load(connection);
                }
            }
        }
        return _instance;
    }

    public synchronized void add(Connection connection, User user) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                insert = connection.prepareStatement("insert into users values (?, ?)");
                insert.setString(1, user.getUsername());
                insert.setString(2, user.getPassword());
                insert.executeUpdate();
            }
            catch (Exception error) {
                throw new PersistenceException("Users.add failed with " + error.toString());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    public synchronized void update(Connection connection, User user) throws PersistenceException {
        PreparedStatement update = null;
        try {
            try {
                update = connection.prepareStatement("update users set password=? where username=?");
                update.setString(1, user.getPassword());
                update.setString(2, user.getUsername());
                update.executeUpdate();
            }
            catch (Exception error) {
                throw new PersistenceException("Users.add failed with " + error.toString());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SQLHelper.close(update);
            throw throwable;
        }
        SQLHelper.close(update);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean remove(Connection connection, User user) throws PersistenceException {
        boolean success = false;
        PreparedStatement deleteUsers = null;
        if (user == null) return success;
        try {
            try {
                deleteUsers = connection.prepareStatement("delete from users where username=?");
                deleteUsers.setString(1, user.getUsername());
                deleteUsers.executeUpdate();
            }
            catch (Exception error) {
                throw new PersistenceException("Users.remove failed " + error.toString());
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SQLHelper.close(deleteUsers);
            throw throwable;
        }
        SQLHelper.close(deleteUsers);
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized User get(Connection connection, User user) throws PersistenceException {
        boolean success = false;
        PreparedStatement getUser = null;
        ResultSet set = null;
        User result = null;
        if (user == null) return result;
        try {
            block4: {
                try {
                    getUser = connection.prepareStatement("select * from users where username=?");
                    getUser.setString(1, user.getUsername());
                    set = getUser.executeQuery();
                    if (!set.next()) break block4;
                    result = new User(set.getString(1), set.getString(2));
                }
                catch (Exception error) {
                    throw new PersistenceException("Users.remove failed " + error.toString());
                }
            }
            Object var9_7 = null;
            SQLHelper.close(set);
            SQLHelper.close(getUser);
            return result;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            SQLHelper.close(set);
            SQLHelper.close(getUser);
            throw throwable;
        }
    }

    public synchronized Vector getAllUsers(Connection connection) throws PersistenceException {
        boolean success = false;
        PreparedStatement getUsers = null;
        ResultSet set = null;
        User user = null;
        Vector<User> result = new Vector<User>();
        try {
            try {
                getUsers = connection.prepareStatement("select * from users");
                set = getUsers.executeQuery();
                while (set.next()) {
                    user = new User(set.getString(1), set.getString(2));
                    result.add(user);
                }
            }
            catch (Exception error) {
                throw new PersistenceException("Users.remove failed " + error.toString());
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            SQLHelper.close(set);
            SQLHelper.close(getUsers);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(getUsers);
        return result;
    }

    public synchronized void close() {
        _instance = null;
    }

    private void load(Connection connection) throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = connection.prepareStatement("select * from users");
                set = select.executeQuery();
                while (set.next()) {
                    String name = set.getString(1);
                    String password = set.getString(2);
                }
            }
            catch (Exception error) {
                throw new PersistenceException("Error in Users.load " + error.toString());
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
    }

    static {
        _block = new Object();
    }
}

