/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.foundation.HandleIfc;
import org.exolab.jms.authentication.User;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.config.RdbmsDatabaseConfiguration;
import org.exolab.jms.events.EventHandler;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.Consumers;
import org.exolab.jms.persistence.DBConnectionManager;
import org.exolab.jms.persistence.Destinations;
import org.exolab.jms.persistence.MessageHandles;
import org.exolab.jms.persistence.Messages;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.persistence.SeedGenerator;
import org.exolab.jms.persistence.Users;

public class RDBMSAdapter
extends PersistenceAdapter
implements EventHandler {
    public static final String SCHEMA_VERSION = "V0.7.6";
    private static DBConnectionManager _connectionManager = null;
    private int _gcInterval = 600;
    private int _gcBlockSize = 500;
    private long _lastTime = 0L;
    private int _gcThreadPriority = 5;
    private ReadWriteLock _destinationLock = new FIFOReadWriteLock();
    private static final int COLLECT_DATABASE_GARBAGE_EVENT = 1;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$RDBMSAdapter == null ? (class$org$exolab$jms$persistence$RDBMSAdapter = RDBMSAdapter.class$("org.exolab.jms.persistence.RDBMSAdapter")) : class$org$exolab$jms$persistence$RDBMSAdapter));
    static /* synthetic */ Class class$org$exolab$jms$persistence$RDBMSAdapter;

    RDBMSAdapter(String driver, String url, String userName, String password) throws PersistenceException {
        DatabaseConfiguration dbConfig = ConfigurationManager.getConfig().getDatabaseConfiguration();
        RdbmsDatabaseConfiguration config = dbConfig.getRdbmsDatabaseConfiguration();
        _connectionManager = this.getConnectionManager(config.getClazz());
        _connectionManager.setUser(userName);
        _connectionManager.setPassword(password);
        _connectionManager.setDriver(driver);
        _connectionManager.setURL(url);
        _connectionManager.setMaxActive(config.getMaxActive());
        _connectionManager.setMaxIdle(config.getMaxIdle());
        _connectionManager.setMinIdleTime(config.getMinIdleTime());
        _connectionManager.setEvictionInterval(config.getEvictionInterval());
        _connectionManager.setTestQuery(config.getTestQuery());
        _connectionManager.setTestBeforeUse(config.getTestBeforeUse());
        _connectionManager.init();
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                String version = this.getSchemaVersion(connection);
                if (version == null) {
                    this.initSchemaVersion(connection);
                } else if (!version.equals(SCHEMA_VERSION)) {
                    throw new PersistenceException("Schema needs to be converted from version=" + version + " to version=" + SCHEMA_VERSION + "\nBack up your database, and run 'dbtool -migrate'" + "to convert the schema");
                }
                SeedGenerator.initialise();
                Destinations.initialise(connection);
                Consumers.initialise(connection);
                Messages.initialise();
                MessageHandles.initialise();
                connection.commit();
                Users.initialise(connection);
            }
            catch (PersistenceException exception) {
                SQLHelper.rollback(connection);
                throw exception;
            }
            catch (Exception exception) {
                throw new PersistenceException("Failed to initialise database adapter", exception);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        if (dbConfig.hasGarbageCollectionInterval()) {
            this._gcInterval = dbConfig.getGarbageCollectionInterval() * 1000;
            this.registerEvent();
        }
        if (dbConfig.hasGarbageCollectionBlockSize()) {
            this._gcBlockSize = dbConfig.getGarbageCollectionBlockSize();
        }
        if (dbConfig.hasGarbageCollectionThreadPriority()) {
            this._gcThreadPriority = dbConfig.getGarbageCollectionBlockSize();
            if (this._gcThreadPriority < 1) {
                this._gcThreadPriority = 1;
            } else if (this._gcThreadPriority > 10) {
                this._gcThreadPriority = 10;
            }
        }
    }

    public void close() {
        if (SeedGenerator.instance() != null) {
            SeedGenerator.instance().close();
        }
        if (Destinations.instance() != null) {
            Destinations.instance().close();
        }
        if (Consumers.instance() != null) {
            Consumers.instance().close();
        }
        if (Messages.instance() != null) {
            Messages.instance().close();
        }
        if (MessageHandles.instance() != null) {
            MessageHandles.instance().close();
        }
        if (Users.instance() != null) {
            Users.instance().close();
        }
    }

    public long getLastId(Connection connection) throws PersistenceException {
        long lastId = -1L;
        boolean successful = false;
        PreparedStatement query = null;
        ResultSet result = null;
        PreparedStatement insert = null;
        try {
            block5: {
                try {
                    query = connection.prepareStatement("select * from message_id where id = 1");
                    result = query.executeQuery();
                    if (result.next()) {
                        lastId = result.getInt("maxId");
                        break block5;
                    }
                    insert = connection.prepareStatement("insert into message_id values (?,?)");
                    insert.setInt(1, 1);
                    insert.setLong(2, 0L);
                    insert.executeUpdate();
                    lastId = 0L;
                }
                catch (Exception exception) {
                    throw new PersistenceException("Failed to get last message id", exception);
                }
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            SQLHelper.close(result);
            SQLHelper.close(insert);
            SQLHelper.close(query);
            throw throwable;
        }
        SQLHelper.close(result);
        SQLHelper.close(insert);
        SQLHelper.close(query);
        return lastId;
    }

    public void updateIds(Connection connection, long id) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                insert = connection.prepareStatement("update message_id set maxId = ? where id = 1");
                insert.setLong(1, id);
                insert.executeUpdate();
            }
            catch (Exception exception) {
                throw new PersistenceException("Failed to update message id", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMessage(Connection connection, MessageImpl message) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                Messages.instance().add(connection, message);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("addMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("addMessage," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMessage(Connection connection, MessageImpl message) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                Messages.instance().update(connection, message);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("updateMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("updateMessage," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getUnprocessedMessages(Connection connection) throws PersistenceException {
        Vector vector;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            vector = Messages.instance().getUnprocessedMessages(connection);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getUnprocessedMessages," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return vector;
        _log.debug((Object)("getUnprocessedMessages," + (System.currentTimeMillis() - start)));
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMessage(Connection connection, String id) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                Messages.instance().remove(connection, id);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("removeMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("removeMessage," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageImpl getMessage(Connection connection, String id) throws PersistenceException {
        MessageImpl messageImpl;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            messageImpl = Messages.instance().get(connection, id);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return messageImpl;
        _log.debug((Object)("getMessage," + (System.currentTimeMillis() - start)));
        return messageImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getMessages(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        Vector vector;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            vector = Messages.instance().getMessages(connection, handle.getDestination().getName(), handle.getPriority(), handle.getAcceptedTime());
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getMessages," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return vector;
        _log.debug((Object)("getMessages," + (System.currentTimeMillis() - start)));
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                MessageHandles.instance().addMessageHandle(connection, handle);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("addMessageHandle," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("addMessageHandle," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                MessageHandles.instance().updateMessageHandle(connection, handle);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("updateMessageHandle," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("updateMessageHandle," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                MessageHandles.instance().removeMessageHandle(connection, handle);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("removeMessageHandle," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("removeMessageHandle," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getMessageHandles(Connection connection, JmsDestination destination, String name) throws PersistenceException {
        Vector vector;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            vector = MessageHandles.instance().getMessageHandles(connection, destination.getName(), name);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getMessageHandles," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return vector;
        _log.debug((Object)("getMessageHandles," + (System.currentTimeMillis() - start)));
        return vector;
    }

    public void addDurableConsumer(Connection connection, String topic, String consumer) throws PersistenceException {
        try {
            try {
                this._destinationLock.readLock().acquire();
                Consumers.instance().add(connection, topic, consumer);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this._destinationLock.readLock().release();
            throw throwable;
        }
        this._destinationLock.readLock().release();
    }

    public void removeDurableConsumer(Connection connection, String consumer) throws PersistenceException {
        try {
            try {
                this._destinationLock.readLock().acquire();
                Consumers.instance().remove(connection, consumer);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this._destinationLock.readLock().release();
            throw throwable;
        }
        this._destinationLock.readLock().release();
    }

    public Enumeration getDurableConsumers(Connection connection, String topic) throws PersistenceException {
        return Consumers.instance().getDurableConsumers(topic).elements();
    }

    public HashMap getAllDurableConsumers(Connection connection) throws PersistenceException {
        return Consumers.instance().getAllDurableConsumers();
    }

    public boolean durableConsumerExists(Connection connection, String name) throws PersistenceException {
        return Consumers.instance().exists(name);
    }

    public void addDestination(Connection connection, String name, boolean queue) throws PersistenceException {
        JmsDestination destination = queue ? new JmsQueue(name) : new JmsTopic(name);
        try {
            block4: {
                try {
                    this._destinationLock.readLock().acquire();
                    Destinations.instance().add(connection, destination);
                    if (!queue) break block4;
                    Consumers.instance().add(connection, name, name);
                }
                catch (InterruptedException exception) {
                    throw new PersistenceException("Failed to acquire lock", exception);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this._destinationLock.readLock().release();
            throw throwable;
        }
        this._destinationLock.readLock().release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeDestination(Connection connection, String name) throws PersistenceException {
        JmsDestination destination = Destinations.instance().get(name);
        if (destination == null) return;
        try {
            try {
                this._destinationLock.writeLock().acquire();
                Destinations.instance().remove(connection, destination);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this._destinationLock.writeLock().release();
            throw throwable;
        }
        this._destinationLock.writeLock().release();
    }

    public Enumeration getAllDestinations(Connection connection) throws PersistenceException {
        return Destinations.instance().getDestinations().elements();
    }

    public boolean checkDestination(Connection connection, String name) throws PersistenceException {
        return Destinations.instance().get(name) != null;
    }

    public int getQueueMessageCount(Connection connection, String name) throws PersistenceException {
        return MessageHandles.instance().getMessageCount(connection, name, name);
    }

    public int getDurableConsumerMessageCount(Connection connection, String destination, String name) throws PersistenceException {
        return MessageHandles.instance().getMessageCount(connection, destination, name);
    }

    public void removeExpiredMessages(Connection connection) throws PersistenceException {
        Messages.instance().removeExpiredMessages(connection);
    }

    public void removeExpiredMessageHandles(Connection connection, String consumer) throws PersistenceException {
        MessageHandles.instance().removeExpiredMessageHandles(connection, consumer);
    }

    public Vector getNonExpiredMessages(Connection connection, JmsDestination destination) throws PersistenceException {
        return Messages.instance().getNonExpiredMessages(connection, destination);
    }

    public HandleIfc getHandle() {
        return null;
    }

    public void handleEvent(int event, Object callback, long time) {
    }

    public Connection getConnection() throws PersistenceException {
        return _connectionManager.getConnection();
    }

    public DBConnectionManager getDBConnectionManager() {
        return _connectionManager;
    }

    public void addUser(Connection connection, User user) throws PersistenceException {
        Users.instance().add(connection, user);
    }

    public Enumeration getAllUsers(Connection connection) throws PersistenceException {
        return Users.instance().getAllUsers(connection).elements();
    }

    public User getUser(Connection connection, User user) throws PersistenceException {
        return Users.instance().get(connection, user);
    }

    public void removeUser(Connection connection, User user) throws PersistenceException {
        Users.instance().remove(connection, user);
    }

    public void updateUser(Connection connection, User user) throws PersistenceException {
        Users.instance().update(connection, user);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int purgeMessages() {
        boolean deleted = false;
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.removeExpiredMessages(connection);
                connection.commit();
            }
            catch (Exception exception) {
                _log.error((Object)"Exception in purgeMessages", (Throwable)exception);
                Object var5_4 = null;
                SQLHelper.close(connection);
                return 0;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return 0;
    }

    private String getSchemaVersion(Connection connection) throws PersistenceException {
        String version = null;
        PreparedStatement query = null;
        ResultSet result = null;
        try {
            block4: {
                try {
                    query = connection.prepareStatement("select * from system_data where id = 1");
                    result = query.executeQuery();
                    if (!result.next()) break block4;
                    version = result.getString("version");
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to get the schema version", exception);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SQLHelper.close(result);
            SQLHelper.close(query);
            throw throwable;
        }
        SQLHelper.close(result);
        SQLHelper.close(query);
        return version;
    }

    private void initSchemaVersion(Connection connection) throws PersistenceException {
        _log.info((Object)"Initialising schema version V0.7.6");
        PreparedStatement insert = null;
        try {
            try {
                insert = connection.prepareStatement("insert into system_data values (?,?,?)");
                insert.setInt(1, 1);
                insert.setString(2, SCHEMA_VERSION);
                insert.setDate(3, new Date(System.currentTimeMillis()));
                insert.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to initialise schema version", exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    private void registerEvent() {
    }

    private DBConnectionManager getConnectionManager(String className) throws PersistenceException {
        DBConnectionManager result = null;
        Class<?> clazz = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                clazz = loader.loadClass(className);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        try {
            if (clazz == null) {
                clazz = Class.forName(className);
            }
        }
        catch (ClassNotFoundException exception) {
            throw new PersistenceException("Failed to locate connection manager implementation: " + className, exception);
        }
        try {
            result = (DBConnectionManager)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new PersistenceException("Failed to create connection manager", exception);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

