/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import javax.jms.JMSException;
import org.exolab.core.foundation.PersistentObject;
import org.exolab.jms.message.DestinationImpl;
import org.exolab.jms.message.MessageImpl;

public class PersistentMessage
extends PersistentObject {
    static final long serialVersionUID = 2L;
    private String destination_;
    private String messageId_;
    private String messageType_;
    private int priority_;
    private long timeStamp_;
    private long expiryTime_;
    private MessageImpl message_;
    private boolean processed_;

    public PersistentMessage() {
    }

    public PersistentMessage(MessageImpl message) throws JMSException {
        this.message_ = message;
        this.destination_ = ((DestinationImpl)message.getJMSDestination()).getDestination();
        this.messageId_ = message.getMessageId().getId();
        this.messageType_ = message.getJMSType();
        this.priority_ = message.getJMSPriority();
        this.expiryTime_ = message.getJMSExpiration();
        this.timeStamp_ = message.getAcceptedTime();
        this.processed_ = message.getProcessed();
    }

    public void setMessage(MessageImpl message) {
        this.message_ = message;
    }

    public MessageImpl getMessage() {
        return this.message_;
    }

    public byte[] getMessageBlob() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream tmp = new ObjectOutputStream(bout);
            tmp.writeObject(this.message_);
            tmp.close();
            return bout.toByteArray();
        }
        catch (Exception err) {
            System.err.println("Error PersistentMessage: Failed to serialize message\n" + err);
            return null;
        }
    }

    public void setMessageBlob(byte[] blob) {
        try {
            if (blob != null) {
                ByteArrayInputStream bin = new ByteArrayInputStream(blob);
                ObjectInputStream tmpin = new ObjectInputStream(bin);
                this.message_ = (MessageImpl)tmpin.readObject();
                tmpin.close();
            } else {
                this.message_ = null;
            }
        }
        catch (Exception err) {
            System.err.println("Error PersistentMessage: Failed to de-serialize message\n" + err);
            err.printStackTrace();
        }
    }

    public String getDestination() {
        return this.destination_;
    }

    public void setDestination(String destination) {
        this.destination_ = destination;
    }

    public String getMessageId() {
        return this.messageId_;
    }

    public void setMessageId(String id) {
        this.messageId_ = id;
    }

    public String getMessageType() {
        return this.messageType_;
    }

    public void setMessageType(String messageType) {
        this.messageType_ = messageType;
    }

    public int getPriority() {
        return this.priority_;
    }

    public void setPriority(int priority) {
        this.priority_ = priority;
    }

    public long getJMSTimeStamp() {
        return this.timeStamp_;
    }

    public void setJMSTimeStamp(long time) {
        this.timeStamp_ = time;
    }

    public long getExpiryTime() {
        return this.expiryTime_;
    }

    public void setExpiryTime(long time) {
        this.expiryTime_ = time;
    }

    public void setProcessed(boolean value) {
        this.processed_ = value;
    }

    public boolean getProcessed() {
        return this.processed_;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(2L);
        stream.writeObject(this.destination_);
        stream.writeUTF(this.messageId_);
        stream.writeObject(this.messageType_);
        stream.writeInt(this.priority_);
        stream.writeLong(this.timeStamp_);
        stream.writeLong(this.expiryTime_);
        stream.writeBoolean(this.processed_);
        stream.writeObject(this.message_);
        super.writeExternal(stream);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 2L) {
            throw new IOException("PersistentMessage with version " + version + " is not supported.");
        }
        this.destination_ = (String)stream.readObject();
        this.messageId_ = stream.readUTF();
        this.messageType_ = (String)stream.readObject();
        this.priority_ = stream.readInt();
        this.timeStamp_ = stream.readLong();
        this.expiryTime_ = stream.readLong();
        this.processed_ = stream.readBoolean();
        this.message_ = (MessageImpl)stream.readObject();
        super.readExternal(stream);
    }
}

