/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.database.recman.PMDHandle;
import org.exolab.core.database.recman.PMDHashMap;
import org.exolab.core.database.recman.PMDSessionManager;
import org.exolab.core.database.recman.PMDVector;
import org.exolab.core.database.recman.PageManagedDatabase;
import org.exolab.core.foundation.DatabaseIOException;
import org.exolab.core.foundation.FailedToAcquireLockException;
import org.exolab.core.foundation.FailedToCreateCollectionException;
import org.exolab.core.foundation.FailedToCreateDatabaseException;
import org.exolab.core.foundation.FailedToCreateLockException;
import org.exolab.core.foundation.FailedToCreateSessionException;
import org.exolab.core.foundation.FailedToDestroySessionException;
import org.exolab.core.foundation.HandleIfc;
import org.exolab.core.foundation.ObjectNameExistsException;
import org.exolab.core.foundation.PersistentCapableIfc;
import org.exolab.core.foundation.SessionIfc;
import org.exolab.core.foundation.TransactionException;
import org.exolab.core.foundation.TransactionInProgressException;
import org.exolab.core.foundation.TransactionNotInProgressException;
import org.exolab.jms.authentication.User;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.events.BasicEventManager;
import org.exolab.jms.events.Event;
import org.exolab.jms.events.EventHandler;
import org.exolab.jms.events.IllegalEventDefinedException;
import org.exolab.jms.message.DestinationImpl;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.NullConnection;
import org.exolab.jms.persistence.PMDLongInteger;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.PersistentMessage;
import org.exolab.jms.persistence.PersistentString;

public class ObjectAdapter
extends PersistenceAdapter
implements EventHandler {
    private PageManagedDatabase db_ = null;
    private String dbname_ = null;
    private static int MAX_WAIT_TIME = 5000;
    private static final String MESSAGES = "MESSAGES";
    private static final String DESTINATIONS = "DESTINATIONS";
    private static final String HANDLES = "HANDLES";
    private static final String TOPIC = "T_";
    private static final String QUEUE = "Q_";
    private static final String IDSTORAGE = "IDSTORAGE";
    private static final String VERSIONID = "VERSIONID";
    private static final long VERSIONNUM = 7L;
    private int minConsumerListSize_ = 10000;
    private int minMessageListSize_ = 20000;
    private NullConnection _connection = new NullConnection();
    private int _gcInterval = 600;
    private int _gcBlockSize = 500;
    private int _gcThreadPriority = 5;
    private static final int COLLECT_DATABASE_GARBAGE_EVENT = 1;
    private static final int MIN_CACHE_SIZE = 512;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$ObjectAdapter == null ? (class$org$exolab$jms$persistence$ObjectAdapter = ObjectAdapter.class$("org.exolab.jms.persistence.ObjectAdapter")) : class$org$exolab$jms$persistence$ObjectAdapter));
    static /* synthetic */ Class class$org$exolab$jms$persistence$ObjectAdapter;

    public ObjectAdapter(String dbName, int minListSize, int minMsgSize, int minCacheSize) throws PersistenceException {
        this.minConsumerListSize_ = Math.max(this.minConsumerListSize_, minListSize);
        this.minMessageListSize_ = Math.max(this.minMessageListSize_, minMsgSize);
        this.dbname_ = this.fixName(dbName);
        try {
            this.db_ = new PageManagedDatabase(this.dbname_);
            PMDSessionManager.init((PageManagedDatabase)this.db_);
        }
        catch (FailedToCreateDatabaseException exception) {
            throw new PersistenceException("Failed to initialise database adapter", exception);
        }
        this.checkVersion();
        _log.debug((Object)("minConsumerListSize = " + this.minConsumerListSize_));
        _log.debug((Object)("minMessageListSize = " + this.minMessageListSize_));
        try {
            this.createIdRoot();
        }
        catch (Exception exception) {
            throw new PersistenceException("Failed to create database root", exception);
        }
        DatabaseConfiguration config = ConfigurationManager.getConfig().getDatabaseConfiguration();
        if (config.hasGarbageCollectionInterval()) {
            this._gcInterval = config.getGarbageCollectionInterval() * 1000;
            this.registerEvent();
        }
        if (config.hasGarbageCollectionBlockSize()) {
            this._gcBlockSize = config.getGarbageCollectionBlockSize();
        }
        if (config.hasGarbageCollectionThreadPriority()) {
            this._gcThreadPriority = config.getGarbageCollectionBlockSize();
            if (this._gcThreadPriority < 1) {
                this._gcThreadPriority = 1;
            } else if (this._gcThreadPriority > 10) {
                this._gcThreadPriority = 10;
            }
        }
    }

    private String fixName(String dbName) {
        String newDbName = dbName;
        newDbName.trim();
        int i = newDbName.lastIndexOf(46);
        if (i > 0 && i < newDbName.length() - 1) {
            newDbName = newDbName.substring(0, i);
        }
        return newDbName;
    }

    public void close() {
        if (this.db_ != null) {
            this.db_.close();
            this.dbname_ = null;
            this.db_ = null;
        }
    }

    private void checkVersion() {
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = (PMDVector)session.lookup(VERSIONID);
            if (vector == null) {
                _log.debug((Object)"Setting Version Id");
                vector = (PMDVector)session.getCollectionManager().createVector();
                session.createObject((PersistentCapableIfc)vector);
                session.bind(VERSIONID, (PersistentCapableIfc)vector);
                session.getCurrentTransaction().commit();
                session.getCurrentTransaction().begin();
                vector = (PMDVector)session.lookup(VERSIONID);
                session.acquireLock((PersistentCapableIfc)vector, 10);
                vector.addElement((PersistentCapableIfc)new PMDLongInteger(7L));
                session.updateObject((PersistentCapableIfc)vector);
                session.getCurrentTransaction().commit();
            } else {
                if (vector.size() == 1) {
                    long ver = ((PMDLongInteger)vector.get(0)).get();
                    if (ver != 7L) {
                        _log.error((Object)("Incompatible Database version Schema\nDb Vesrsion = " + ver + "\tSchema Version = " + 7L + "\nExiting..."));
                        System.exit(-1);
                    }
                } else {
                    _log.error((Object)"Corrupted Db schema version ID:\n Exiting...");
                    System.exit(-1);
                }
                session.getCurrentTransaction().abort();
            }
            try {
                PMDSessionManager.instance().destroySession();
            }
            catch (FailedToDestroySessionException exception) {
                _log.error((Object)"Failed to destroy session", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Error verifying DB schema, exiting", (Throwable)exception);
            System.exit(-1);
        }
    }

    private void createIdRoot() throws FailedToCreateSessionException, TransactionInProgressException, FailedToCreateCollectionException, DatabaseIOException, TransactionNotInProgressException, ObjectNameExistsException, TransactionException, FailedToCreateLockException, FailedToAcquireLockException, FailedToDestroySessionException {
        SessionIfc session = this.getSession();
        session.getCurrentTransaction().begin();
        PMDVector vector = (PMDVector)session.lookup(IDSTORAGE);
        if (vector == null) {
            _log.debug((Object)"Creating ID Storage root");
            vector = (PMDVector)session.getCollectionManager().createVector();
            session.createObject((PersistentCapableIfc)vector);
            session.bind(IDSTORAGE, (PersistentCapableIfc)vector);
            session.getCurrentTransaction().commit();
            session.getCurrentTransaction().begin();
            vector = (PMDVector)session.lookup(IDSTORAGE);
            session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
            vector.addElement((PersistentCapableIfc)new PMDLongInteger(0L));
            session.updateObject((PersistentCapableIfc)vector);
            session.getCurrentTransaction().commit();
        } else {
            session.getCurrentTransaction().abort();
        }
        session.getCurrentTransaction().begin();
        PMDHashMap map = (PMDHashMap)session.lookup(MESSAGES);
        if (map == null) {
            _log.debug((Object)"Creating Messages root");
            map = (PMDHashMap)session.getCollectionManager().createHashMap();
            session.createObject((PersistentCapableIfc)map);
            session.bind(MESSAGES, (PersistentCapableIfc)map);
            session.getCurrentTransaction().commit();
        } else {
            session.getCurrentTransaction().abort();
        }
        session.getCurrentTransaction().begin();
        vector = (PMDVector)session.lookup(DESTINATIONS);
        if (vector == null) {
            _log.debug((Object)"Creating Destinations root");
            vector = (PMDVector)session.getCollectionManager().createVector();
            session.createObject((PersistentCapableIfc)vector);
            session.bind(DESTINATIONS, (PersistentCapableIfc)vector);
            session.getCurrentTransaction().commit();
        } else {
            session.getCurrentTransaction().abort();
        }
        PMDSessionManager.instance().destroySession();
    }

    public long getLastId(Connection connection) throws PersistenceException {
        long lastId = -1L;
        try {
            this.createIdRoot();
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = (PMDVector)session.lookup(IDSTORAGE);
            if (vector != null && vector.size() == 1) {
                lastId = ((PMDLongInteger)vector.get(0)).get();
            }
            session.getCurrentTransaction().abort();
        }
        catch (Exception err) {
            _log.error((Object)("Failed to get Id: " + err.getMessage()));
        }
        try {
            PMDSessionManager.instance().destroySession();
        }
        catch (FailedToDestroySessionException sessErr) {
            _log.error((Object)("Failed to destroy session: " + sessErr.getMessage()));
            sessErr.printStackTrace();
        }
        return lastId;
    }

    public void updateIds(Connection connection, long id) throws PersistenceException {
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = (PMDVector)session.lookup(IDSTORAGE);
            if (vector != null) {
                session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                if (vector.size() == 1) {
                    vector.set(0, (PersistentCapableIfc)new PMDLongInteger(id));
                    session.updateObject((PersistentCapableIfc)vector);
                }
            }
            session.getCurrentTransaction().commit();
        }
        catch (Exception err) {
            throw new PersistenceException("Failed to get Id: " + err.getMessage());
        }
        try {
            PMDSessionManager.instance().destroySession();
        }
        catch (FailedToDestroySessionException sessErr) {
            _log.error((Object)"Failed to destroy session", (Throwable)sessErr);
        }
    }

    public synchronized void addMessage(Connection connection, MessageImpl message) throws PersistenceException {
        try {
            DestinationImpl dest = (DestinationImpl)message.getJMSDestination();
            String name = dest.getDestination();
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDHashMap messages = this.messageTable(session);
            if (messages != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)messages, MAX_WAIT_TIME);
                    String id = message.getMessageId().getId();
                    if (messages.get((Object)id) != null) {
                        throw new PersistenceException("Mesage with this id: " + message.getJMSMessageID() + " already exists: NOT ADDING");
                    }
                    PersistentMessage pm = new PersistentMessage(message);
                    session.createObject((PersistentCapableIfc)pm);
                    messages.put((Object)id, (PersistentCapableIfc)session.createHandle((PersistentCapableIfc)pm));
                    session.updateObject((PersistentCapableIfc)messages);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in addMessage " + err.toString());
                }
            } else {
                _log.error((Object)("Attempt to save message for non register queue/topic, name = " + name));
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException exception) {
            throw exception;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in addMessage " + err.toString());
        }
    }

    public synchronized void updateMessage(Connection connection, MessageImpl message) throws PersistenceException {
        try {
            DestinationImpl dest = (DestinationImpl)message.getJMSDestination();
            String name = dest.getDestination();
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDHashMap messages = this.messageTable(session);
            if (messages != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)messages, MAX_WAIT_TIME);
                    String id = message.getMessageId().getId();
                    if (messages.get((Object)id) == null) {
                        throw new PersistenceException("Mesage with this id: " + message.getJMSMessageID() + " doesn't exists: NOT UPDATING");
                    }
                    PMDHandle handle = (PMDHandle)messages.get((Object)id);
                    PersistentMessage pm = (PersistentMessage)((Object)handle.resolve());
                    pm.setMessage(message);
                    pm.setProcessed(message.getProcessed());
                    session.updateObject((PersistentCapableIfc)pm);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in updateMessage " + err.toString());
                }
            } else {
                throw new PersistenceException("Attempt to save message for non register queue/topic, name = " + name);
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in updateMessage " + err.toString());
        }
    }

    public synchronized void removeMessage(Connection connection, String id) throws PersistenceException {
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDHashMap map = this.messageTable(session);
            if (map != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)map, MAX_WAIT_TIME);
                    PMDHandle handle = (PMDHandle)map.remove((Object)id);
                    if (handle != null) {
                        session.deleteObject((PersistentCapableIfc)((PersistentMessage)((Object)handle.resolve())));
                    }
                    session.updateObject((PersistentCapableIfc)map);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in removeMessage " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in removeMessage Cannot retrieve the message talbe ");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in removeMessage " + err.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized MessageImpl getMessage(Connection connection, String id) throws PersistenceException {
        MessageImpl message = null;
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDHashMap map = this.messageTable(session);
            if (map == null) throw new PersistenceException("Error in getMessage Failed to retrieve the message table.");
            try {
                session.acquireLock((PersistentCapableIfc)map, MAX_WAIT_TIME);
                PMDHandle handle = (PMDHandle)map.get((Object)id);
                PersistentMessage m = null;
                if (handle != null) {
                    m = (PersistentMessage)((Object)handle.resolve());
                }
                if (m != null) {
                    message = m.getMessage();
                }
            }
            catch (Exception err) {
                throw new PersistenceException("Error in getMessage " + err.toString());
            }
            session.getCurrentTransaction().abort();
            PMDSessionManager.instance().destroySession();
            return message;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in getMessage " + err.toString());
        }
    }

    public synchronized Vector getUnprocessedMessages(Connection connection) throws PersistenceException {
        Vector<MessageImpl> result = new Vector<MessageImpl>();
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDHashMap map = this.messageTable(session);
            if (map != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)map, MAX_WAIT_TIME);
                    Enumeration iter = map.elements();
                    while (iter.hasMoreElements()) {
                        PMDHandle handle = (PMDHandle)iter.nextElement();
                        PersistentMessage m = (PersistentMessage)((Object)handle.resolve());
                        if (m.getProcessed()) continue;
                        result.add(m.getMessage());
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in getUnprocessedMessages " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in getUnprocessedMessage. Failed to get message table");
            }
            session.getCurrentTransaction().abort();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in getUnprocessedMessages " + err.toString());
        }
        return result;
    }

    public synchronized Vector getMessages(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        Vector<MessageImpl> messages = new Vector<MessageImpl>();
        MessageImpl message = this.getMessage(connection, handle.getMessageId().getId());
        if (message != null) {
            messages.add(message);
        }
        return messages;
    }

    public synchronized void addMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        try {
            SessionIfc session = this.getSession();
            String key = this.getHandlesRootName(handle.getDestination(), handle.getConsumerName());
            session.getCurrentTransaction().begin();
            PMDVector vector = this.handleTable(key, session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    vector.addElement((PersistentCapableIfc)handle);
                    session.updateObject((PersistentCapableIfc)vector);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in addMessageHandle " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in addMessageHandle Cannot get handle table for " + key);
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in addMessageHandle " + err.toString());
        }
    }

    public synchronized void updateMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        try {
            SessionIfc session = this.getSession();
            String key = this.getHandlesRootName(handle.getDestination(), handle.getConsumerName());
            session.getCurrentTransaction().begin();
            PMDVector vector = this.handleTable(key, session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    Enumeration handles = vector.elements();
                    while (handles.hasMoreElements()) {
                        PersistentMessageHandle phdl = (PersistentMessageHandle)handles.nextElement();
                        if (!phdl.getMessageId().getId().equals(handle.getMessageId().getId())) continue;
                        phdl.setDelivered(true);
                        break;
                    }
                    session.updateObject((PersistentCapableIfc)vector);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in addMessageHandle " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in updateMessageHandle Failed to get handle table for " + key);
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in updateMessageHandle " + err.toString());
        }
    }

    public synchronized void removeMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        try {
            SessionIfc session = this.getSession();
            String key = this.getHandlesRootName(handle.getDestination(), handle.getConsumerName());
            session.getCurrentTransaction().begin();
            PMDVector vector = this.handleTable(key, session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    vector.remove((PersistentCapableIfc)handle);
                    session.updateObject((PersistentCapableIfc)vector);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in removeMessageHandle " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in removeMessageHandle Failed to get the handle table for " + key);
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in removeMessageHandle " + err.toString());
        }
    }

    public synchronized Vector getMessageHandles(Connection connection, JmsDestination destination, String name) throws PersistenceException {
        Vector<Object> result = new Vector<Object>();
        try {
            SessionIfc session = this.getSession();
            String key = this.getHandlesRootName(destination, name);
            session.getCurrentTransaction().begin();
            PMDVector vector = this.handleTable(key, session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    Enumeration handles = vector.elements();
                    while (handles.hasMoreElements()) {
                        PersistentMessageHandle handle = (PersistentMessageHandle)handles.nextElement();
                        result.addElement(handle.clone());
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in getMessageHandles " + err.toString());
                }
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in getMessageHandles " + err.toString());
        }
        return result;
    }

    public synchronized void addDurableConsumer(Connection connection, String topic, String consumer) throws PersistenceException {
        try {
            SessionIfc session;
            block8: {
                session = this.getSession();
                session.getCurrentTransaction().begin();
                PMDVector vector = this.destinationTable(session);
                if (vector != null) {
                    try {
                        session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                        String target = "@" + consumer;
                        boolean found = false;
                        Enumeration entries = vector.elements();
                        while (entries.hasMoreElements()) {
                            PersistentString entry = (PersistentString)entries.nextElement();
                            if (!entry.toString().endsWith(target)) continue;
                            found = true;
                            break;
                        }
                        String key = null;
                        if (!found) {
                            vector.addElement((PersistentCapableIfc)new PersistentString(TOPIC + topic + target));
                            session.updateObject((PersistentCapableIfc)vector);
                            key = this.getHandlesRootName(consumer);
                            PMDVector handles = (PMDVector)session.getCollectionManager().createVector();
                            session.createObject((PersistentCapableIfc)handles);
                            session.bind(key, (PersistentCapableIfc)handles);
                            break block8;
                        }
                        throw new PersistenceException("Error in addDurableConsumer " + consumer + " already exists.");
                    }
                    catch (Exception err) {
                        throw new PersistenceException("Error in addDurableConsumer " + err.toString());
                    }
                }
                throw new PersistenceException("Error in addDurableConsumer Failed to get the destination table.");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in addDurableConsumer " + err.toString());
        }
    }

    public synchronized void removeDurableConsumer(Connection connection, String consumer) throws PersistenceException {
        try {
            SessionIfc session;
            block8: {
                session = this.getSession();
                session.getCurrentTransaction().begin();
                PMDVector vector = this.destinationTable(session);
                if (vector != null) {
                    try {
                        session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                        String target = "@" + consumer;
                        boolean found = false;
                        PersistentString entry = null;
                        Enumeration entries = vector.elements();
                        while (entries.hasMoreElements()) {
                            entry = (PersistentString)entries.nextElement();
                            if (!entry.toString().endsWith(target)) continue;
                            vector.remove((PersistentCapableIfc)entry);
                            found = true;
                            break;
                        }
                        String key = null;
                        if (found) {
                            vector.removeElement((PersistentCapableIfc)entry);
                            session.updateObject((PersistentCapableIfc)vector);
                            key = this.getHandlesRootName(consumer);
                            session.unbind(key);
                            break block8;
                        }
                        throw new PersistenceException("Error in removeDurableConsumer Cannot find consumer with name " + consumer);
                    }
                    catch (Exception err) {
                        throw new PersistenceException("Error in removeDurableConsumer " + err.toString());
                    }
                }
                throw new PersistenceException("Error in removeDurableConsumer Cannot get access to the destination table");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in removeDurableConsumer " + err.toString());
        }
    }

    public synchronized boolean durableConsumerExists(Connection connection, String name) throws PersistenceException {
        boolean exists = false;
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = this.destinationTable(session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    String target = "@" + name;
                    Enumeration entries = vector.elements();
                    while (entries.hasMoreElements()) {
                        PersistentString entry = (PersistentString)entries.nextElement();
                        if (!entry.toString().endsWith(target)) continue;
                        exists = true;
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in durableConsumerExists " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in durableConsumerExists Cannot get access to the destinationtable.");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in durableConsumerExists " + err.toString());
        }
        return exists;
    }

    public synchronized Enumeration getDurableConsumers(Connection connection, String topic) throws PersistenceException {
        Vector<String> consumers = new Vector<String>();
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = this.destinationTable(session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    String target = TOPIC + topic + "@";
                    Enumeration entries = vector.elements();
                    while (entries.hasMoreElements()) {
                        PersistentString entry = (PersistentString)entries.nextElement();
                        if (!entry.toString().startsWith(target)) continue;
                        consumers.addElement(entry.toString().substring(target.length()));
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in getDurableConsumers " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in getDurableConsumers Failed to get access to the destination table.");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in getDurableConsumers " + err.toString());
        }
        return consumers.elements();
    }

    public HashMap getAllDurableConsumers(Connection connection) throws PersistenceException {
        HashMap<String, String> consumers = new HashMap<String, String>();
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = this.destinationTable(session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    Enumeration entries = vector.elements();
                    while (entries.hasMoreElements()) {
                        PersistentString entry = (PersistentString)entries.nextElement();
                        String temp = entry.toString().substring(TOPIC.length());
                        int index = temp.indexOf("@");
                        if (!entry.toString().startsWith(TOPIC) || index == -1) continue;
                        consumers.put(temp.substring(index + 1), temp.substring(0, index));
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in getAllDurableConsumers " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in getAllDurableConsumers Failed to get access to the destination  table");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in getAllDurableConsumers " + err.toString());
        }
        return consumers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addDestination(Connection connection, String name, boolean queue) throws PersistenceException {
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = this.destinationTable(session);
            if (vector == null) throw new PersistenceException("Error in addDestination Failed to get access to destination table");
            try {
                session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                String target = queue ? QUEUE + name : TOPIC + name;
                boolean found = false;
                Enumeration entries = vector.elements();
                while (entries.hasMoreElements()) {
                    PersistentString entry = (PersistentString)entries.nextElement();
                    if (!entry.toString().equals(target)) continue;
                    found = true;
                    break;
                }
                String key = null;
                if (!found) {
                    vector.addElement((PersistentCapableIfc)new PersistentString(target));
                    session.updateObject((PersistentCapableIfc)vector);
                    if (queue) {
                        key = this.getHandlesRootName(name);
                        PMDVector handles = (PMDVector)session.getCollectionManager().createVector();
                        session.createObject((PersistentCapableIfc)handles);
                        session.bind(key, (PersistentCapableIfc)handles);
                    }
                }
            }
            catch (Exception err) {
                throw new PersistenceException("Error in addDestination " + err.toString());
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
            return;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in addDestination " + err.toString());
        }
    }

    public synchronized void removeDestination(Connection connection, String name) throws PersistenceException {
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = this.destinationTable(session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    Vector<PersistentString> to_delete = new Vector<PersistentString>();
                    Enumeration entries = vector.elements();
                    while (entries.hasMoreElements()) {
                        PersistentString wrapped_entry = (PersistentString)entries.nextElement();
                        String entry = wrapped_entry.toString();
                        int name_idx = entry.indexOf("@");
                        int dest_idx = entry.indexOf(name);
                        if (entry.substring(TOPIC.length()).equals(name)) {
                            to_delete.addElement(wrapped_entry);
                            if (!entry.startsWith(QUEUE)) continue;
                            session.unbind(this.getHandlesRootName(name));
                            continue;
                        }
                        if (name_idx < 0 || dest_idx < 0 || dest_idx >= name_idx) continue;
                        String consumer = entry.substring(name_idx + 1);
                        to_delete.addElement(wrapped_entry);
                        session.unbind(this.getHandlesRootName(consumer));
                    }
                    Enumeration elements = to_delete.elements();
                    while (elements.hasMoreElements()) {
                        vector.remove((PersistentCapableIfc)((PersistentString)elements.nextElement()));
                    }
                    session.updateObject((PersistentCapableIfc)vector);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in removeDestination " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in removeDestination Failed to get access to the destination table.");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in addDestination " + err.toString());
        }
    }

    public boolean checkDestination(Connection connection, String name) throws PersistenceException {
        boolean success = false;
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = this.destinationTable(session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    Vector to_delete = new Vector();
                    Enumeration entries = vector.elements();
                    while (entries.hasMoreElements()) {
                        PersistentString entry = (PersistentString)entries.nextElement();
                        if (!entry.toString().substring(TOPIC.length()).equals(name)) continue;
                        success = true;
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in checkDestination " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in checkDestination Failed to get access to destination table.");
            }
            session.getCurrentTransaction().abort();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in checkDestination " + err.toString());
        }
        return success;
    }

    public synchronized Enumeration getAllDestinations(Connection connection) throws PersistenceException {
        Vector<JmsDestination> destinations = new Vector<JmsDestination>();
        try {
            SessionIfc session = this.getSession();
            session.getCurrentTransaction().begin();
            PMDVector vector = this.destinationTable(session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    Vector to_delete = new Vector();
                    Enumeration entries = vector.elements();
                    while (entries.hasMoreElements()) {
                        PersistentString entry = (PersistentString)entries.nextElement();
                        String dest = entry.toString();
                        if (dest.indexOf("@") != -1) continue;
                        if (dest.startsWith(QUEUE)) {
                            destinations.addElement(new JmsQueue(dest.substring(QUEUE.length())));
                            continue;
                        }
                        if (!dest.startsWith(TOPIC)) continue;
                        destinations.addElement(new JmsTopic(dest.substring(TOPIC.length())));
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in checkDestination " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in checkDestination Failed to get access to the destination table.");
            }
            session.getCurrentTransaction().abort();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in checkDestination " + err.toString());
        }
        return destinations.elements();
    }

    public synchronized int getQueueMessageCount(Connection connection, String queue) throws PersistenceException {
        int count = -1;
        try {
            SessionIfc session = this.getSession();
            String key = this.getHandlesRootName(queue);
            session.getCurrentTransaction().begin();
            PMDVector vector = this.handleTable(key, session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    count = vector.size();
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in getQueueMessageCount " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in getQueueMessageCount Failed to get access to queue " + queue);
            }
            session.getCurrentTransaction().abort();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in getQueueMessageCount " + err.toString());
        }
        return count;
    }

    public synchronized int getDurableConsumerMessageCount(Connection connection, String topic, String name) throws PersistenceException {
        int count = -1;
        try {
            SessionIfc session = this.getSession();
            String key = this.getHandlesRootName(name);
            session.getCurrentTransaction().begin();
            PMDVector vector = this.handleTable(key, session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    count = vector.size();
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in getDurableConsumerMessageCount " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in getDurableConsumerMessageCount Cannot access table for " + topic + " : " + name);
            }
            session.getCurrentTransaction().abort();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in getDurableConsumerMessageCount " + err.toString());
        }
        return count;
    }

    public synchronized void removeExpiredMessages(Connection connection) throws PersistenceException {
        SessionIfc session = null;
        try {
            session = this.getSession();
            session.getCurrentTransaction().begin();
            long now = System.currentTimeMillis();
            PMDHashMap map = this.messageTable(session);
            if (map != null) {
                Vector<Object> to_remove;
                try {
                    session.acquireLock((PersistentCapableIfc)map, MAX_WAIT_TIME);
                    Enumeration iter = map.elements();
                    to_remove = new Vector<Object>();
                    while (iter.hasMoreElements()) {
                        PMDHandle handle = (PMDHandle)iter.nextElement();
                        PersistentMessage msg = (PersistentMessage)((Object)handle.resolve());
                        if (msg.getExpiryTime() == 0L || msg.getExpiryTime() > now) continue;
                        session.deleteObject((PersistentCapableIfc)msg);
                        to_remove.add(msg.getMessage().getJMSMessageID());
                    }
                    while (to_remove.size() > 0) {
                        map.remove(to_remove.remove(0));
                    }
                    session.updateObject((PersistentCapableIfc)map);
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in removeExpiredMessages " + err.toString());
                }
                PMDVector vector = this.destinationTable(session);
                if (vector != null) {
                    try {
                        session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                        Enumeration entries = vector.elements();
                        to_remove = new Vector();
                        while (entries.hasMoreElements()) {
                            PMDVector handles_vector;
                            to_remove.clear();
                            PersistentString entry = (PersistentString)entries.nextElement();
                            String name = this.getHandlesRootNameFromDestination(entry.toString());
                            if (name == null || (handles_vector = this.handleTable(name, session)) == null) continue;
                            Enumeration handles = handles_vector.elements();
                            while (handles.hasMoreElements()) {
                                PersistentMessageHandle handle = (PersistentMessageHandle)handles.nextElement();
                                if (handle.getExpiryTime() == 0L || handle.getExpiryTime() > now) continue;
                                to_remove.add(handle);
                            }
                            while (to_remove.size() > 0) {
                                handles_vector.remove((PersistentCapableIfc)((PersistentMessageHandle)to_remove.remove(0)));
                            }
                            session.updateObject((PersistentCapableIfc)handles_vector);
                        }
                    }
                    catch (Exception err) {
                        throw new PersistenceException("Error in removeExpiredMessages " + err.toString());
                    }
                } else {
                    throw new PersistenceException("Error in removeExpiredMessages Failed to get the message table");
                }
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            try {
                session.getCurrentTransaction().abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in removeExpiredMessages " + err.toString());
        }
    }

    public void removeExpiredMessageHandles(Connection connection, String consumer) throws PersistenceException {
    }

    public synchronized Vector getNonExpiredMessages(Connection connection, JmsDestination destination) throws PersistenceException {
        Vector<PersistentMessageHandle> result = new Vector<PersistentMessageHandle>();
        SessionIfc session = null;
        try {
            session = this.getSession();
            session.getCurrentTransaction().begin();
            long now = System.currentTimeMillis();
            PMDVector vector = this.destinationTable(session);
            if (vector != null) {
                try {
                    session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                    Enumeration entries = vector.elements();
                    while (entries.hasMoreElements()) {
                        PMDVector handles_vector;
                        String name;
                        PersistentString entry = (PersistentString)entries.nextElement();
                        if (entry.toString().indexOf(destination.getName()) == -1 || (name = this.getHandlesRootNameFromDestination(entry.toString())) == null || (handles_vector = this.handleTable(name, session)) == null) continue;
                        Enumeration handles = handles_vector.elements();
                        while (handles.hasMoreElements()) {
                            PersistentMessageHandle handle = (PersistentMessageHandle)handles.nextElement();
                            if (handle.getExpiryTime() == 0L || handle.getExpiryTime() <= now) continue;
                            result.add(handle);
                        }
                    }
                }
                catch (Exception err) {
                    throw new PersistenceException("Error in removeExpiredMessages " + err.toString());
                }
            } else {
                throw new PersistenceException("Error in removeExpiredMessages The destination table does not exist");
            }
            session.getCurrentTransaction().commit();
            PMDSessionManager.instance().destroySession();
        }
        catch (PersistenceException pe) {
            try {
                session.getCurrentTransaction().abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw pe;
        }
        catch (Exception err) {
            throw new PersistenceException("Error in removeExpiredMessages " + err.toString());
        }
        return result;
    }

    public synchronized int purgeMessages() {
        boolean errorSet = false;
        Vector<String> keep = new Vector<String>();
        int count = -1;
        try {
            SessionIfc session;
            block16: {
                session = this.getSession();
                session.getCurrentTransaction().begin();
                long now = System.currentTimeMillis();
                PMDVector vector = this.destinationTable(session);
                if (vector != null) {
                    try {
                        session.acquireLock((PersistentCapableIfc)vector, MAX_WAIT_TIME);
                        Enumeration entries = vector.elements();
                        while (entries.hasMoreElements()) {
                            PMDVector handles_vector;
                            PersistentString entry = (PersistentString)entries.nextElement();
                            String name = this.getHandlesRootNameFromDestination(entry.toString());
                            if (name == null || (handles_vector = this.handleTable(name, session)) == null) continue;
                            Enumeration handles = handles_vector.elements();
                            while (handles.hasMoreElements()) {
                                PersistentMessageHandle handle = (PersistentMessageHandle)handles.nextElement();
                                String id = handle.getMessageId().getId();
                                if (keep.contains(id)) continue;
                                keep.add(id);
                            }
                        }
                        PMDHashMap map = this.messageTable(session);
                        if (map != null) {
                            try {
                                session.acquireLock((PersistentCapableIfc)map, MAX_WAIT_TIME);
                                Enumeration iter = map.keys();
                                Vector<String> to_remove = new Vector<String>();
                                while (iter.hasMoreElements()) {
                                    String id = (String)iter.nextElement();
                                    if (keep.contains(id)) continue;
                                    session.deleteObject((PersistentCapableIfc)((PersistentMessage)((Object)((PMDHandle)map.get((Object)id)).resolve())));
                                    to_remove.add(id);
                                }
                                count = to_remove.size();
                                while (to_remove.size() > 0) {
                                    map.remove(to_remove.remove(0));
                                }
                                session.updateObject((PersistentCapableIfc)map);
                                _log.info((Object)("GC removed " + count + " messages from database."));
                            }
                            catch (Exception exception) {
                                errorSet = true;
                                _log.error((Object)"Error in purgeMessages", (Throwable)exception);
                            }
                            break block16;
                        }
                        _log.error((Object)"Message table does not exist");
                        errorSet = true;
                    }
                    catch (Exception err) {
                        errorSet = true;
                        _log.error((Object)"Error in getNonExpiredMessages", (Throwable)err);
                    }
                } else {
                    errorSet = true;
                }
            }
            if (!errorSet) {
                session.getCurrentTransaction().commit();
            } else {
                session.getCurrentTransaction().abort();
            }
            PMDSessionManager.instance().destroySession();
        }
        catch (FailedToDestroySessionException sessErr) {
            _log.error((Object)"Failed to destroy session", (Throwable)sessErr);
        }
        catch (Exception err) {
            _log.error((Object)err, (Throwable)err);
        }
        return count;
    }

    public void addUser(Connection connection, User user) throws PersistenceException {
    }

    public Enumeration getAllUsers(Connection connection) throws PersistenceException {
        return new Vector().elements();
    }

    public User getUser(Connection connection, User user) throws PersistenceException {
        return null;
    }

    public void removeUser(Connection connection, User user) throws PersistenceException {
    }

    public void updateUser(Connection connection, User user) throws PersistenceException {
    }

    public Connection getConnection() throws PersistenceException {
        return this._connection;
    }

    public HandleIfc getHandle() {
        return null;
    }

    public void handleEvent(int event, Object callback, long time) {
        if (event == 1) {
            try {
                Thread.currentThread().setPriority(this._gcThreadPriority);
                this.purgeMessages();
                Object var6_4 = null;
                Thread.currentThread().setPriority(5);
                this.registerEvent();
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Thread.currentThread().setPriority(5);
                this.registerEvent();
                throw throwable;
            }
        }
    }

    private SessionIfc getSession() throws FailedToCreateSessionException {
        return PMDSessionManager.instance().getSession();
    }

    private PMDHashMap messageTable(SessionIfc session) {
        return (PMDHashMap)session.lookup(MESSAGES);
    }

    private PMDVector destinationTable(SessionIfc session) {
        return (PMDVector)session.lookup(DESTINATIONS);
    }

    private PMDVector handleTable(String key, SessionIfc session) {
        return (PMDVector)session.lookup(key);
    }

    private String getHandlesRootName(JmsDestination destination, String name) {
        if (destination instanceof JmsQueue) {
            return this.getHandlesRootName(destination.getName());
        }
        return this.getHandlesRootName(name);
    }

    private String getHandlesRootNameFromDestination(String entry) {
        int index;
        String name = null;
        if (entry.startsWith(QUEUE)) {
            name = "HANDLES@" + entry.substring(QUEUE.length());
        } else if (entry.startsWith(TOPIC) && (index = entry.indexOf("@")) != -1) {
            name = "HANDLES@" + entry.substring(index + 1);
        }
        return name;
    }

    private String getHandlesRootName(String name) {
        return "HANDLES@" + name;
    }

    private String increment(String st) {
        String newId = null;
        try {
            newId = "ID:" + (Long.parseLong(st.substring(3)) + 1L);
        }
        catch (NumberFormatException err) {
            _log.error((Object)("Invalid id: " + st));
            System.exit(-1);
        }
        return newId;
    }

    private void registerEvent() {
        try {
            BasicEventManager.instance().registerEventRelative(new Event(1, this, null), this._gcInterval);
        }
        catch (IllegalEventDefinedException exception) {
            _log.error((Object)"registerEvent failed", (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

