/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.Service;
import org.exolab.core.service.ServiceException;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.config.JdbmDatabaseConfiguration;
import org.exolab.jms.config.RdbmsDatabaseConfiguration;
import org.exolab.jms.persistence.BatchingRdbmsAdapter;
import org.exolab.jms.persistence.ObjectAdapter;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.RDBMSAdapter;
import org.exolab.jms.persistence.SQLHelper;

public class DatabaseService
extends Service {
    private static final String DB_SERVICE_NAME = "DatabaseService";
    private static DatabaseService _instance = null;
    private static final Object _creator = new Object();
    private PersistenceAdapter _adapter = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$DatabaseService == null ? (class$org$exolab$jms$persistence$DatabaseService = DatabaseService.class$("org.exolab.jms.persistence.DatabaseService")) : class$org$exolab$jms$persistence$DatabaseService));
    static /* synthetic */ Class class$org$exolab$jms$persistence$DatabaseService;

    public static DatabaseService instance() throws PersistenceException {
        if (_instance == null) {
            Object object = _creator;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new DatabaseService();
                }
            }
        }
        return _instance;
    }

    public static PersistenceAdapter getAdapter() {
        return DatabaseService._instance._adapter;
    }

    public static Connection getConnection() throws PersistenceException {
        return DatabaseService.getAdapter().getConnection();
    }

    DatabaseService() throws PersistenceException {
        super(DB_SERVICE_NAME);
        Configuration config = ConfigurationManager.getConfig();
        DatabaseConfiguration dbconfig = config.getDatabaseConfiguration();
        this._adapter = dbconfig.getRdbmsDatabaseConfiguration() != null ? this.createRdbmsAdapter(dbconfig.getRdbmsDatabaseConfiguration()) : this.createJdbmAdapter(dbconfig.getJdbmDatabaseConfiguration());
    }

    public void start() throws ServiceException {
        super.start();
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                DatabaseService.getAdapter().removeExpiredMessages(connection);
                _log.info((Object)"Removed expired messages.");
                connection.commit();
            }
            catch (PersistenceException exception) {
                SQLHelper.rollback(connection);
                throw exception;
            }
            catch (Exception exception) {
                throw new ServiceException("Failed to start the DatabaseService", (Throwable)exception);
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public void stop() throws ServiceException {
        if (this._adapter != null) {
            this._adapter.close();
        }
        Object object = _creator;
        synchronized (object) {
            _instance = null;
        }
        super.stop();
    }

    private PersistenceAdapter createRdbmsAdapter(RdbmsDatabaseConfiguration config) throws PersistenceException {
        PersistenceAdapter adapter = null;
        if (config.hasBatch() && config.getBatch()) {
            _log.info((Object)("Creating EXPERIMENTAL BatchingRdbmsAdapter for " + config.getDriver()));
            adapter = new BatchingRdbmsAdapter(config.getDriver(), config.getUrl(), config.getUser(), config.getPassword(), config.getBatchSize());
        } else {
            _log.info((Object)("Creating RdbmsAdapter for " + config.getDriver()));
            adapter = new RDBMSAdapter(config.getDriver(), config.getUrl(), config.getUser(), config.getPassword());
        }
        return adapter;
    }

    private PersistenceAdapter createJdbmAdapter(JdbmDatabaseConfiguration config) throws PersistenceException {
        ObjectAdapter adapter = new ObjectAdapter(config.getName(), 10000, 40000, config.getCacheSize());
        return adapter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

