/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.exolab.jms.persistence.AbstractConnectionManager;
import org.exolab.jms.persistence.PersistenceException;

public class DBCPConnectionManager
extends AbstractConnectionManager {
    private DataSource _dataSource;

    public void init() throws PersistenceException {
        long evictionIntervalMS = this.getEvictionInterval() * 1000L;
        long minIdleTimeMS = this.getMinIdleTime() * 1000L;
        String testQuery = this.getTestQuery();
        boolean testWhileIdle = false;
        boolean testOnBorrow = false;
        if (testQuery != null) {
            testWhileIdle = true;
            testOnBorrow = this.getTestBeforeUse();
        }
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(this.getUser());
        dataSource.setPassword(this.getPassword());
        dataSource.setDriverClassName(this.getDriver());
        dataSource.setUrl(this.getURL());
        dataSource.setDefaultAutoCommit(false);
        dataSource.setPoolPreparedStatements(true);
        dataSource.setMaxActive(this.getMaxActive());
        dataSource.setMaxIdle(this.getMaxIdle());
        dataSource.setValidationQuery(testQuery);
        dataSource.setTestOnBorrow(this.getTestBeforeUse());
        dataSource.setTimeBetweenEvictionRunsMillis(evictionIntervalMS);
        dataSource.setMinEvictableIdleTimeMillis(minIdleTimeMS);
        dataSource.setTestWhileIdle(testWhileIdle);
        this._dataSource = dataSource;
    }

    public Connection getConnection() throws PersistenceException {
        Connection connection;
        try {
            connection = this._dataSource.getConnection();
        }
        catch (SQLException exception) {
            throw new PersistenceException("Failed to get pooled connection", exception);
        }
        return connection;
    }
}

