/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.foundation.HandleIfc;
import org.exolab.jms.authentication.User;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.events.EventHandler;
import org.exolab.jms.message.MessageId;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.RDBMSAdapter;
import org.exolab.jms.persistence.SQLHelper;

public class BatchingRdbmsAdapter
extends PersistenceAdapter
implements EventHandler {
    private int _maxStatementsToBatch = 500;
    private String _logDirectory = ".";
    private RDBMSAdapter _rdbms = null;
    private LinkedList _batch = new LinkedList();
    private HashMap _handles = new HashMap();
    private HashMap _messages = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$BatchingRdbmsAdapter == null ? (class$org$exolab$jms$persistence$BatchingRdbmsAdapter = BatchingRdbmsAdapter.class$("org.exolab.jms.persistence.BatchingRdbmsAdapter")) : class$org$exolab$jms$persistence$BatchingRdbmsAdapter));
    static /* synthetic */ Class class$org$exolab$jms$persistence$BatchingRdbmsAdapter;

    BatchingRdbmsAdapter(String driver, String url, String userName, String password, int batchSize) throws PersistenceException {
        this._rdbms = new RDBMSAdapter(driver, url, userName, password);
        this._maxStatementsToBatch = batchSize;
    }

    public void close() {
        if (this._rdbms != null) {
            try {
                this.flush();
            }
            catch (PersistenceException exception) {
                _log.error((Object)"Failed to flush statements", (Throwable)((Object)exception));
            }
            this._rdbms.close();
        }
    }

    public void setMaxStatementsToBatch(int max) {
        this._maxStatementsToBatch = max;
    }

    public int getMaxStatementsToBatch() {
        return this._maxStatementsToBatch;
    }

    public long getLastId(Connection connection) throws PersistenceException {
        return this._rdbms.getLastId(connection);
    }

    public void updateIds(Connection connection, long id) throws PersistenceException {
        this._rdbms.updateIds(connection, id);
    }

    public void addMessage(Connection connection, MessageImpl message) throws PersistenceException {
        this.addToBatch(1, message);
    }

    public void updateMessage(Connection connection, MessageImpl message) throws PersistenceException {
        this.addToBatch(2, message);
    }

    public Vector getUnprocessedMessages(Connection connection) throws PersistenceException {
        this.flush();
        return this._rdbms.getUnprocessedMessages(connection);
    }

    public void removeMessage(Connection connection, String id) throws PersistenceException {
        this.addToBatch(3, id);
    }

    public MessageImpl getMessage(Connection connection, String id) throws PersistenceException {
        this.flush();
        return this._rdbms.getMessage(connection, id);
    }

    public Vector getMessages(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        this.flush();
        return this._rdbms.getMessages(connection, handle);
    }

    public void addMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        this.addToBatch(4, handle);
    }

    public void updateMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        this.addToBatch(5, handle);
    }

    public void removeMessageHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        this.addToBatch(6, handle);
    }

    public Vector getMessageHandles(Connection connection, JmsDestination destination, String name) throws PersistenceException {
        this.flush();
        return this._rdbms.getMessageHandles(connection, destination, name);
    }

    public void addDurableConsumer(Connection connection, String topic, String consumer) throws PersistenceException {
        this.flush();
        this._rdbms.addDurableConsumer(connection, topic, consumer);
    }

    public void removeDurableConsumer(Connection connection, String consumer) throws PersistenceException {
        this.flush();
        this._rdbms.removeDurableConsumer(connection, consumer);
    }

    public Enumeration getDurableConsumers(Connection connection, String topic) throws PersistenceException {
        this.flush();
        return this._rdbms.getDurableConsumers(connection, topic);
    }

    public HashMap getAllDurableConsumers(Connection connection) throws PersistenceException {
        this.flush();
        return this._rdbms.getAllDurableConsumers(connection);
    }

    public boolean durableConsumerExists(Connection connection, String name) throws PersistenceException {
        this.flush();
        return this._rdbms.durableConsumerExists(connection, name);
    }

    public void addDestination(Connection connection, String name, boolean queue) throws PersistenceException {
        this.flush();
        this._rdbms.addDestination(connection, name, queue);
    }

    public void removeDestination(Connection connection, String name) throws PersistenceException {
        this.flush();
        this._rdbms.removeDestination(connection, name);
    }

    public Enumeration getAllDestinations(Connection connection) throws PersistenceException {
        this.flush();
        return this._rdbms.getAllDestinations(connection);
    }

    public boolean checkDestination(Connection connection, String name) throws PersistenceException {
        this.flush();
        return this._rdbms.checkDestination(connection, name);
    }

    public int getQueueMessageCount(Connection connection, String name) throws PersistenceException {
        this.flush();
        return this._rdbms.getQueueMessageCount(connection, name);
    }

    public int getDurableConsumerMessageCount(Connection connection, String destination, String name) throws PersistenceException {
        this.flush();
        return this._rdbms.getDurableConsumerMessageCount(connection, destination, name);
    }

    public void removeExpiredMessages(Connection connection) throws PersistenceException {
        this.flush();
        this._rdbms.removeExpiredMessages(connection);
    }

    public void removeExpiredMessageHandles(Connection connection, String consumer) throws PersistenceException {
        this.flush();
        this._rdbms.removeExpiredMessageHandles(connection, consumer);
    }

    public Vector getNonExpiredMessages(Connection connection, JmsDestination destination) throws PersistenceException {
        this.flush();
        return this._rdbms.getNonExpiredMessages(connection, destination);
    }

    public Connection getConnection() throws PersistenceException {
        return this._rdbms.getConnection();
    }

    public synchronized int purgeMessages() {
        try {
            this.flush();
        }
        catch (PersistenceException exception) {
            _log.error((Object)("Error in purgeMessages " + (Object)((Object)exception)));
        }
        return this._rdbms.purgeMessages();
    }

    public void handleEvent(int event, Object callback, long time) {
        this._rdbms.handleEvent(event, callback, time);
    }

    public HandleIfc getHandle() {
        return null;
    }

    private synchronized void flush() throws PersistenceException {
        if (this._batch.size() == 0) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                Connection connection = null;
                connection = BatchingRdbmsAdapter.this._rdbms.getConnection();
                Iterator iter = BatchingRdbmsAdapter.this._batch.iterator();
                while (iter.hasNext()) {
                    TransactionalObjectWrapper wrapper = (TransactionalObjectWrapper)iter.next();
                    switch (wrapper._action) {
                        case 1: {
                            BatchingRdbmsAdapter.this._rdbms.addMessage(connection, (MessageImpl)wrapper._object);
                            break;
                        }
                        case 2: {
                            BatchingRdbmsAdapter.this._rdbms.updateMessage(connection, (MessageImpl)wrapper._object);
                            break;
                        }
                        case 3: {
                            BatchingRdbmsAdapter.this._rdbms.removeMessage(connection, (String)wrapper._object);
                            break;
                        }
                        case 4: {
                            BatchingRdbmsAdapter.this._rdbms.addMessageHandle(connection, (PersistentMessageHandle)wrapper._object);
                            break;
                        }
                        case 5: {
                            BatchingRdbmsAdapter.this._rdbms.updateMessageHandle(connection, (PersistentMessageHandle)wrapper._object);
                            break;
                        }
                        case 6: {
                            BatchingRdbmsAdapter.this._rdbms.removeMessageHandle(connection, (PersistentMessageHandle)wrapper._object);
                        }
                    }
                }
                connection.commit();
                BatchingRdbmsAdapter.this._batch.clear();
                BatchingRdbmsAdapter.this._messages.clear();
                BatchingRdbmsAdapter.this._handles.clear();
                Object var5_6 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception nested) {
                    _log.error((Object)"Failure in flush()", (Throwable)nested);
                }
                return;
                {
                    catch (PersistenceException exception) {
                        SQLHelper.rollback(connection);
                        _log.error((Object)"Failure in flush()", (Throwable)((Object)exception));
                        Object var5_7 = null;
                        if (connection == null) return;
                        try {
                            connection.close();
                            return;
                        }
                        catch (Exception nested) {
                            _log.error((Object)"Failure in flush()", (Throwable)nested);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        _log.error((Object)"Failure in flush()", (Throwable)exception);
                        Object var5_8 = null;
                        if (connection == null) return;
                        try {
                            connection.close();
                            return;
                        }
                        catch (Exception nested) {
                            _log.error((Object)"Failure in flush()", (Throwable)nested);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (connection == null) throw throwable;
                    try {
                        connection.close();
                        throw throwable;
                    }
                    catch (Exception nested) {
                        _log.error((Object)"Failure in flush()", (Throwable)nested);
                    }
                    throw throwable;
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void addToBatch(int action, Object object) throws PersistenceException {
        if (this._batch.size() >= this._maxStatementsToBatch) {
            this.flush();
        }
        switch (action) {
            case 1: {
                TransactionalObjectWrapper txobj = new TransactionalObjectWrapper(action, object);
                MessageImpl message = (MessageImpl)object;
                MessageId id = message.getMessageId();
                if (this._messages.containsKey(id)) {
                    throw new PersistenceException("Inconsistency in cache " + id + " is present when it shouldn't be.");
                }
                this._messages.put(id, txobj);
                this._batch.addLast(txobj);
                return;
            }
            case 2: {
                MessageImpl message = (MessageImpl)object;
                MessageId id = message.getMessageId();
                TransactionalObjectWrapper txobj = (TransactionalObjectWrapper)this._messages.get(id);
                TransactionalObjectWrapper newtxobj = new TransactionalObjectWrapper(action, object);
                if (txobj != null) {
                    this._batch.remove(txobj);
                    if (txobj._action == 1) {
                        newtxobj._action = 1;
                        this._batch.addLast(newtxobj);
                    } else {
                        if (txobj._action != 2) throw new PersistenceException("Inconsistency in cache. Cannot update a deleted message.");
                        this._batch.addLast(newtxobj);
                    }
                } else {
                    this._batch.addLast(newtxobj);
                }
                this._messages.put(id, newtxobj);
                return;
            }
            case 3: {
                MessageImpl message = (MessageImpl)object;
                MessageId id = message.getMessageId();
                TransactionalObjectWrapper txobj = (TransactionalObjectWrapper)this._messages.get(id);
                TransactionalObjectWrapper newtxobj = new TransactionalObjectWrapper(action, object);
                if (txobj != null) {
                    this._batch.remove(txobj);
                    if (txobj._action != 1 && txobj._action == 2) {
                        this._batch.addLast(newtxobj);
                    }
                } else {
                    this._batch.addLast(newtxobj);
                }
                this._messages.put(id, newtxobj);
                return;
            }
            case 4: {
                TransactionalObjectWrapper txobj = new TransactionalObjectWrapper(action, object);
                PersistentMessageHandle handle = (PersistentMessageHandle)object;
                if (this._handles.containsKey(handle)) {
                    throw new PersistenceException("Inconsistency in cache " + handle + " is present when it shouldn't be.");
                }
                this._handles.put(handle, txobj);
                this._batch.addLast(txobj);
                return;
            }
            case 5: {
                PersistentMessageHandle handle = (PersistentMessageHandle)object;
                TransactionalObjectWrapper txobj = (TransactionalObjectWrapper)this._handles.get(handle);
                TransactionalObjectWrapper newtxobj = new TransactionalObjectWrapper(action, object);
                if (txobj != null) {
                    this._batch.remove(txobj);
                    if (txobj._action == 4) {
                        newtxobj._action = 4;
                        this._batch.addLast(newtxobj);
                    } else {
                        if (txobj._action != 5) throw new PersistenceException("Inconsistency in cache. Cannot update a deleted handle.");
                        this._batch.addLast(newtxobj);
                    }
                } else {
                    this._batch.addLast(newtxobj);
                }
                this._handles.put(handle, newtxobj);
                return;
            }
            case 6: {
                PersistentMessageHandle handle = (PersistentMessageHandle)object;
                TransactionalObjectWrapper txobj = (TransactionalObjectWrapper)this._handles.get(handle);
                TransactionalObjectWrapper newtxobj = new TransactionalObjectWrapper(action, object);
                if (txobj != null) {
                    this._batch.remove(txobj);
                    if (txobj._action != 4 && txobj._action == 5) {
                        this._batch.addLast(newtxobj);
                    }
                } else {
                    this._batch.addLast(newtxobj);
                }
                this._handles.put(handle, newtxobj);
                return;
            }
        }
    }

    public void addUser(Connection connection, User user) throws PersistenceException {
    }

    public Enumeration getAllUsers(Connection connection) throws PersistenceException {
        return null;
    }

    public User getUser(Connection connection, User user) throws PersistenceException {
        return null;
    }

    public void removeUser(Connection connection, User user) throws PersistenceException {
    }

    public void updateUser(Connection connection, User user) throws PersistenceException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TransactionalObjectWrapper {
        public static final int ADD_MESSAGE = 1;
        public static final int UPDATE_MESSAGE = 2;
        public static final int DELETE_MESSAGE = 3;
        public static final int ADD_HANDLE = 4;
        public static final int UPDATE_HANDLE = 5;
        public static final int DELETE_HANDLE = 6;
        public int _action;
        public Object _object;

        public TransactionalObjectWrapper(int action, Object object) {
            this._action = action;
            this._object = object;
        }
    }
}

