/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageId;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.MessageMgr;

public class TransientMessageHandle
implements MessageHandle {
    static final long serialVersionUID = 2L;
    private MessageId _id = null;
    private boolean _delivered = false;
    private int _priority = 4;
    private long _acceptedTime;
    private transient long _clientId = -1L;
    private long _sequenceNumber;
    private long _expiryTime;
    private JmsDestination _destination;
    private String _consumerName;
    private boolean _persistent = false;

    public TransientMessageHandle() {
    }

    TransientMessageHandle(MessageImpl message) throws JMSException {
        this._id = message.getMessageId();
        this._priority = message.getJMSPriority();
        this._acceptedTime = message.getAcceptedTime();
        this._delivered = message.getJMSRedelivered();
        this._sequenceNumber = message.getSequenceNumber();
        this._expiryTime = message.getJMSExpiration();
        this._destination = (JmsDestination)message.getJMSDestination();
        this._clientId = message.getClientId();
        if (message.getJMSDeliveryMode() == 2) {
            this._persistent = true;
        }
    }

    public MessageId getMessageId() {
        return this._id;
    }

    public void setMessageId(MessageId id) {
        this._id = id;
    }

    public void setDelivered() {
        this._delivered = true;
    }

    public void setDelivered(boolean value) {
        this._delivered = value;
    }

    public boolean getDelivered() {
        return this._delivered;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setAcceptedTime(long time) {
        this._acceptedTime = time;
    }

    public long getAcceptedTime() {
        return this._acceptedTime;
    }

    public void setExpiryTime(long time) {
        this._expiryTime = time;
    }

    public long getExpiryTime() {
        return this._expiryTime;
    }

    public void setSequenceNumber(long seq) {
        this._sequenceNumber = seq;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void setDestination(JmsDestination destination) {
        this._destination = destination;
    }

    public JmsDestination getDestination() {
        return this._destination;
    }

    public void setClientId(long clientId) {
        this._clientId = clientId;
    }

    public long getClientId() {
        return this._clientId;
    }

    public void setConsumerName(String name) {
        this._consumerName = name;
    }

    public String getConsumerName() {
        return this._consumerName;
    }

    public MessageImpl getMessage() {
        return MessageMgr.instance().getMessage(this);
    }

    public String toString() {
        return "Handle : " + this._priority + ":" + this.getAcceptedTime() + ":" + this.getSequenceNumber() + ":" + this._id;
    }

    public void clear() {
        this._id = null;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void destroy() {
        MessageMgr.instance().handleDestroyed(this);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TransientMessageHandle) {
            return this._id.equals(((TransientMessageHandle)object)._id);
        }
        return false;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(2L);
        stream.writeObject(this._id);
        stream.writeInt(this._priority);
        stream.writeBoolean(this._delivered);
        stream.writeLong(this._acceptedTime);
        stream.writeLong(this._sequenceNumber);
        stream.writeLong(this._expiryTime);
        stream.writeObject(this._destination);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version == 2L) {
            this._id = (MessageId)stream.readObject();
            this._priority = stream.readInt();
            this._delivered = stream.readBoolean();
            this._acceptedTime = stream.readLong();
            this._sequenceNumber = stream.readLong();
            this._expiryTime = stream.readLong();
            this._destination = (JmsDestination)stream.readObject();
        } else if (version == 1L) {
            this._id = (MessageId)stream.readObject();
            this._priority = stream.readInt();
            this._delivered = stream.readBoolean();
            this._acceptedTime = stream.readLong();
            this._sequenceNumber = stream.readLong();
            this._expiryTime = stream.readLong();
            this._destination = null;
        } else {
            throw new IOException("TransientMessageHandle with version " + version + " is not supported.");
        }
    }
}

