/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationCacheEventListener;
import org.exolab.jms.messagemgr.DurableConsumerEndpoint;
import org.exolab.jms.messagemgr.FailedToInitializeException;
import org.exolab.jms.messagemgr.TopicConsumerEndpoint;
import org.exolab.jms.persistence.PersistenceException;

public class TopicDestinationCache
extends DestinationCache {
    private JmsTopic _topic = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$TopicDestinationCache == null ? (class$org$exolab$jms$messagemgr$TopicDestinationCache = TopicDestinationCache.class$("org.exolab.jms.messagemgr.TopicDestinationCache")) : class$org$exolab$jms$messagemgr$TopicDestinationCache));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$TopicDestinationCache;

    TopicDestinationCache(JmsTopic destination) throws FailedToInitializeException {
        this._topic = destination;
        try {
            this.init();
        }
        catch (FailedToInitializeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FailedToInitializeException("Failed to construct TopicDestinationCache " + exception.toString());
        }
    }

    TopicDestinationCache(Connection connection, JmsTopic destination) throws FailedToInitializeException {
        this._topic = destination;
        try {
            this.init(connection);
        }
        catch (FailedToInitializeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FailedToInitializeException("Failed to construct TopicDestinationCache " + exception.toString());
        }
    }

    public JmsDestination getDestination() {
        return this._topic;
    }

    public boolean messageAdded(JmsDestination destination, MessageImpl message) {
        boolean processed = false;
        if (destination != null && message != null && destination.equals(this._topic) && (processed = this.notifyOnAddMessage(message))) {
            this.checkMessageExpiry(message);
        }
        return processed;
    }

    public void messageRemoved(JmsDestination destination, MessageImpl message) {
        if (destination != null && message != null && destination.equals(this._topic)) {
            this.notifyOnRemoveMessage(message);
        }
    }

    public boolean persistentMessageAdded(Connection connection, JmsDestination destination, MessageImpl message) throws PersistenceException {
        boolean processed = false;
        if (destination != null && message != null && destination.equals(this._topic) && (processed = this.notifyOnAddPersistentMessage(connection, message))) {
            this.checkMessageExpiry(message);
        }
        return processed;
    }

    public void persistentMessageRemoved(Connection connection, JmsDestination destination, MessageImpl message) throws PersistenceException {
        if (destination != null && message != null && destination.equals(this._topic)) {
            this.notifyOnRemovePersistentMessage(connection, message);
        }
    }

    boolean notifyOnAddMessage(MessageImpl message) {
        boolean processed = true;
        Object[] iter = this.getConsumersByArray();
        int index = 0;
        while (index < iter.length) {
            DestinationCacheEventListener listener = (DestinationCacheEventListener)iter[index];
            processed |= listener.messageAdded(message);
            ++index;
        }
        return processed;
    }

    void notifyOnRemoveMessage(MessageImpl message) {
        Object[] iter = this.getConsumersByArray();
        int index = 0;
        while (index < iter.length) {
            if (((DestinationCacheEventListener)iter[index]).messageRemoved(message)) {
                // empty if block
            }
            ++index;
        }
    }

    boolean notifyOnAddPersistentMessage(Connection connection, MessageImpl message) throws PersistenceException {
        boolean processed = true;
        Object[] iter = this.getConsumersByArray();
        int index = 0;
        while (index < iter.length) {
            DestinationCacheEventListener listener = (DestinationCacheEventListener)iter[index];
            processed |= listener.persistentMessageAdded(connection, message);
            ++index;
        }
        return processed;
    }

    void notifyOnRemovePersistentMessage(Connection connection, MessageImpl message) throws PersistenceException {
        Object[] iter = this.getConsumersByArray();
        int index = 0;
        while (index < iter.length) {
            DestinationCacheEventListener listener = (DestinationCacheEventListener)iter[index];
            if (listener instanceof DurableConsumerEndpoint) {
                listener.persistentMessageRemoved(connection, message);
            } else if (listener instanceof TopicConsumerEndpoint) {
                listener.messageRemoved(message);
            }
            ++index;
        }
        try {
            ConsumerManager.instance().persistentMessageRemoved(connection, message);
        }
        catch (Exception exception) {
            _log.error((Object)"Error in notifyOnRemovePersistentMessage", (Throwable)exception);
        }
    }

    public boolean registerConsumer(ConsumerEndpoint consumer) {
        JmsTopic ddest;
        boolean result = false;
        JmsTopic cdest = (JmsTopic)consumer.getDestination();
        if (cdest.match(ddest = (JmsTopic)this.getDestination()) && !this._consumers.contains(consumer)) {
            this._consumers.add(consumer);
            consumer.setMaximumSize(this.getMaximumSize());
            result = true;
        }
        return result;
    }

    boolean hasActiveConsumers() {
        return this._consumers.size() > 0;
    }

    public int getMessageCount() {
        return 0;
    }

    public boolean canDestroy() {
        return !this.hasActiveConsumers();
    }

    public String toString() {
        return this._topic.toString();
    }

    public int hashCode() {
        return this._topic.hashCode();
    }

    protected MessageImpl resolveExpiredMessage(MessageHandle handle) {
        MessageImpl message = null;
        if (handle.getConsumerName() != null) {
            message = super.resolveExpiredMessage(handle);
        } else {
            Iterator iterator = this._consumers.iterator();
            while (iterator.hasNext()) {
                ConsumerEndpoint endpoint = (ConsumerEndpoint)iterator.next();
                message = endpoint.getMessage(handle);
                if (message != null) break;
            }
        }
        return message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

