/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationEventListener;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.TopicDestinationCache;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.ClientDisconnectionException;
import org.exolab.jms.server.JmsServerSession;

public class TopicConsumerEndpoint
extends ConsumerEndpoint
implements DestinationEventListener {
    protected HashMap _caches = new HashMap();
    protected JmsTopic _topic = null;
    private final int MAX_MESSAGES = 200;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$TopicConsumerEndpoint == null ? (class$org$exolab$jms$messagemgr$TopicConsumerEndpoint = TopicConsumerEndpoint.class$("org.exolab.jms.messagemgr.TopicConsumerEndpoint")) : class$org$exolab$jms$messagemgr$TopicConsumerEndpoint));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$TopicConsumerEndpoint;

    TopicConsumerEndpoint(JmsServerSession session, long clientId, JmsTopic topic, String selector, Scheduler scheduler) throws InvalidSelectorException, JMSException {
        super(session, clientId, selector, scheduler);
        DestinationManager destmgr = DestinationManager.instance();
        if (topic != null) {
            this._topic = topic;
            if (this._topic.isWildCard()) {
                this._caches = destmgr.getTopicDestinationCaches(topic);
                destmgr.addDestinationEventListener(this);
                Iterator iter = this._caches.values().iterator();
                while (iter.hasNext()) {
                    ((TopicDestinationCache)iter.next()).registerConsumer(this);
                }
            } else {
                DestinationCache cache = destmgr.getDestinationCache(topic);
                if (cache == null) {
                    cache = destmgr.createDestinationCache(topic);
                }
                this._caches.put(topic, cache);
                cache.registerConsumer(this);
            }
        }
    }

    public boolean deliverMessages() {
        boolean reschedule = true;
        int index = 0;
        while (index < 200) {
            if (this.stopDelivery()) {
                reschedule = false;
                break;
            }
            boolean processed = true;
            MessageHandle handle = this.removeFirstMessage();
            try {
                if (this._selector != null) {
                    MessageImpl m = handle.getMessage();
                    if (m != null && this._selector.selects(m)) {
                        handle.setClientId(this.getClientId());
                        this._listener.onMessage(handle, true);
                        ++index;
                        continue;
                    }
                    handle.destroy();
                    continue;
                }
                handle.setClientId(this.getClientId());
                this._listener.onMessage(handle, true);
                ++index;
            }
            catch (ClientDisconnectionException exception) {
                this._listener = null;
                this.returnMessage(handle);
            }
            catch (JMSException exception) {
                if (exception.getErrorCode().equals("FailedToResolveHandle")) {
                    _log.error((Object)("Dropping handle " + handle + " since we cannot resolve it."));
                    continue;
                }
                _log.error((Object)exception, (Throwable)exception);
                this.returnMessage(handle);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                this.returnMessage(handle);
            }
        }
        return reschedule;
    }

    public MessageHandle receiveMessage(long wait) {
        Object object = this._waitingForMessageMonitor;
        synchronized (object) {
            MessageHandle handle = this.receiveNoWait();
            if (handle == null && wait >= 0L) {
                this.setWaitingForMessage();
            }
            MessageHandle messageHandle = handle;
            return messageHandle;
        }
    }

    public MessageHandle receiveNoWait() {
        MessageHandle handle = null;
        while ((handle = this.removeFirstMessage()) != null) {
            MessageImpl message = handle.getMessage();
            if (message != null) {
                if (this._selector == null || this._selector.selects(message)) {
                    handle.setClientId(this.getClientId());
                    break;
                }
                handle.destroy();
            }
            handle = null;
        }
        return handle;
    }

    public boolean messageRemoved(MessageImpl message) {
        boolean result = false;
        if (message != null) {
            try {
                MessageHandle handle = MessageHandleFactory.getHandle(this, message);
                if (this.removeMessage(handle)) {
                    if (handle.getConsumerName() == null) {
                        handle.setConsumerName(this.getPersistentId());
                    }
                    handle.destroy();
                    result = true;
                }
            }
            catch (JMSException exception) {
                _log.error((Object)"Failed to remove message from endpoint", (Throwable)exception);
            }
        }
        return result;
    }

    public boolean persistentMessageRemoved(Connection connection, MessageImpl message) throws PersistenceException {
        boolean result = false;
        if (message != null) {
            try {
                PersistentMessageHandle handle = (PersistentMessageHandle)MessageHandleFactory.getHandle(this, message);
                if (this.removeMessage(handle)) {
                    MessageHandleFactory.destroyPersistentHandle(connection, handle);
                    result = true;
                }
            }
            catch (JMSException exception) {
                _log.error((Object)"Failed to remove persistent message from endpoint", (Throwable)exception);
            }
        }
        return result;
    }

    public JmsDestination getDestination() {
        return this._topic;
    }

    public void unregister() {
        Iterator iter = this._caches.values().iterator();
        while (iter.hasNext()) {
            ((TopicDestinationCache)iter.next()).unregisterConsumer(this);
        }
        this._caches.clear();
    }

    public void recover() {
    }

    public void destinationAdded(JmsDestination destination, DestinationCache cache) {
        if (destination instanceof JmsTopic && this._topic.match((JmsTopic)destination) && !this._caches.containsKey(destination)) {
            HashMap hashMap = this._caches;
            synchronized (hashMap) {
                this._caches.put(destination, cache);
            }
            ((TopicDestinationCache)cache).registerConsumer(this);
            _log.debug((Object)(this._topic + " registered with " + destination));
        }
    }

    public void destinationRemoved(JmsDestination destination, DestinationCache cache) {
        if (destination instanceof JmsTopic && this._caches.containsKey(destination)) {
            HashMap hashMap = this._caches;
            synchronized (hashMap) {
                this._caches.remove(destination);
            }
            _log.debug((Object)(this._topic + " unregistered with " + destination));
        }
    }

    protected void doClose() {
        DestinationManager.instance().removeDestinationEventListener(this);
        Iterator iter = this._caches.values().iterator();
        while (iter.hasNext()) {
            ((TopicDestinationCache)iter.next()).unregisterConsumer(this);
        }
        this._caches.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

